/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.struct.Seq;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import java.util.Arrays;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.io.JsonIO;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.modules.ItemModule;

public class ItemSeq
implements Iterable<ItemStack>,
Json.JsonSerializable {
    protected final int[] values;
    public int total;

    public ItemSeq() {
        this.values = new int[Vars.content.items().size];
    }

    public ItemSeq(Seq<ItemStack> stacks) {
        this.values = new int[Vars.content.items().size];
        stacks.each(this::add);
    }

    public void checkNegative() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] >= 0) continue;
            this.values[i] = 0;
        }
    }

    public ItemSeq copy() {
        ItemSeq out = new ItemSeq();
        out.total = this.total;
        System.arraycopy(this.values, 0, out.values, 0, this.values.length);
        return out;
    }

    public void each(ItemModule.ItemConsumer cons) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == 0) continue;
            cons.accept(Vars.content.item(i), this.values[i]);
        }
    }

    public void clear() {
        this.total = 0;
        Arrays.fill(this.values, 0);
    }

    public Seq<ItemStack> toSeq() {
        Seq<ItemStack> out = new Seq<ItemStack>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == 0) continue;
            out.add(new ItemStack(Vars.content.item(i), this.values[i]));
        }
        return out;
    }

    public void min(int number) {
        for (Item item : Vars.content.items()) {
            this.set(item, Math.min(this.get(item), number));
        }
    }

    public boolean has(Item item) {
        return this.values[item.id] > 0;
    }

    public boolean has(ItemSeq seq) {
        for (int i = 0; i < this.values.length; ++i) {
            if (seq.values[i] <= this.values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean has(Item item, int amount) {
        return this.values[item.id] >= amount;
    }

    public int get(Item item) {
        return this.values[item.id];
    }

    public void set(Item item, int amount) {
        this.add(item, amount - this.values[item.id]);
    }

    public void add(ItemModule itemModule) {
        itemModule.each(this::add);
    }

    public void add(ItemSeq seq) {
        seq.each(this::add);
    }

    public void add(ItemStack stack) {
        this.add(stack.item, stack.amount);
    }

    public void add(Item item) {
        this.add(item, 1);
    }

    public void add(Item item, int amount) {
        short s = item.id;
        this.values[s] = this.values[s] + amount;
        this.total += amount;
    }

    public void remove(ItemStack stack) {
        this.add(stack.item, -stack.amount);
    }

    public void remove(Item item) {
        this.add(item, -1);
    }

    public void remove(Item item, int amount) {
        this.add(item, -amount);
    }

    @Override
    public void write(Json json) {
        for (Item item : Vars.content.items()) {
            if (this.values[item.id] == 0) continue;
            json.writeValue(item.name, this.values[item.id]);
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.total = 0;
        for (Item item : Vars.content.items()) {
            this.values[item.id] = jsonData.getInt(item.name, 0);
            this.total += this.values[item.id];
        }
    }

    public String toString() {
        return JsonIO.print(JsonIO.write(this));
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.toSeq().iterator();
    }
}

