/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.math.Mathf;
import arc.struct.Seq;
import mindustry.content.Items;
import mindustry.type.Item;

public class ItemStack
implements Comparable<ItemStack> {
    public static final ItemStack[] empty = new ItemStack[0];
    public Item item;
    public int amount = 0;

    public ItemStack(Item item, int amount) {
        if (item == null) {
            item = Items.copper;
        }
        this.item = item;
        this.amount = amount;
    }

    public ItemStack() {
        this.item = Items.copper;
    }

    public ItemStack set(Item item, int amount) {
        this.item = item;
        this.amount = amount;
        return this;
    }

    public ItemStack copy() {
        return new ItemStack(this.item, this.amount);
    }

    public boolean equals(ItemStack other) {
        return other != null && other.item == this.item && other.amount == this.amount;
    }

    public static ItemStack[] mult(ItemStack[] stacks, float amount) {
        ItemStack[] copy = new ItemStack[stacks.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new ItemStack(stacks[i].item, Mathf.round((float)stacks[i].amount * amount));
        }
        return copy;
    }

    public static ItemStack[] with(Object ... items) {
        ItemStack[] stacks = new ItemStack[items.length / 2];
        for (int i = 0; i < items.length; i += 2) {
            stacks[i / 2] = new ItemStack((Item)items[i], ((Number)items[i + 1]).intValue());
        }
        return stacks;
    }

    public static Seq<ItemStack> list(Object ... items) {
        Seq<ItemStack> stacks = new Seq<ItemStack>(items.length / 2);
        for (int i = 0; i < items.length; i += 2) {
            stacks.add(new ItemStack((Item)items[i], ((Number)items[i + 1]).intValue()));
        }
        return stacks;
    }

    @Override
    public int compareTo(ItemStack itemStack) {
        return this.item.compareTo(itemStack.item);
    }

    public boolean equals(Object o) {
        ItemStack stack;
        if (this == o) {
            return true;
        }
        Object object = o;
        if (!(object instanceof ItemStack) || (stack = (ItemStack)object) != (ItemStack)object) {
            return false;
        }
        return this.amount == stack.amount && this.item == stack.item;
    }

    public String toString() {
        return "ItemStack{item=" + this.item + ", amount=" + this.amount + '}';
    }
}

