/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.graphics.Color;
import arc.util.Nullable;
import mindustry.content.StatusEffects;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.type.StatusEffect;
import mindustry.world.meta.Stat;

public class Liquid
extends UnlockableContent {
    public Color color;
    @Nullable
    public Color barColor;
    public Color lightColor = Color.clear.cpy();
    public float flammability;
    public float temperature = 0.5f;
    public float heatCapacity = 0.5f;
    public float viscosity = 0.5f;
    public float explosiveness;
    public StatusEffect effect = StatusEffects.none;

    public Liquid(String name, Color color) {
        super(name);
        this.color = new Color(color);
    }

    public Liquid(String name) {
        this(name, new Color(Color.black));
    }

    public boolean canExtinguish() {
        return this.flammability < 0.1f && this.temperature <= 0.5f;
    }

    public Color barColor() {
        return this.barColor == null ? this.color : this.barColor;
    }

    @Override
    public void setStats() {
        this.stats.addPercent(Stat.explosiveness, this.explosiveness);
        this.stats.addPercent(Stat.flammability, this.flammability);
        this.stats.addPercent(Stat.temperature, this.temperature);
        this.stats.addPercent(Stat.heatCapacity, this.heatCapacity);
        this.stats.addPercent(Stat.viscosity, this.viscosity);
    }

    @Override
    public String toString() {
        return this.localizedName;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.liquid;
    }
}

