/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Intersector3D;
import arc.math.geom.Mat3D;
import arc.math.geom.Ray;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.noise.Noise;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.ShaderSphereMesh;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Satellite;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;

public class Planet
extends UnlockableContent {
    private static final float orbitSpacing = 9.0f;
    private static final Vec3 intersectResult = new Vec3();
    @Nullable
    public PlanetMesh mesh;
    public Vec3 position = new Vec3();
    @Nullable
    public PlanetGrid grid;
    @Nullable
    public PlanetGenerator generator;
    public Seq<Sector> sectors;
    public float radius;
    public float atmosphereRadIn = 0.0f;
    public float atmosphereRadOut = 0.3f;
    public float orbitRadius;
    public float totalRadius;
    public float orbitTime;
    public float rotateTime = 1440.0f;
    public float sectorApproxRadius;
    public boolean tidalLock = false;
    public boolean accessible = true;
    public int startSector = 0;
    public boolean bloom = false;
    public boolean visible = true;
    public Color lightColor = Color.white.cpy();
    public Color atmosphereColor = new Color(0.3f, 0.7f, 1.0f);
    public boolean hasAtmosphere = true;
    @Nullable
    public Planet parent;
    public Planet solarSystem;
    public Seq<Planet> children = new Seq();
    public Seq<Satellite> satellites = new Seq();
    protected Prov<PlanetMesh> meshLoader = () -> new ShaderSphereMesh(this, Shaders.unlit, 2);

    public Planet(String name, Planet parent, int sectorSize, float radius) {
        super(name);
        this.radius = radius;
        this.parent = parent;
        if (sectorSize > 0) {
            this.grid = PlanetGrid.create(sectorSize);
            this.sectors = new Seq(this.grid.tiles.length);
            for (int i = 0; i < this.grid.tiles.length; ++i) {
                this.sectors.add(new Sector(this, this.grid.tiles[i]));
            }
            this.sectorApproxRadius = this.sectors.first().tile.v.dst(this.sectors.first().tile.corners[0].v);
        } else {
            this.sectors = new Seq();
        }
        this.totalRadius += radius;
        this.orbitRadius = parent == null ? 0.0f : parent.totalRadius + 9.0f + this.totalRadius;
        this.orbitTime = Mathf.pow(this.orbitRadius, 1.5f) * 1000.0f;
        if (parent != null) {
            parent.children.add(this);
            parent.updateTotalRadius();
        }
        this.solarSystem = this;
        while (this.solarSystem.parent != null) {
            this.solarSystem = this.solarSystem.parent;
        }
    }

    @Nullable
    public Sector getLastSector() {
        return this.sectors.get(Math.min(Core.settings.getInt(this.name + "-last-sector", this.startSector), this.sectors.size - 1));
    }

    public void setLastSector(Sector sector) {
        Core.settings.put(this.name + "-last-sector", sector.id);
    }

    public void preset(int index, SectorPreset preset) {
        this.sectors.get((int)index).preset = preset;
    }

    public boolean isLandable() {
        return this.grid != null && this.generator != null && this.sectors.size > 0;
    }

    public void updateTotalRadius() {
        this.totalRadius = this.radius;
        for (Planet planet : this.children) {
            this.totalRadius = Math.max(this.totalRadius, planet.orbitRadius + planet.totalRadius);
        }
    }

    public Vec3 getLightNormal() {
        return Tmp.v31.set(this.solarSystem.position).sub(this.position).nor();
    }

    public float getOrbitAngle() {
        float offset = Mathf.randomSeed(this.id, 360.0f);
        return (offset + Vars.universe.secondsf() / (this.orbitTime / 360.0f)) % 360.0f;
    }

    public float getRotation() {
        if (this.tidalLock) {
            return this.getOrbitAngle();
        }
        float offset = Mathf.randomSeed(this.id + 1, 360.0f);
        return (offset + Vars.universe.secondsf() / (this.rotateTime / 360.0f)) % 360.0f;
    }

    public Vec3 addParentOffset(Vec3 in) {
        if (this.parent == null || Mathf.zero(this.orbitRadius)) {
            return in;
        }
        float angle = this.getOrbitAngle();
        return in.add(Angles.trnsx(angle, this.orbitRadius), 0.0f, Angles.trnsy(angle, this.orbitRadius));
    }

    public Vec3 getWorldPosition(Vec3 in) {
        in.setZero();
        Planet current = this;
        while (current != null) {
            current.addParentOffset(in);
            current = current.parent;
        }
        return in;
    }

    public void updateBaseCoverage() {
        for (Sector sector : this.sectors) {
            float sum = 1.0f;
            for (Sector other : sector.near()) {
                if (!other.generateEnemyBase) continue;
                sum += 0.9f;
            }
            if (sector.hasEnemyBase()) {
                sum += 0.88f;
            }
            sector.threat = sector.preset == null ? Math.min(sum / 5.0f, 1.2f) : Mathf.clamp(sector.preset.difficulty / 10.0f);
        }
    }

    public Mat3D getTransform(Mat3D mat) {
        return mat.setToTranslation(this.position).rotate(Vec3.Y, this.getRotation());
    }

    @Override
    public void load() {
        this.mesh = this.meshLoader.get();
    }

    @Override
    public void init() {
        for (Sector sector : this.sectors) {
            sector.loadInfo();
        }
        if (this.generator != null) {
            Noise.setSeed(this.id + 1);
            for (Sector sector : this.sectors) {
                this.generator.generateSector(sector);
            }
            this.updateBaseCoverage();
        }
    }

    @Override
    public void dispose() {
        if (this.mesh != null) {
            this.mesh.dispose();
            this.mesh = null;
        }
    }

    public Sector getSector(PlanetGrid.Ptile tile) {
        return this.sectors.get(tile.id);
    }

    @Nullable
    public Sector getSector(Ray ray) {
        return this.getSector(ray, this.radius);
    }

    @Nullable
    public Sector getSector(Ray ray, float radius) {
        Vec3 vec = this.intersect(ray, radius);
        if (vec == null) {
            return null;
        }
        vec.sub(this.position).rotate(Vec3.Y, this.getRotation());
        return this.sectors.min(t -> t.tile.v.dst2(vec));
    }

    @Nullable
    public Vec3 intersect(Ray ray, float radius) {
        boolean found = Intersector3D.intersectRaySphere(ray, this.position, radius, intersectResult);
        if (!found) {
            return null;
        }
        return intersectResult;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.planet;
    }

    public boolean visible() {
        return this.visible;
    }

    public void draw(Mat3D projection, Mat3D transform) {
        this.mesh.render(projection, transform);
    }
}

