/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.func.Cons;
import arc.graphics.g2d.TextureRegion;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.maps.generators.FileMapGenerator;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Cicon;

public class SectorPreset
extends UnlockableContent {
    public FileMapGenerator generator;
    public Planet planet;
    public Sector sector;
    public int captureWave = 0;
    public Cons<Rules> rules = rules -> {
        rules.winWave = this.captureWave;
    };
    public boolean useAI = true;
    public float difficulty;
    public boolean addStartingItems = false;

    public SectorPreset(String name, Planet planet, int sector) {
        super(name);
        this.generator = new FileMapGenerator(name, this);
        this.planet = planet;
        this.sector = planet.sectors.get(sector %= planet.sectors.size);
        this.inlineDescription = false;
        planet.preset(sector, this);
    }

    @Override
    public TextureRegion icon(Cicon c) {
        return Icon.terrain.getRegion();
    }

    @Override
    public boolean isHidden() {
        return this.description == null;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.sector;
    }
}

