/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.units.StatusEntry;
import mindustry.gen.Unit;
import mindustry.ui.Cicon;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class StatusEffect
extends UnlockableContent {
    public float damageMultiplier = 1.0f;
    public float healthMultiplier = 1.0f;
    public float speedMultiplier = 1.0f;
    public float reloadMultiplier = 1.0f;
    public float buildSpeedMultiplier = 1.0f;
    public float dragMultiplier = 1.0f;
    public float transitionDamage = 0.0f;
    public boolean disarm = false;
    public float damage;
    public float effectChance = 0.15f;
    public boolean permanent;
    public boolean reactive;
    public Color color = Color.white.cpy();
    public Effect effect = Fx.none;
    protected ObjectMap<StatusEffect, TransitionHandler> transitions = new ObjectMap();
    protected Runnable initblock = () -> {};
    public ObjectSet<StatusEffect> affinities = new ObjectSet();
    public ObjectSet<StatusEffect> opposites = new ObjectSet();

    public StatusEffect(String name) {
        super(name);
    }

    @Override
    public void init() {
        this.initblock.run();
    }

    public void init(Runnable run) {
        this.initblock = run;
    }

    @Override
    public boolean isHidden() {
        return this.localizedName.equals(this.name);
    }

    @Override
    public void setStats() {
        StatusEffect other;
        if (this.damageMultiplier != 1.0f) {
            this.stats.addPercent(Stat.damageMultiplier, this.damageMultiplier);
        }
        if (this.healthMultiplier != 1.0f) {
            this.stats.addPercent(Stat.healthMultiplier, this.healthMultiplier);
        }
        if (this.speedMultiplier != 1.0f) {
            this.stats.addPercent(Stat.speedMultiplier, this.speedMultiplier);
        }
        if (this.reloadMultiplier != 1.0f) {
            this.stats.addPercent(Stat.reloadMultiplier, this.reloadMultiplier);
        }
        if (this.buildSpeedMultiplier != 1.0f) {
            this.stats.addPercent(Stat.buildSpeedMultiplier, this.buildSpeedMultiplier);
        }
        if (this.damage > 0.0f) {
            this.stats.add(Stat.damage, this.damage * 60.0f, StatUnit.perSecond);
        }
        boolean reacts = false;
        for (StatusEffect e : this.opposites.asArray().sort()) {
            this.stats.add(Stat.opposites, e.emoji() + "" + e, new Object[0]);
        }
        if (this.reactive && (other = Vars.content.statusEffects().find(f -> f.affinities.contains(this))) != null && other.transitionDamage > 0.0f) {
            this.stats.add(Stat.reactive, other.emoji() + other + " / [accent]" + (int)other.transitionDamage + "[lightgray] " + Stat.damage.localized(), new Object[0]);
            reacts = true;
        }
        if (!reacts) {
            for (StatusEffect e : this.affinities.asArray().sort()) {
                this.stats.add(Stat.affinities, e.emoji() + "" + e, new Object[0]);
            }
            if (this.affinities.size > 0 && this.transitionDamage != 0.0f) {
                this.stats.add(Stat.affinities, "/ [accent]" + (int)this.transitionDamage + " " + Stat.damage.localized(), new Object[0]);
            }
        }
    }

    @Override
    public Cicon prefDatabaseIcon() {
        return Cicon.large;
    }

    @Override
    public boolean showUnlock() {
        return false;
    }

    public void update(Unit unit, float time) {
        if (this.damage > 0.0f) {
            unit.damageContinuousPierce(this.damage);
        } else if (this.damage < 0.0f) {
            unit.heal(-1.0f * this.damage * Time.delta);
        }
        if (this.effect != Fx.none && Mathf.chanceDelta(this.effectChance)) {
            Tmp.v1.rnd(unit.type.hitSize / 2.0f);
            this.effect.at(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y);
        }
    }

    protected void trans(StatusEffect effect, TransitionHandler handler) {
        this.transitions.put(effect, handler);
        effect.transitions.put(this, handler);
    }

    protected void affinity(StatusEffect effect, TransitionHandler handler) {
        this.affinities.add(effect);
        effect.affinities.add(this);
        this.trans(effect, handler);
    }

    protected void opposite(StatusEffect ... effect) {
        this.opposites.addAll((StatusEffect[])effect);
        for (StatusEffect sup : effect) {
            sup.opposites.add(this);
            this.trans(sup, (unit, time, newTime, result) -> {
                if ((time -= newTime * 0.5f) > 0.0f) {
                    result.set(this, time);
                    return;
                }
                result.set(sup, newTime);
            });
        }
    }

    public void draw(Unit unit) {
    }

    public boolean reactsWith(StatusEffect effect) {
        return this.transitions.containsKey(effect);
    }

    public StatusEntry getTransition(Unit unit, StatusEffect to, float time, float newTime, StatusEntry result) {
        if (this.transitions.containsKey(to)) {
            this.transitions.get(to).handle(unit, time, newTime, result);
            return result;
        }
        return result.set(to, newTime);
    }

    @Override
    public String toString() {
        return this.localizedName;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.status;
    }

    public static interface TransitionHandler {
        public void handle(Unit var1, float var2, float var3, StatusEntry var4);
    }
}

