/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Leg;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.EntityMapping;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Sounds;
import mindustry.gen.Trailc;
import mindustry.gen.Unit;
import mindustry.gen.WaterMovec;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.AmmoType;
import mindustry.type.AmmoTypes;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.type.Weapon;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.values.BlockFilterValue;
import mindustry.world.meta.values.WeaponListValue;

public class UnitType
extends UnlockableContent {
    public static final float shadowTX = -12.0f;
    public static final float shadowTY = -13.0f;
    public static final float outlineSpace = 0.01f;
    private static final Vec2 legOffset = new Vec2();
    public boolean flying;
    public Prov<? extends Unit> constructor;
    public Prov<? extends UnitController> defaultController = () -> !this.flying ? new GroundAI() : new FlyingAI();
    public float speed = 1.1f;
    public float boostMultiplier = 1.0f;
    public float rotateSpeed = 5.0f;
    public float baseRotateSpeed = 5.0f;
    public float drag = 0.3f;
    public float accel = 0.5f;
    public float landShake = 0.0f;
    public float rippleScale = 1.0f;
    public float riseSpeed = 0.08f;
    public float fallSpeed = 0.018f;
    public float health = 200.0f;
    public float range = -1.0f;
    public float armor = 0.0f;
    public float maxRange = -1.0f;
    public float crashDamageMultiplier = 1.0f;
    public boolean targetAir = true;
    public boolean targetGround = true;
    public boolean faceTarget = true;
    public boolean rotateShooting = true;
    public boolean isCounted = true;
    public boolean lowAltitude = false;
    public boolean circleTarget = false;
    public boolean canBoost = false;
    public boolean destructibleWreck = true;
    public float groundLayer = 60.0f;
    public float payloadCapacity = 8.0f;
    public float aimDst = -1.0f;
    public float buildBeamOffset = 3.8f;
    public int commandLimit = 8;
    public float visualElevation = -1.0f;
    public boolean allowLegStep = false;
    public boolean hovering = false;
    public boolean omniMovement = true;
    public Effect fallEffect = Fx.fallSmoke;
    public Effect fallThrusterEffect = Fx.fallSmoke;
    public Seq<Ability> abilities = new Seq();
    public BlockFlag targetFlag = BlockFlag.generator;
    public int legCount = 4;
    public int legGroupSize = 2;
    public float legLength = 10.0f;
    public float legSpeed = 0.1f;
    public float legTrns = 1.0f;
    public float legBaseOffset = 0.0f;
    public float legMoveSpace = 1.0f;
    public float legExtension = 0.0f;
    public float legPairOffset = 0.0f;
    public float legLengthScl = 1.0f;
    public float kinematicScl = 1.0f;
    public float maxStretch = 1.75f;
    public float legSplashDamage = 0.0f;
    public float legSplashRange = 5.0f;
    public boolean flipBackLegs = true;
    public int ammoResupplyAmount = 10;
    public float ammoResupplyRange = 100.0f;
    public float mechSideSway = 0.54f;
    public float mechFrontSway = 0.1f;
    public float mechStride = -1.0f;
    public float mechStepShake = -1.0f;
    public boolean mechStepParticles = false;
    public Color mechLegColor = Pal.darkMetal;
    public int itemCapacity = -1;
    public int ammoCapacity = -1;
    public AmmoType ammoType = AmmoTypes.copper;
    public int mineTier = -1;
    public float buildSpeed = -1.0f;
    public float mineSpeed = 1.0f;
    public Sound mineSound = Sounds.minebeam;
    public float mineSoundVolume = 0.6f;
    public float dpsEstimate = -1.0f;
    public float clipSize = -1.0f;
    public boolean canDrown = true;
    public float engineOffset = 5.0f;
    public float engineSize = 2.5f;
    public float strafePenalty = 0.5f;
    public float hitSize = 6.0f;
    public float itemOffsetY = 3.0f;
    public float lightRadius = 60.0f;
    public float lightOpacity = 0.6f;
    public Color lightColor = Pal.powerLight;
    public boolean drawCell = true;
    public boolean drawItems = true;
    public boolean drawShields = true;
    public int trailLength = 3;
    public float trailX = 4.0f;
    public float trailY = -3.0f;
    public float trailScl = 1.0f;
    public boolean canHeal = false;
    public boolean singleTarget = false;
    public ObjectSet<StatusEffect> immunities = new ObjectSet();
    public Sound deathSound = Sounds.bang;
    public Seq<Weapon> weapons = new Seq();
    public TextureRegion baseRegion;
    public TextureRegion legRegion;
    public TextureRegion region;
    public TextureRegion shadowRegion;
    public TextureRegion cellRegion;
    public TextureRegion softShadowRegion;
    public TextureRegion jointRegion;
    public TextureRegion footRegion;
    public TextureRegion legBaseRegion;
    public TextureRegion baseJointRegion;
    public TextureRegion outlineRegion;
    public TextureRegion[] wreckRegions;
    @Nullable
    protected ItemStack[] cachedRequirements;

    public UnitType(String name) {
        super(name);
        this.constructor = EntityMapping.map(name);
    }

    public UnitController createController() {
        return this.defaultController.get();
    }

    public Unit create(Team team) {
        Unit unit = this.constructor.get();
        unit.team = team;
        unit.setType(this);
        unit.ammo = this.ammoCapacity;
        unit.elevation = this.flying ? 1.0f : 0.0f;
        unit.heal();
        return unit;
    }

    public Unit spawn(Team team, float x, float y) {
        Unit out = this.create(team);
        out.set(x, y);
        out.add();
        return out;
    }

    public Unit spawn(float x, float y) {
        return this.spawn(Vars.state.rules.defaultTeam, x, y);
    }

    public boolean hasWeapons() {
        return this.weapons.size > 0;
    }

    public void update(Unit unit) {
    }

    public void landed(Unit unit) {
    }

    public void display(Unit unit, Table table) {
        table.table(t -> {
            t.left();
            t.add(new Image(this.icon(Cicon.medium))).size(32.0f).scaling(Scaling.fit);
            t.labelWrap(this.localizedName).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
        table.row();
        table.table(bars -> {
            Payloadc payload;
            bars.defaults().growX().height(20.0f).pad(4.0f);
            bars.add(new Bar("stat.health", Pal.health, unit::healthf).blink(Color.white));
            bars.row();
            if (Vars.state.rules.unitAmmo) {
                bars.add(new Bar(this.ammoType.icon + " " + Core.bundle.get("stat.ammo"), this.ammoType.barColor, () -> unit.ammo / (float)this.ammoCapacity));
                bars.row();
            }
            for (Ability ability : unit.abilities) {
                ability.displayBars(unit, (Table)bars);
            }
            Unit payload$temp = unit;
            if (payload$temp instanceof Payloadc && (payload = (Payloadc)((Object)payload$temp)) == (Payloadc)((Object)payload$temp)) {
                bars.add(new Bar("stat.payloadcapacity", Pal.items, () -> payload.payloadUsed() / unit.type().payloadCapacity));
                bars.row();
                float[] count = new float[]{-1.0f};
                bars.table().update((T t) -> {
                    if (count[0] != payload.payloadUsed()) {
                        payload.contentInfo((Table)t, 16.0f, 270.0f);
                        count[0] = payload.payloadUsed();
                    }
                }).growX().left().height(0.0f).pad(0.0f);
            }
        }).growX();
        if (unit.controller() instanceof LogicAI) {
            table.row();
            table.add(Blocks.microProcessor.emoji() + " " + Core.bundle.get("units.processorcontrol")).growX().wrap().left();
            table.row();
            table.label(() -> "\ue87c " + (long)unit.flag + "").color(Color.lightGray).growX().wrap().left();
        }
        table.row();
    }

    @Override
    public void getDependencies(Cons<UnlockableContent> cons) {
        for (Block block : Vars.content.blocks()) {
            Reconstructor r;
            Block block2 = block;
            if (!(block2 instanceof Reconstructor) || (r = (Reconstructor)block2) != (Reconstructor)block2) continue;
            for (UnitType[] recipe : r.upgrades) {
                if (recipe[1] != this) continue;
                cons.get(block);
            }
        }
        for (ItemStack stack : this.researchRequirements()) {
            cons.get(stack.item);
        }
    }

    @Override
    public void setStats() {
        Unit inst = this.constructor.get();
        this.stats.add(Stat.health, this.health);
        this.stats.add(Stat.armor, this.armor);
        this.stats.add(Stat.speed, this.speed);
        this.stats.add(Stat.itemCapacity, this.itemCapacity);
        this.stats.add(Stat.range, (int)(this.maxRange / 8.0f), StatUnit.blocks);
        this.stats.add(Stat.commandLimit, this.commandLimit);
        if (this.abilities.any()) {
            ObjectSet<String> unique = new ObjectSet<String>();
            for (Ability a : this.abilities) {
                if (!unique.add(a.localized())) continue;
                this.stats.add(Stat.abilities, a.localized(), new Object[0]);
            }
        }
        this.stats.add(Stat.flying, this.flying);
        if (!this.flying) {
            this.stats.add(Stat.canBoost, this.canBoost);
        }
        if (this.mineTier >= 1) {
            this.stats.addPercent(Stat.mineSpeed, this.mineSpeed);
            this.stats.add(Stat.mineTier, new BlockFilterValue(b -> {
                Floor f;
                Block f$temp = b;
                return f$temp instanceof Floor && (f = (Floor)f$temp) == (Floor)f$temp && f.itemDrop != null && f.itemDrop.hardness <= this.mineTier && !f.playerUnmineable;
            }));
        }
        if (this.buildSpeed > 0.0f) {
            this.stats.addPercent(Stat.buildSpeed, this.buildSpeed);
        }
        if (inst instanceof Payloadc) {
            this.stats.add(Stat.payloadCapacity, this.payloadCapacity / 64.0f, StatUnit.blocksSquared);
        }
        if (this.weapons.any()) {
            this.stats.add(Stat.weapons, new WeaponListValue(this, this.weapons));
        }
    }

    @Override
    public void init() {
        if (this.constructor == null) {
            throw new IllegalArgumentException("no constructor set up for unit '" + this.name + "'");
        }
        Unit example = this.constructor.get();
        if (example instanceof WaterMovec) {
            this.canDrown = false;
            this.omniMovement = false;
            this.immunities.add(StatusEffects.wet);
        }
        boolean bl = this.singleTarget = this.weapons.size <= 1;
        if (this.itemCapacity < 0) {
            this.itemCapacity = Math.max(Mathf.round((int)((double)this.hitSize * 4.3), 10), 10);
        }
        if (this.range < 0.0f) {
            this.range = Float.MAX_VALUE;
            for (Weapon weapon : this.weapons) {
                this.range = Math.min(this.range, weapon.bullet.range() + this.hitSize / 2.0f);
                this.maxRange = Math.max(this.maxRange, weapon.bullet.range() + this.hitSize / 2.0f);
            }
        }
        if (this.maxRange < 0.0f) {
            this.maxRange = 0.0f;
            this.maxRange = Math.max(this.maxRange, this.range);
            for (Weapon weapon : this.weapons) {
                this.maxRange = Math.max(this.maxRange, weapon.bullet.range() + this.hitSize / 2.0f);
            }
        }
        if (this.weapons.isEmpty()) {
            this.maxRange = 70.0f;
            this.range = 70.0f;
        }
        if (this.mechStride < 0.0f) {
            this.mechStride = 4.0f + (this.hitSize - 8.0f) / 2.1f;
        }
        if (this.aimDst < 0.0f) {
            float f = this.aimDst = this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> !w.rotate))) ? this.hitSize * 2.0f : this.hitSize / 2.0f;
        }
        if (this.mechStepShake < 0.0f) {
            this.mechStepShake = Mathf.round((this.hitSize - 11.0f) / 9.0f);
            this.mechStepParticles = this.hitSize > 15.0f;
        }
        this.canHeal = this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.healPercent > 0.0f)));
        Seq<Weapon> mapped = new Seq<Weapon>();
        for (Weapon w2 : this.weapons) {
            mapped.add(w2);
            if (!w2.mirror) continue;
            Weapon copy = w2.copy();
            copy.x *= -1.0f;
            copy.shootX *= -1.0f;
            copy.flipSprite = !copy.flipSprite;
            mapped.add(copy);
            w2.reload *= 2.0f;
            copy.reload *= 2.0f;
            w2.otherSide = mapped.size - 1;
            copy.otherSide = mapped.size - 2;
        }
        this.weapons = mapped;
        if (this.ammoCapacity < 0) {
            float f = this.weapons.sumf(w -> 60.0f / w.reload);
            float targetSeconds = 30.0f;
            this.ammoCapacity = Math.max(1, (int)(f * targetSeconds));
        }
        if (this.dpsEstimate < 0.0f) {
            this.dpsEstimate = this.weapons.sumf(w -> w.bullet.estimateDPS() / w.reload * (float)w.shots * 60.0f);
            if (this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.killShooter)))) {
                this.dpsEstimate /= 25.0f;
            }
        }
    }

    @Override
    public void load() {
        this.weapons.each(Weapon::load);
        this.region = Core.atlas.find(this.name);
        this.legRegion = Core.atlas.find(this.name + "-leg");
        this.jointRegion = Core.atlas.find(this.name + "-joint");
        this.baseJointRegion = Core.atlas.find(this.name + "-joint-base");
        this.footRegion = Core.atlas.find(this.name + "-foot");
        this.legBaseRegion = Core.atlas.find(this.name + "-leg-base", this.name + "-leg");
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.cellRegion = Core.atlas.find(this.name + "-cell", Core.atlas.find("power-cell"));
        this.softShadowRegion = Core.atlas.find("circle-shadow");
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
        this.shadowRegion = this.icon(Cicon.full);
        this.wreckRegions = new TextureRegion[3];
        for (int i = 0; i < this.wreckRegions.length; ++i) {
            this.wreckRegions[i] = Core.atlas.find(this.name + "-wreck" + i);
        }
    }

    @Override
    public ItemStack[] researchRequirements() {
        ConsumeItems ci;
        Object t;
        if (this.cachedRequirements != null) {
            return this.cachedRequirements;
        }
        ItemStack[] stacks = null;
        Block rec = Vars.content.blocks().find(b -> {
            Reconstructor re;
            Block re$temp = b;
            return re$temp instanceof Reconstructor && (re = (Reconstructor)re$temp) == (Reconstructor)re$temp && re.upgrades.contains((UnitType[])((Boolf<UnitType[]>)u -> u[1] == this));
        });
        if (rec != null && rec.consumes.has(ConsumeType.item) && (t = rec.consumes.get(ConsumeType.item)) instanceof ConsumeItems && (ci = (ConsumeItems)t) == (ConsumeItems)t) {
            stacks = ci.items;
        } else {
            UnitFactory factory = (UnitFactory)Vars.content.blocks().find(u -> {
                UnitFactory uf;
                Block uf$temp = u;
                return uf$temp instanceof UnitFactory && (uf = (UnitFactory)uf$temp) == (UnitFactory)uf$temp && uf.plans.contains((UnitFactory.UnitPlan)((Object)((Boolf<UnitFactory.UnitPlan>)p -> p.unit == this)));
            });
            if (factory != null) {
                stacks = factory.plans.find((Boolf<UnitFactory.UnitPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$researchRequirements$17(mindustry.world.blocks.units.UnitFactory$UnitPlan ), (Lmindustry/world/blocks/units/UnitFactory$UnitPlan;)Z)((UnitType)this)).requirements;
            }
        }
        if (stacks != null) {
            ItemStack[] out = new ItemStack[stacks.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ItemStack(stacks[i].item, UI.roundAmount((int)(Math.pow(stacks[i].amount, 1.1) * 50.0)));
            }
            this.cachedRequirements = out;
            return out;
        }
        return super.researchRequirements();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.unit;
    }

    public void draw(Unit unit) {
        float z;
        Mechc mech;
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)((Object)unit) : null;
        float f = unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : (z = this.groundLayer + Mathf.clamp(this.hitSize / 4000.0f, 0.0f, 0.01f));
        if (unit.controller().isBeingControlled(Vars.player.unit())) {
            this.drawControl(unit);
        }
        if (unit.isFlying() || this.visualElevation > 0.0f) {
            Draw.z(Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
        }
        Draw.z(z - 0.02f);
        if (mech != null) {
            this.drawMech(mech);
            legOffset.trns(mech.baseRotation(), 0.0f, Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.63661975f, 1.0f) * this.mechSideSway, 0.0f, unit.elevation));
            legOffset.add(Tmp.v1.trns(mech.baseRotation() + 90.0f, 0.0f, Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.31830987f, 1.0f) * this.mechFrontSway, 0.0f, unit.elevation)));
            unit.trns(UnitType.legOffset.x, UnitType.legOffset.y);
        }
        if (unit instanceof Legsc) {
            this.drawLegs((Unit)((Object)((Legsc)((Object)unit))));
        }
        Draw.z(Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Object)((Payloadc)((Object)unit))));
        }
        this.drawSoftShadow(unit);
        Draw.z(z - 0.01f);
        this.drawOutline(unit);
        Draw.z(z);
        if (this.engineSize > 0.0f) {
            this.drawEngine(unit);
        }
        this.drawBody(unit);
        if (this.drawCell) {
            this.drawCell(unit);
        }
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        this.drawLight(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (mech != null) {
            unit.trns(-UnitType.legOffset.x, -UnitType.legOffset.y);
        }
        if (unit.abilities.size > 0) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
            Draw.reset();
        }
    }

    public <T extends Unit> void drawPayload(T unit) {
        if (((Payloadc)((Object)unit)).hasPayload()) {
            Payload pay = ((Payloadc)((Object)unit)).payloads().first();
            pay.set(unit.x, unit.y, unit.rotation);
            pay.draw();
        }
    }

    public void drawShield(Unit unit) {
        float alpha = unit.shieldAlpha();
        float radius = unit.hitSize() * 1.3f;
        Fill.light(unit.x, unit.y, Lines.circleVertices(radius), radius, Tmp.c1.set(Pal.shieldIn), Tmp.c2.set(Pal.shield).lerp(Color.white, Mathf.clamp(unit.hitTime() / 2.0f)).a(Pal.shield.a * alpha));
    }

    public void drawControl(Unit unit) {
        Draw.z(58.0f);
        Draw.color(Pal.accent, Color.white, Mathf.absin(4.0f, 0.3f));
        Lines.poly(unit.x, unit.y, 4, unit.hitSize + 1.5f);
        Draw.reset();
    }

    public void drawShadow(Unit unit) {
        Draw.color(Pal.shadow);
        float e = Math.max(unit.elevation, this.visualElevation);
        Draw.rect(this.shadowRegion, unit.x + -12.0f * e, unit.y + -13.0f * e, unit.rotation - 90.0f);
        Draw.color();
    }

    public void drawSoftShadow(Unit unit) {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f);
        float rad = 1.6f;
        float size = (float)Math.max(this.region.width, this.region.height) * Draw.scl;
        Draw.rect(this.softShadowRegion, unit, size * rad, size * rad);
        Draw.color();
    }

    public void drawItems(Unit unit) {
        this.applyColor(unit);
        if (unit.item() != null && unit.itemTime > 0.01f) {
            float size = (5.0f + Mathf.absin(Time.time, 5.0f, 1.0f)) * unit.itemTime;
            Draw.mixcol(Pal.accent, Mathf.absin(Time.time, 5.0f, 0.5f));
            Draw.rect(unit.item().icon(Cicon.medium), unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY), size, size, unit.rotation);
            Draw.mixcol();
            Lines.stroke(1.0f, Pal.accent);
            Lines.circle(unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY), (3.0f + Mathf.absin(Time.time, 5.0f, 1.0f)) * unit.itemTime);
            if (unit.isLocal() && !Vars.renderer.pixelator.enabled()) {
                Fonts.outline.draw(unit.stack.amount + "", unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY) - 3.0f, Pal.accent, 0.25f * unit.itemTime / Scl.scl(1.0f), false, 1);
            }
            Draw.reset();
        }
    }

    public void drawEngine(Unit unit) {
        if (!unit.isFlying()) {
            return;
        }
        float scale = unit.elevation;
        float offset = this.engineOffset / 2.0f + this.engineOffset / 2.0f * scale;
        if (unit instanceof Trailc) {
            Trail trail = ((Trailc)((Object)unit)).trail();
            trail.draw(unit.team.color, (this.engineSize + Mathf.absin(Time.time, 2.0f, this.engineSize / 4.0f) * scale) * this.trailScl);
        }
        Draw.color(unit.team.color);
        Fill.circle(unit.x + Angles.trnsx(unit.rotation + 180.0f, offset), unit.y + Angles.trnsy(unit.rotation + 180.0f, offset), (this.engineSize + Mathf.absin(Time.time, 2.0f, this.engineSize / 4.0f)) * scale);
        Draw.color(Color.white);
        Fill.circle(unit.x + Angles.trnsx(unit.rotation + 180.0f, offset - 1.0f), unit.y + Angles.trnsy(unit.rotation + 180.0f, offset - 1.0f), (this.engineSize + Mathf.absin(Time.time, 2.0f, this.engineSize / 4.0f)) / 2.0f * scale);
        Draw.color();
    }

    public void drawWeapons(Unit unit) {
        this.applyColor(unit);
        for (WeaponMount mount : unit.mounts) {
            Weapon weapon = mount.weapon;
            float rotation = unit.rotation - 90.0f;
            float weaponRotation = rotation + (weapon.rotate ? mount.rotation : 0.0f);
            float recoil = -(mount.reload / weapon.reload * weapon.recoil);
            float wx = unit.x + Angles.trnsx(rotation, weapon.x, weapon.y) + Angles.trnsx(weaponRotation, 0.0f, recoil);
            float wy = unit.y + Angles.trnsy(rotation, weapon.x, weapon.y) + Angles.trnsy(weaponRotation, 0.0f, recoil);
            if (weapon.shadow > 0.0f) {
                Drawf.shadow(wx, wy, weapon.shadow);
            }
            if (weapon.outlineRegion.found()) {
                float z = Draw.z();
                if (!weapon.top) {
                    Draw.z(z - 0.01f);
                }
                Draw.rect(weapon.outlineRegion, wx, wy, (float)weapon.outlineRegion.width * Draw.scl * (float)(-Mathf.sign(weapon.flipSprite)), (float)weapon.region.height * Draw.scl, weaponRotation);
                Draw.z(z);
            }
            Draw.rect(weapon.region, wx, wy, (float)weapon.region.width * Draw.scl * (float)(-Mathf.sign(weapon.flipSprite)), (float)weapon.region.height * Draw.scl, weaponRotation);
            if (!weapon.heatRegion.found() || !(mount.heat > 0.0f)) continue;
            Draw.color(weapon.heatColor, mount.heat);
            Draw.blend(Blending.additive);
            Draw.rect(weapon.heatRegion, wx, wy, (float)weapon.heatRegion.width * Draw.scl * (float)(-Mathf.sign(weapon.flipSprite)), (float)weapon.heatRegion.height * Draw.scl, weaponRotation);
            Draw.blend();
            Draw.color();
        }
        Draw.reset();
    }

    public void drawOutline(Unit unit) {
        Draw.reset();
        if (Core.atlas.isFound(this.outlineRegion)) {
            Draw.rect(this.outlineRegion, unit.x, unit.y, unit.rotation - 90.0f);
        }
    }

    public void drawBody(Unit unit) {
        this.applyColor(unit);
        Draw.rect(this.region, unit.x, unit.y, unit.rotation - 90.0f);
        Draw.reset();
    }

    public void drawCell(Unit unit) {
        this.applyColor(unit);
        Draw.color(this.cellColor(unit));
        Draw.rect(this.cellRegion, unit.x, unit.y, unit.rotation - 90.0f);
        Draw.reset();
    }

    public Color cellColor(Unit unit) {
        return Tmp.c1.set(Color.black).lerp(unit.team.color, unit.healthf() + Mathf.absin(Time.time, Math.max(unit.healthf() * 5.0f, 1.0f), 1.0f - unit.healthf()));
    }

    public void drawLight(Unit unit) {
        if (this.lightRadius > 0.0f) {
            Drawf.light(unit.team, unit.x, unit.y, this.lightRadius, this.lightColor, this.lightOpacity);
        }
    }

    public <T extends Unit> void drawLegs(T unit) {
        this.applyColor(unit);
        Leg[] legs = ((Legsc)((Object)unit)).legs();
        float ssize = (float)this.footRegion.width * Draw.scl * 1.5f;
        float rotation = ((Legsc)((Object)unit)).baseRotation();
        for (Leg leg : legs) {
            Drawf.shadow(leg.base.x, leg.base.y, ssize);
        }
        for (int j = legs.length - 1; j >= 0; --j) {
            int i = j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2;
            Leg leg = legs[i];
            float angle = ((Legsc)((Object)unit)).legAngle(rotation, i);
            boolean flip = (float)i >= (float)legs.length / 2.0f;
            int flips = Mathf.sign(flip);
            Vec2 position = legOffset.trns(angle, this.legBaseOffset).add(unit);
            Tmp.v1.set(leg.base).sub(leg.joint).inv().setLength(this.legExtension);
            if (leg.moving && this.visualElevation > 0.0f) {
                float scl = this.visualElevation;
                float elev = Mathf.slope(1.0f - leg.stage) * scl;
                Draw.color(Pal.shadow);
                Draw.rect(this.footRegion, leg.base.x + -12.0f * elev, leg.base.y + -13.0f * elev, position.angleTo(leg.base));
                Draw.color();
            }
            Draw.rect(this.footRegion, leg.base.x, leg.base.y, position.angleTo(leg.base));
            Lines.stroke((float)this.legRegion.height * Draw.scl * (float)flips);
            Lines.line(this.legRegion, position.x, position.y, leg.joint.x, leg.joint.y, false);
            Lines.stroke((float)this.legBaseRegion.height * Draw.scl * (float)flips);
            Lines.line(this.legBaseRegion, leg.joint.x + Tmp.v1.x, leg.joint.y + Tmp.v1.y, leg.base.x, leg.base.y, false);
            if (this.jointRegion.found()) {
                Draw.rect(this.jointRegion, leg.joint.x, leg.joint.y);
            }
            if (!this.baseJointRegion.found()) continue;
            Draw.rect(this.baseJointRegion, position.x, position.y, rotation);
        }
        if (this.baseRegion.found()) {
            Draw.rect(this.baseRegion, unit.x, unit.y, rotation - 90.0f);
        }
        Draw.reset();
    }

    public void drawMech(Mechc mech) {
        Floor floor;
        Unit unit = (Unit)((Object)mech);
        Draw.reset();
        float e = unit.elevation;
        float sin = Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.63661975f, 1.0f), 0.0f, e);
        float extension = Mathf.lerp(mech.walkExtend(false), 0.0f, e);
        float boostTrns = e * 2.0f;
        Floor floor2 = floor = unit.isFlying() ? Blocks.air.asFloor() : unit.floorOn();
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.mapColor, 0.5f);
        }
        for (int i : Mathf.signs) {
            Draw.mixcol(Tmp.c1.set(this.mechLegColor).lerp(Color.white, Mathf.clamp(unit.hitTime)), Math.max(Math.max(0.0f, (float)i * extension / this.mechStride), unit.hitTime));
            Draw.rect(this.legRegion, unit.x + Angles.trnsx(mech.baseRotation(), extension * (float)i - boostTrns, -boostTrns * (float)i), unit.y + Angles.trnsy(mech.baseRotation(), extension * (float)i - boostTrns, -boostTrns * (float)i), (float)(this.legRegion.width * i) * Draw.scl, (float)this.legRegion.height * Draw.scl - Math.max(-sin * (float)i, 0.0f) * (float)this.legRegion.height * 0.5f * Draw.scl, mech.baseRotation() - 90.0f + 35.0f * (float)i * e);
        }
        Draw.mixcol(Color.white, unit.hitTime);
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.mapColor, unit.drownTime() * 0.4f);
        } else {
            Draw.color(Color.white);
        }
        Draw.rect(this.baseRegion, unit, mech.baseRotation() - 90.0f);
        Draw.mixcol();
    }

    public void applyColor(Unit unit) {
        Draw.color();
        Draw.mixcol(Color.white, unit.hitTime);
        if (unit.drownTime > 0.0f && unit.floorOn().isDeep()) {
            Draw.mixcol(unit.floorOn().mapColor, unit.drownTime * 0.8f);
        }
    }

    private /* synthetic */ boolean lambda$researchRequirements$17(UnitFactory.UnitPlan p) {
        return p.unit == this;
    }
}

