/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;

public class Weapon
implements Cloneable {
    public String name = "";
    public BulletType bullet;
    public Effect ejectEffect = Fx.none;
    public boolean mirror = true;
    public boolean flipSprite = false;
    public boolean alternate = true;
    public boolean rotate = false;
    public boolean top = true;
    public boolean continuous;
    public float rotateSpeed = 20.0f;
    public float reload;
    public int shots = 1;
    public float spacing = 0.0f;
    public float inaccuracy = 0.0f;
    public float shake = 0.0f;
    public float recoil = 1.5f;
    public float shootX = 0.0f;
    public float shootY = 3.0f;
    public float x = 5.0f;
    public float y = 0.0f;
    public float xRand = 0.0f;
    public float shadow = -1.0f;
    public float velocityRnd = 0.0f;
    public float firstShotDelay = 0.0f;
    public float shotDelay = 0.0f;
    public float shootCone = 5.0f;
    public float cooldownTime = 20.0f;
    public float soundPitchMin = 0.8f;
    public float soundPitchMax = 1.0f;
    public boolean ignoreRotation = false;
    public float minShootVelocity = -1.0f;
    public int otherSide = -1;
    public Sound shootSound = Sounds.pew;
    public Sound chargeSound = Sounds.none;
    public Sound noAmmoSound = Sounds.noammo;
    public TextureRegion region;
    public TextureRegion heatRegion;
    public TextureRegion outlineRegion;
    public Color heatColor = Pal.turretHeat;
    public StatusEffect shootStatus = StatusEffects.none;
    public float shootStatusDuration = 300.0f;

    public Weapon(String name) {
        this.name = name;
    }

    public Weapon() {
        this("");
    }

    public Weapon copy() {
        try {
            return (Weapon)this.clone();
        }
        catch (CloneNotSupportedException suck) {
            throw new RuntimeException("very good language design", suck);
        }
    }

    public void load() {
        this.region = Core.atlas.find(this.name, Core.atlas.find("clear"));
        this.heatRegion = Core.atlas.find(this.name + "-heat");
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
    }
}

