/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.func.Floatp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.ScissorStack;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.style.NinePatchDrawable;
import arc.util.pooling.Pools;
import mindustry.gen.Tex;
import mindustry.ui.Fonts;

public class Bar
extends Element {
    private static Rect scissor = new Rect();
    private Floatp fraction;
    private String name = "";
    private float value;
    private float lastValue;
    private float blink;
    private Color blinkColor = new Color();

    public Bar(String name, Color color, Floatp fraction) {
        this.fraction = fraction;
        this.name = Core.bundle.get(name, name);
        this.blinkColor.set(color);
        this.lastValue = this.value = fraction.get();
        this.setColor(color);
    }

    public Bar(Prov<String> name, Prov<Color> color, Floatp fraction) {
        this.fraction = fraction;
        try {
            this.lastValue = this.value = Mathf.clamp(fraction.get());
        }
        catch (Exception e) {
            this.value = 0.0f;
            this.lastValue = 0.0f;
        }
        this.update(() -> {
            try {
                this.name = (String)name.get();
                this.blinkColor.set((Color)color.get());
                this.setColor((Color)color.get());
            }
            catch (Exception e) {
                this.name = "";
            }
        });
    }

    public Bar() {
    }

    public void reset(float value) {
        this.lastValue = this.blink = value;
        this.value = this.blink;
    }

    public void set(Prov<String> name, Floatp fraction, Color color) {
        this.fraction = fraction;
        this.lastValue = fraction.get();
        this.blinkColor.set(color);
        this.setColor(color);
        this.update(() -> {
            this.name = (String)name.get();
        });
    }

    public Bar blink(Color color) {
        this.blinkColor.set(color);
        return this;
    }

    @Override
    public void draw() {
        float computed;
        if (this.fraction == null) {
            return;
        }
        try {
            computed = Mathf.clamp(this.fraction.get());
        }
        catch (Exception e) {
            computed = 0.0f;
        }
        if (this.lastValue > computed) {
            this.blink = 1.0f;
            this.lastValue = computed;
        }
        if (Float.isNaN(this.lastValue)) {
            this.lastValue = 0.0f;
        }
        if (Float.isInfinite(this.lastValue)) {
            this.lastValue = 1.0f;
        }
        if (Float.isNaN(this.value)) {
            this.value = 0.0f;
        }
        if (Float.isInfinite(this.value)) {
            this.value = 1.0f;
        }
        if (Float.isNaN(computed)) {
            computed = 0.0f;
        }
        if (Float.isInfinite(computed)) {
            computed = 1.0f;
        }
        this.blink = Mathf.lerpDelta(this.blink, 0.0f, 0.2f);
        this.value = Mathf.lerpDelta(this.value, computed, 0.15f);
        NinePatchDrawable bar = Tex.bar;
        Draw.colorl(0.1f);
        bar.draw(this.x, this.y, this.width, this.height);
        Draw.color(this.color, this.blinkColor, this.blink);
        NinePatchDrawable top = Tex.barTop;
        float topWidth = this.width * this.value;
        if (topWidth > (float)Core.atlas.find((String)"bar-top").width) {
            top.draw(this.x, this.y, topWidth, this.height);
        } else if (ScissorStack.push(scissor.set(this.x, this.y, topWidth, this.height))) {
            top.draw(this.x, this.y, Core.atlas.find((String)"bar-top").width, this.height);
            ScissorStack.pop();
        }
        Draw.color();
        Font font = Fonts.outline;
        GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        lay.setText(font, this.name);
        font.setColor(Color.white);
        font.draw(this.name, this.x + this.width / 2.0f - lay.width / 2.0f, this.y + this.height / 2.0f + lay.height / 2.0f + 1.0f);
        Pools.free(lay);
    }
}

