/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.world.blocks.storage.CoreBlock;

public class CoreItemsDisplay
extends Table {
    private final ObjectSet<Item> usedItems = new ObjectSet();
    private CoreBlock.CoreBuild core;

    public CoreItemsDisplay() {
        this.rebuild();
    }

    public void resetUsed() {
        this.usedItems.clear();
    }

    void rebuild() {
        this.clear();
        this.background(Styles.black6);
        this.margin(4.0f);
        this.update(() -> {
            this.core = Vars.player.team().core();
            if (Vars.content.items().contains((Item)((Object)((Boolf<Item>)item -> this.core != null && this.core.items.get((Item)item) > 0 && this.usedItems.add((Item)item))))) {
                this.rebuild();
            }
        });
        int i = 0;
        for (Item item : Vars.content.items()) {
            if (!this.usedItems.contains(item)) continue;
            this.image(item.icon(Cicon.small)).padRight(3.0f);
            this.label(() -> this.core == null ? "0" : UI.formatAmount(this.core.items.get(item))).padRight(3.0f).left();
            if (++i % 4 != 0) continue;
            this.row();
        }
    }
}

