/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.Graphics;
import arc.assets.AssetManager;
import arc.assets.loaders.resolvers.InternalFileHandleResolver;
import arc.files.Fi;
import arc.freetype.FreeTypeFontGenerator;
import arc.freetype.FreeTypeFontGeneratorLoader;
import arc.freetype.FreetypeFontLoader;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.PixmapPacker;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Rect;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Tmp;
import java.util.Scanner;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Iconc;

public class Fonts {
    private static final String mainFont = "fonts/font.woff";
    private static final ObjectSet<String> unscaled = ObjectSet.with("iconLarge");
    private static ObjectIntMap<String> unicodeIcons = new ObjectIntMap();
    private static ObjectMap<String, String> stringIcons = new ObjectMap();
    private static ObjectMap<String, TextureRegion> largeIcons = new ObjectMap();
    private static TextureRegion[] iconTable;
    private static int lastCid;
    public static Font def;
    public static Font outline;
    public static Font chat;
    public static Font icon;
    public static Font iconLarge;
    public static Font tech;

    public static TextureRegion logicIcon(int id) {
        return iconTable[id];
    }

    public static int getUnicode(String content) {
        return unicodeIcons.get(content, 0);
    }

    public static String getUnicodeStr(String content) {
        return stringIcons.get(content, "");
    }

    public static void loadSystemCursors() {
        Graphics.Cursor.SystemCursor.arrow.set(Core.graphics.newCursor("cursor", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.hand.set(Core.graphics.newCursor("hand", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.ibeam.set(Core.graphics.newCursor("ibeam", Fonts.cursorScale()));
        Core.graphics.restoreCursor();
    }

    public static int cursorScale() {
        return 1;
    }

    public static void loadFonts() {
        largeIcons.clear();
        FreeTypeFontGenerator.FreeTypeFontParameter param = Fonts.fontParameter();
        Core.assets.load((String)"default", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)mainFont, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = f -> {
            def = (Font)f;
        };
        Core.assets.load((String)"chat", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)mainFont, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = f -> {
            chat = (Font)f;
        };
        Core.assets.load((String)"icon", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/icon.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 30;
                this.incremental = true;
                this.characters = "\u0000";
            }
        })).loaded = f -> {
            icon = (Font)f;
        };
        Core.assets.load((String)"iconLarge", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/icon.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 48;
                this.incremental = false;
                this.characters = "\u0000\uf15c\uf15b\uf0f6\ue802\ue803\ue804\ue805\ue807\ue800\ue808\ue809\ue80b\ue80f\uf300\uf1c5\ue813\ue816\ue819\ue81a\uf0b0\ue81d\ue822\ue824\ue825\ue826\ue827\ue823\ue829\ue806\ue811\ue815\ue818\uf120\ue835\ue836\uf129\ue837\ue839\ue83a\ue83b\ue83e\ue83f\uf12d\ue801\uf029\ue812\ue842\ue844\ue80d\ue81e\uf281\uf308\ue83d\ue845\uf181\ue80e\ue814\ue817\ue81b\ue81c\ue82a\ue82b\ue82c\ue82d\ue830\ue84c\ue852\ue853\ue85b\ue85c\ue85d\ue85e\ue85f\ue861\ue865\ue867\ue868\ue869\ue86a\ue86b\ue86c\ue86d\ue86e\ue86f\ue870\ue871\ue872\ue873\ue874\ue875\ue876\ue877\ue878\ue879\ue87b\ue87c\ue87d\ue88a\ue88b\ue810\ue88c\ue88d\ue88e\ue88f\u26a0\ue864\ue84d";
                this.borderWidth = 5.0f;
                this.borderColor = Color.darkGray;
            }
        })).loaded = f -> {
            iconLarge = (Font)f;
        };
    }

    public static TextureRegion getLargeIcon(String name) {
        return (TextureRegion)((Object)largeIcons.get(name, (TextureRegion)((Object)((Prov<TextureRegion>)() -> {
            TextureRegion region = new TextureRegion();
            int code = Iconc.codes.get(name, 63700);
            Font.Glyph glyph = iconLarge.getData().getGlyph((char)code);
            if (glyph == null) {
                return Core.atlas.find("error");
            }
            region.set(Fonts.iconLarge.getRegion().texture);
            region.set(glyph.u, glyph.v2, glyph.u2, glyph.v);
            return region;
        }))));
    }

    public static void loadContentIcons() {
        Seq<Font> fonts = Seq.with(chat, def, outline);
        Texture uitex = Core.atlas.find((String)"logo").texture;
        int size = (int)(Fonts.def.getData().lineHeight / Fonts.def.getData().scaleY);
        try (Scanner scan = new Scanner(Core.files.internal("icons/icons.properties").read(512));){
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                String[] split = line.split("=");
                String[] nametex = split[1].split("\\|");
                String character = split[0];
                String texture = nametex[1];
                int ch = Integer.parseInt(character);
                TextureAtlas.AtlasRegion region = Core.atlas.find(texture);
                if (region.texture != uitex) continue;
                unicodeIcons.put(nametex[0], ch);
                stringIcons.put(nametex[0], (char)ch + "");
                Font.Glyph glyph = new Font.Glyph();
                glyph.id = ch;
                glyph.srcX = 0;
                glyph.srcY = 0;
                glyph.width = size;
                glyph.height = (int)((float)region.height / (float)region.width * (float)size);
                glyph.u = region.u;
                glyph.v = region.v2;
                glyph.u2 = region.u2;
                glyph.v2 = region.v;
                glyph.xoffset = 0;
                glyph.yoffset = -size;
                glyph.xadvance = size;
                glyph.kerning = null;
                glyph.fixedWidth = true;
                glyph.page = 0;
                fonts.each(f -> f.getData().setGlyph(ch, glyph));
            }
        }
        iconTable = new TextureRegion[512];
        Fonts.iconTable[0] = Core.atlas.find("error");
        lastCid = 1;
        Vars.content.each(c -> {
            TextureAtlas.AtlasRegion region;
            UnlockableContent u;
            Content u$temp = c;
            if (u$temp instanceof UnlockableContent && (u = (UnlockableContent)u$temp) == (UnlockableContent)u$temp && (region = Core.atlas.find(u.name + "-icon-logic")).found()) {
                u.iconId = lastCid++;
                Fonts.iconTable[u.iconId] = region;
            }
        });
    }

    public static void loadDefaultFont() {
        int max = Gl.getInt(3379);
        UI.packer = new PixmapPacker(max >= 4096 ? 4096 : 2048, 2048, Pixmap.Format.rgba8888, 2, true);
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        Core.assets.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        Core.assets.setLoader(Font.class, null, new FreetypeFontLoader(resolver){
            ObjectSet<FreeTypeFontGenerator.FreeTypeFontParameter> scaled = new ObjectSet();

            @Override
            public Font loadSync(AssetManager manager, String fileName, Fi file, FreetypeFontLoader.FreeTypeFontLoaderParameter parameter) {
                if (fileName.equals("outline")) {
                    parameter.fontParameters.borderWidth = Scl.scl(2.0f);
                    parameter.fontParameters.spaceX = (int)((float)parameter.fontParameters.spaceX - parameter.fontParameters.borderWidth);
                }
                if (!this.scaled.contains(parameter.fontParameters) && !unscaled.contains(fileName)) {
                    parameter.fontParameters.size = (int)Scl.scl(parameter.fontParameters.size);
                    this.scaled.add(parameter.fontParameters);
                }
                parameter.fontParameters.magFilter = Texture.TextureFilter.linear;
                parameter.fontParameters.minFilter = Texture.TextureFilter.linear;
                parameter.fontParameters.packer = UI.packer;
                return super.loadSync(manager, fileName, file, parameter);
            }
        });
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.borderColor = Color.darkGray;
                this.incremental = true;
                this.size = 18;
            }
        };
        Core.assets.load((String)"outline", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)mainFont, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = t -> {
            outline = (Font)t;
        };
        Core.assets.load((String)"tech", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/tech.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 18;
            }
        })).loaded = f -> {
            tech = (Font)f;
            ((Font)f).getData().down *= 1.5f;
        };
    }

    public static void mergeFontAtlas(TextureAtlas atlas) {
        Texture texture = atlas.find((String)"logo").texture;
        PixmapPacker.Page page = UI.packer.getPages().first();
        Seq<TextureAtlas.AtlasRegion> regions = atlas.getRegions().select(t -> t.texture == texture);
        for (TextureAtlas.AtlasRegion region : regions) {
            page.setDirty(false);
            Rect rect = UI.packer.pack(region.name + (region.splits != null ? ".9" : ""), atlas.getPixmap(region));
            region.texture = UI.packer.getPages().first().getTexture();
            region.set((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
            atlas.getTextures().add(region.texture);
        }
        atlas.getTextures().remove(texture);
        texture.dispose();
        atlas.disposePixmap(texture);
        page.setDirty(true);
        page.updateTexture(Texture.TextureFilter.linear, Texture.TextureFilter.linear, false);
    }

    public static TextureRegionDrawable getGlyph(Font font, char glyph) {
        final Font.Glyph g = font.getData().getGlyph(glyph);
        if (g == null) {
            throw new IllegalArgumentException("No glyph: " + glyph + " (" + glyph + ")");
        }
        final float size = Math.max(g.width, g.height);
        TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(font.getRegion().texture, g.u, g.v2, g.u2, g.v)){

            @Override
            public void draw(float x, float y, float width, float height) {
                Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
                float cx = x + width / 2.0f - (float)g.width / 2.0f;
                float cy = y + height / 2.0f - (float)g.height / 2.0f;
                cx = (int)cx;
                cy = (int)cy;
                Draw.rect(this.region, cx + (float)g.width / 2.0f, cy + (float)g.height / 2.0f, (float)g.width, (float)g.height);
            }

            @Override
            public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
                Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
                float cx = x + (width *= scaleX) / 2.0f - (float)g.width / 2.0f;
                float cy = y + (height *= scaleY) / 2.0f - (float)g.height / 2.0f;
                cx = (int)cx;
                cy = (int)cy;
                originX = (float)g.width / 2.0f;
                originY = (float)g.height / 2.0f;
                Draw.rect(this.region, cx + (float)g.width / 2.0f, cy + (float)g.height / 2.0f, (float)g.width, (float)g.height, originX, originY, rotation);
            }

            @Override
            public float imageSize() {
                return size;
            }
        };
        draw.setMinWidth(size);
        draw.setMinHeight(size);
        return draw;
    }

    static FreeTypeFontGenerator.FreeTypeFontParameter fontParameter() {
        return new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 18;
                this.shadowColor = Color.darkGray;
                this.shadowOffsetY = 2;
                this.incremental = true;
            }
        };
    }
}

