/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import mindustry.core.UI;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;

public class ItemImage
extends Stack {
    public ItemImage(TextureRegion region, int amount) {
        this.add(new Table(o -> {
            o.left();
            o.add(new Image(region)).size(32.0f);
        }));
        this.add(new Table(t -> {
            t.left().bottom();
            t.add(amount > 1000 ? UI.formatAmount(amount) : amount + "");
            t.pack();
        }));
    }

    public ItemImage(TextureRegion region) {
        Table t = new Table().left().bottom();
        this.add(new Image(region));
        this.add(t);
    }

    public ItemImage(ItemStack stack) {
        this.add(new Table(o -> {
            o.left();
            o.add(new Image(stack.item.icon(Cicon.medium))).size(32.0f);
        }));
        if (stack.amount != 0) {
            this.add(new Table(t -> {
                t.left().bottom();
                t.add(stack.amount > 1000 ? UI.formatAmount(stack.amount) : stack.amount + "").style(Styles.outlineLabel);
                t.pack();
            }));
        }
    }
}

