/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Func;
import arc.graphics.Color;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.gen.Icon;

public class SearchBar {
    public static <T> Table add(Table parent, Seq<T> list, Func<String, String> queryf, Func<T, String> namef, Cons2<Table, T> itemc, boolean show) {
        Table[] pane = new Table[]{null};
        Cons<String> rebuild = str -> {
            String query = (String)queryf.get((String)str);
            pane[0].clear();
            boolean any = false;
            for (Object item : list) {
                if (!query.isEmpty() && !SearchBar.matches(query, (String)namef.get(item))) continue;
                any = true;
                itemc.get(pane[0], item);
            }
            if (!any) {
                pane[0].add("@none.found").color(Color.lightGray).pad(4.0f);
            }
        };
        if (show) {
            parent.table(search -> {
                search.image(Icon.zoom).padRight(8.0f);
                search.field("", rebuild).growX();
            }).fillX().padBottom(4.0f);
        }
        parent.row();
        parent.pane(table -> {
            pane[0] = table;
            rebuild.get("");
        });
        return pane[0];
    }

    public static <T> Table add(Table parent, Seq<T> list, Func<String, String> queryf, Func<T, String> namef, Cons2<Table, T> itemc) {
        return SearchBar.add(parent, list, queryf, namef, itemc, true);
    }

    public static <T> Table add(Table parent, Seq<T> list, Func<T, String> namef, Cons2<Table, T> itemc, boolean show) {
        return SearchBar.add(parent, list, String::toLowerCase, namef, itemc, show);
    }

    public static boolean matches(String query, String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.toLowerCase().contains(query);
    }
}

