/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.scene.ui.Dialog;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;

public class BaseDialog
extends Dialog {
    private boolean wasPaused;
    protected boolean shouldPause;

    public BaseDialog(String title, Dialog.DialogStyle style) {
        super(title, style);
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.image(Tex.whiteui, Pal.accent).growX().height(3.0f).pad(4.0f);
        this.hidden(() -> {
            if (this.shouldPause && Vars.state.isGame() && (!this.wasPaused || Vars.net.active())) {
                Vars.state.set(GameState.State.playing);
            }
            Sounds.back.play();
        });
        this.shown(() -> {
            if (this.shouldPause && Vars.state.isGame()) {
                this.wasPaused = Vars.state.is(GameState.State.paused);
                Vars.state.set(GameState.State.paused);
            }
        });
    }

    public BaseDialog(String title) {
        this(title, Core.scene.getStyle(Dialog.DialogStyle.class));
    }

    protected void onResize(Runnable run) {
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.isShown() && Core.scene.getDialog() == this) {
                run.run();
                this.updateScrollFocus();
            }
        });
    }

    public void addCloseListener() {
        this.closeOnBack();
    }

    @Override
    public void addCloseButton() {
        this.buttons.defaults().size(210.0f, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
        this.addCloseListener();
    }
}

