/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.func.Cons;
import arc.graphics.Color;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.dialogs.BaseDialog;

public class ColorPicker
extends BaseDialog {
    private Cons<Color> cons = c -> {};
    Color current = new Color();

    public ColorPicker() {
        super("@pickcolor");
    }

    public void show(Color color, Cons<Color> consumer) {
        this.show(color, true, consumer);
    }

    public void show(Color color, boolean alpha, Cons<Color> consumer) {
        this.current.set(color);
        this.cons = consumer;
        this.show();
        this.cont.clear();
        this.cont.pane((Table t) -> {
            t.table(Tex.pane, i -> i.stack(new Image(Tex.alphaBg), new Image(){
                {
                    this.setColor(ColorPicker.this.current);
                    this.update(() -> this.setColor(ColorPicker.this.current));
                }
            }).size(200.0f)).colspan(2).padBottom(5.0f);
            float w = 150.0f;
            t.row();
            t.defaults().padBottom(4.0f);
            t.add("R").color(Pal.remove);
            t.slider(0.0f, 1.0f, 0.01f, this.current.r, this.current::r).width(w);
            t.row();
            t.add("G").color(Color.lime);
            t.slider(0.0f, 1.0f, 0.01f, this.current.g, this.current::g).width(w);
            t.row();
            t.add("B").color(Color.royal);
            t.slider(0.0f, 1.0f, 0.01f, this.current.b, this.current::b).width(w);
            t.row();
            if (alpha) {
                t.add("A");
                t.slider(0.0f, 1.0f, 0.01f, this.current.a, this.current::a).width(w);
                t.row();
            }
        });
        this.buttons.clear();
        this.addCloseButton();
        this.buttons.button("@ok", Icon.ok, () -> {
            this.cons.get(this.current);
            this.hide();
        });
    }
}

