/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.game.Gamemode;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.maps.Map;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.MapPlayDialog;

public class CustomGameDialog
extends BaseDialog {
    private MapPlayDialog dialog = new MapPlayDialog();

    public CustomGameDialog() {
        super("@customgame");
        this.addCloseButton();
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        this.clearChildren();
        this.add(this.titleTable).growX().row();
        this.stack(this.cont, this.buttons).grow();
        this.buttons.bottom();
        this.cont.clear();
        Table maps = new Table();
        maps.marginRight(14.0f);
        maps.marginBottom(55.0f);
        ScrollPane pane = new ScrollPane((Element)maps);
        pane.setFadeScrollBars(false);
        int maxwidth = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(210.0f)), 1);
        float images = 146.0f;
        int i = 0;
        maps.defaults().width(170.0f).fillY().top().pad(4.0f);
        for (Map map : Vars.maps.all()) {
            if (i % maxwidth == 0) {
                maps.row();
            }
            ImageButton image = new ImageButton(new TextureRegion(map.safeTexture()), Styles.cleari);
            image.margin(5.0f);
            image.top();
            Image img = image.getImage();
            img.remove();
            image.row();
            image.table((Table t) -> {
                t.left();
                for (Gamemode mode : Gamemode.all) {
                    TextureRegionDrawable icon = Vars.ui.getIcon("mode" + Strings.capitalize(mode.name()) + "Small");
                    if (!mode.valid(map) || !Core.atlas.isFound(icon.getRegion())) continue;
                    t.image(icon).size(16.0f).pad(4.0f);
                }
            }).left();
            image.row();
            image.add(map.name()).pad(1.0f).growX().wrap().left().get().setEllipsis(true);
            image.row();
            image.image(Tex.whiteui, Pal.gray).growX().pad(3.0f).height(4.0f);
            image.row();
            image.add(img).size(images);
            BorderImage border = new BorderImage(map.safeTexture(), 3.0f);
            border.setScaling(Scaling.fit);
            image.replaceImage(border);
            image.clicked(() -> this.dialog.show(map));
            maps.add(image);
            ++i;
        }
        if (Vars.maps.all().size == 0) {
            maps.add("@maps.none").pad(50.0f);
        }
        this.cont.add(pane).uniformX();
    }
}

