/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolp;
import arc.func.Floatc;
import arc.func.Floatp;
import arc.func.Intc;
import arc.func.Intp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.ctype.ContentType;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.type.Weather;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadoutDialog;
import mindustry.world.Block;

public class CustomRulesDialog
extends BaseDialog {
    Rules rules;
    private Table main;
    private Prov<Rules> resetter;
    private LoadoutDialog loadoutDialog = new LoadoutDialog();
    private BaseDialog banDialog = new BaseDialog("@bannedblocks");

    public CustomRulesDialog() {
        super("@mode.custom");
        this.banDialog.addCloseButton();
        this.banDialog.shown(this::rebuildBanned);
        this.banDialog.buttons.button("@addall", Icon.add, () -> {
            this.rules.bannedBlocks.addAll(Vars.content.blocks().select(Block::canBeBuilt));
            this.rebuildBanned();
        }).size(180.0f, 64.0f);
        this.banDialog.buttons.button("@clear", Icon.trash, () -> {
            this.rules.bannedBlocks.clear();
            this.rebuildBanned();
        }).size(180.0f, 64.0f);
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
    }

    private void rebuildBanned() {
        float previousScroll = this.banDialog.cont.getChildren().isEmpty() ? 0.0f : ((ScrollPane)this.banDialog.cont.getChildren().first()).getScrollY();
        this.banDialog.cont.clear();
        this.banDialog.cont.pane((Table t) -> {
            t.margin(10.0f);
            if (this.rules.bannedBlocks.isEmpty()) {
                t.add("@empty");
            }
            Seq<Block> array = Seq.with(this.rules.bannedBlocks);
            array.sort();
            int cols = Vars.mobile && Core.graphics.isPortrait() ? 1 : (Vars.mobile ? 2 : 3);
            int i = 0;
            for (Block block : array) {
                t.table(Tex.underline, b -> {
                    b.left().margin(4.0f);
                    b.image(block.icon(Cicon.medium)).size(Cicon.medium.size).padRight(3.0f);
                    b.add(block.localizedName).color(Color.lightGray).padLeft(3.0f).growX().left().wrap();
                    b.button((Drawable)Icon.cancel, Styles.clearPartiali, () -> {
                        this.rules.bannedBlocks.remove(block);
                        this.rebuildBanned();
                    }).size(70.0f).pad(-4.0f).padLeft(0.0f);
                }).size(300.0f, 70.0f).padRight(5.0f);
                if (++i % cols != 0) continue;
                t.row();
            }
        }).get().setScrollYForce(previousScroll);
        this.banDialog.cont.row();
        this.banDialog.cont.button("@add", Icon.add, () -> {
            BaseDialog dialog = new BaseDialog("@add");
            dialog.cont.pane((Table t) -> {
                t.left().margin(14.0f);
                int[] i = new int[]{0};
                Vars.content.blocks().each(b -> !this.rules.bannedBlocks.contains((Block)b) && b.canBeBuilt(), b -> {
                    int cols = Vars.mobile && Core.graphics.isPortrait() ? 4 : 12;
                    t.button((Drawable)new TextureRegionDrawable(b.icon(Cicon.medium)), Styles.cleari, () -> {
                        this.rules.bannedBlocks.add((Block)b);
                        this.rebuildBanned();
                        dialog.hide();
                    }).size(60.0f).get().resizeImage(Cicon.medium.size);
                    i[0] = i[0] + 1;
                    if (i[0] % cols == 0) {
                        t.row();
                    }
                });
            });
            dialog.addCloseButton();
            dialog.show();
        }).size(300.0f, 64.0f);
    }

    public void show(Rules rules, Prov<Rules> resetter) {
        this.rules = rules;
        this.resetter = resetter;
        this.show();
    }

    void setup() {
        this.cont.clear();
        this.cont.pane((Table m) -> {
            this.main = m;
        }).get().setScrollingDisabled(true, false);
        this.main.margin(10.0f);
        this.main.button("@settings.reset", () -> {
            this.rules = this.resetter.get();
            this.setup();
            this.requestKeyboard();
            this.requestScroll();
        }).size(300.0f, 50.0f);
        this.main.left().defaults().fillX().left().pad(5.0f);
        this.main.row();
        this.title("@rules.title.waves");
        this.check("@rules.waves", b -> {
            this.rules.waves = b;
        }, () -> this.rules.waves);
        this.check("@rules.wavetimer", b -> {
            this.rules.waveTimer = b;
        }, () -> this.rules.waveTimer);
        this.check("@rules.waitForWaveToEnd", b -> {
            this.rules.waitEnemies = b;
        }, () -> this.rules.waitEnemies);
        this.number("@rules.wavespacing", false, f -> {
            this.rules.waveSpacing = f * 60.0f;
        }, () -> this.rules.waveSpacing / 60.0f, () -> true, 1.0f, Float.MAX_VALUE);
        this.number("@rules.dropzoneradius", false, (float f) -> {
            this.rules.dropZoneRadius = f * 8.0f;
        }, () -> this.rules.dropZoneRadius / 8.0f, () -> true);
        this.title("@rules.title.resourcesbuilding");
        this.check("@rules.infiniteresources", b -> {
            this.rules.infiniteResources = b;
        }, () -> this.rules.infiniteResources);
        this.check("@rules.reactorexplosions", b -> {
            this.rules.reactorExplosions = b;
        }, () -> this.rules.reactorExplosions);
        this.check("@rules.schematic", b -> {
            this.rules.schematicsAllowed = b;
        }, () -> this.rules.schematicsAllowed);
        this.check("@rules.coreincinerates", b -> {
            this.rules.coreIncinerates = b;
        }, () -> this.rules.coreIncinerates);
        this.number("@rules.buildcostmultiplier", false, (float f) -> {
            this.rules.buildCostMultiplier = f;
        }, () -> this.rules.buildCostMultiplier, () -> !this.rules.infiniteResources);
        this.number("@rules.buildspeedmultiplier", f -> {
            this.rules.buildSpeedMultiplier = f;
        }, () -> this.rules.buildSpeedMultiplier, 0.001f, 50.0f);
        this.number("@rules.deconstructrefundmultiplier", false, (float f) -> {
            this.rules.deconstructRefundMultiplier = f;
        }, () -> this.rules.deconstructRefundMultiplier, () -> !this.rules.infiniteResources);
        this.number("@rules.blockhealthmultiplier", f -> {
            this.rules.blockHealthMultiplier = f;
        }, () -> this.rules.blockHealthMultiplier);
        this.number("@rules.blockdamagemultiplier", f -> {
            this.rules.blockDamageMultiplier = f;
        }, () -> this.rules.blockDamageMultiplier);
        this.main.button("@configure", () -> this.loadoutDialog.show(Blocks.coreShard.itemCapacity, this.rules.loadout, i -> true, () -> this.rules.loadout.clear().add(new ItemStack(Items.copper, 100)), () -> {}, () -> {})).left().width(300.0f);
        this.main.row();
        this.main.button("@bannedblocks", this.banDialog::show).left().width(300.0f);
        this.main.row();
        this.title("@rules.title.unit");
        this.check("@rules.unitammo", b -> {
            this.rules.unitAmmo = b;
        }, () -> this.rules.unitAmmo);
        this.check("@rules.unitcapvariable", b -> {
            this.rules.unitCapVariable = b;
        }, () -> this.rules.unitCapVariable);
        this.number("@rules.unitcap", true, f -> {
            this.rules.unitCap = f;
        }, () -> this.rules.unitCap, -999, 999);
        this.number("@rules.unitdamagemultiplier", f -> {
            this.rules.unitDamageMultiplier = f;
        }, () -> this.rules.unitDamageMultiplier);
        this.number("@rules.unitbuildspeedmultiplier", f -> {
            this.rules.unitBuildSpeedMultiplier = f;
        }, () -> this.rules.unitBuildSpeedMultiplier, 0.001f, 50.0f);
        this.title("@rules.title.enemy");
        this.check("@rules.attack", b -> {
            this.rules.attackMode = b;
        }, () -> this.rules.attackMode);
        this.check("@rules.buildai", b -> {
            this.rules.teams.get((Team)this.rules.waveTeam).ai = this.rules.teams.get((Team)this.rules.waveTeam).infiniteResources = b;
        }, () -> this.rules.teams.get((Team)this.rules.waveTeam).ai);
        this.number("@rules.enemycorebuildradius", f -> {
            this.rules.enemyCoreBuildRadius = f * 8.0f;
        }, () -> Math.min(this.rules.enemyCoreBuildRadius / 8.0f, 200.0f));
        this.title("@rules.title.environment");
        this.check("@rules.explosions", b -> {
            this.rules.damageExplosions = b;
        }, () -> this.rules.damageExplosions);
        this.check("@rules.fire", b -> {
            this.rules.fire = b;
        }, () -> this.rules.fire);
        this.check("@rules.lighting", b -> {
            this.rules.lighting = b;
        }, () -> this.rules.lighting);
        this.check("@rules.enemyLights", b -> {
            this.rules.enemyLights = b;
        }, () -> this.rules.enemyLights);
        this.main.button((Button b) -> {
            b.left();
            b.table(Tex.pane, in -> in.stack(new Image(Tex.alphaBg), new Image(Tex.whiteui){
                {
                    this.update(() -> this.setColor(CustomRulesDialog.this.rules.ambientLight));
                }
            }).grow()).margin(4.0f).size(50.0f).padRight(10.0f);
            b.add("@rules.ambientlight");
        }, () -> Vars.ui.picker.show(this.rules.ambientLight, this.rules.ambientLight::set)).left().width(250.0f).row();
        this.main.button("@rules.weather", this::weatherDialog).width(250.0f).left().row();
    }

    void number(String text, Floatc cons, Floatp prov) {
        this.number(text, false, cons, prov, () -> true, 0.0f, Float.MAX_VALUE);
    }

    void number(String text, Floatc cons, Floatp prov, float min, float max) {
        this.number(text, false, cons, prov, () -> true, min, max);
    }

    void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, integer, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    void number(String text, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, false, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    void number(String text, boolean integer, Intc cons, Intp prov, int min, int max) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f);
            t.field((integer ? prov.get() : prov.get()) + "", s -> cons.get(Strings.parseInt(s))).padRight(100.0f).valid(f -> Strings.parseInt(f) >= min && Strings.parseInt(f) <= max).width(120.0f).left().addInputDialog();
        }).padTop(0.0f);
        this.main.row();
    }

    void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition, float min, float max) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            t.field((integer ? (float)((int)prov.get()) : prov.get()) + "", s -> cons.get(Strings.parseFloat(s))).padRight(100.0f).update((T a) -> a.setDisabled(!condition.get())).valid(f -> Strings.canParsePositiveFloat(f) && Strings.parseFloat(f) >= min && Strings.parseFloat(f) <= max).width(120.0f).left().addInputDialog();
        }).padTop(0.0f);
        this.main.row();
    }

    void check(String text, Boolc cons, Boolp prov) {
        this.check(text, cons, prov, () -> true);
    }

    void check(String text, Boolc cons, Boolp prov, Boolp condition) {
        this.main.check(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).get().left();
        this.main.row();
    }

    void title(String text) {
        this.main.add(text).color(Pal.accent).padTop(20.0f).padRight(100.0f).padBottom(-3.0f);
        this.main.row();
        this.main.image().color(Pal.accent).height(3.0f).padRight(100.0f).padBottom(20.0f);
        this.main.row();
    }

    Cell<TextField> field(Table table, float value, Floatc setter) {
        return table.field(Strings.autoFixed(value, 2), v -> setter.get(Strings.parseFloat(v))).valid(Strings::canParsePositiveFloat).size(90.0f, 40.0f).pad(2.0f).addInputDialog();
    }

    void weatherDialog() {
        BaseDialog dialog = new BaseDialog("@rules.weather");
        Runnable[] rebuild = new Runnable[]{null};
        dialog.cont.pane((Table base) -> {
            rebuild[0] = () -> {
                base.clearChildren();
                int cols = Math.max(1, Core.graphics.getWidth() / 460);
                int idx = 0;
                for (Weather.WeatherEntry entry : this.rules.weather) {
                    base.top();
                    base.table(Tex.pane, c -> {
                        c.margin(0.0f);
                        c.table(Tex.whiteui, t -> {
                            t.setColor(Pal.gray);
                            t.top().left();
                            t.add(entry.weather.localizedName).left().padLeft(6.0f);
                            t.add().growX();
                            ImageButton.ImageButtonStyle style = Styles.geni;
                            t.defaults().size(42.0f);
                            t.button((Drawable)Icon.cancel, style, () -> {
                                this.rules.weather.remove(entry);
                                rebuild[0].run();
                            });
                        }).growX();
                        c.row();
                        c.table((Table f) -> {
                            f.marginLeft(4.0f);
                            f.left().top();
                            f.defaults().padRight(4.0f).left();
                            f.add("@rules.weather.duration");
                            this.field((Table)f, entry.minDuration / 3600.0f, (float v) -> {
                                entry.minDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxDuration / 3600.0f, (float v) -> {
                                entry.maxDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.add("@rules.weather.frequency");
                            this.field((Table)f, entry.minFrequency / 3600.0f, (float v) -> {
                                entry.minFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxFrequency / 3600.0f, (float v) -> {
                                entry.maxFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.check("@rules.weather.always", val -> {
                                entry.always = val;
                            }).checked(cc -> entry.always).padBottom(4.0f);
                        }).grow().left().pad(6.0f).top();
                    }).width(410.0f).pad(3.0f).top().left().fillY();
                    if (++idx % cols != 0) continue;
                    base.row();
                }
            };
            rebuild[0].run();
        }).grow();
        dialog.addCloseButton();
        dialog.buttons.button("@add", Icon.add, () -> {
            BaseDialog add = new BaseDialog("@add");
            add.cont.pane((Table t) -> {
                t.background(Tex.button);
                int i = 0;
                for (Weather weather : Vars.content.getBy(ContentType.weather)) {
                    t.button(weather.localizedName, Styles.cleart, () -> {
                        this.rules.weather.add(new Weather.WeatherEntry(weather));
                        rebuild[0].run();
                        add.hide();
                    }).size(140.0f, 50.0f);
                    if (++i % 2 != 0) continue;
                    t.row();
                }
            });
            add.addCloseButton();
            add.show();
        }).width(170.0f);
        dialog.hidden(() -> {
            float sum = 0.0f;
            Seq<Weather.WeatherEntry> sh = this.rules.weather.copy();
            sh.shuffle();
            for (Weather.WeatherEntry w : sh) {
                w.cooldown = sum + Mathf.random(w.minFrequency, w.maxFrequency);
                sum += w.cooldown;
            }
        });
        dialog.show();
    }
}

