/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.ui.dialogs.BaseDialog;

public class DatabaseDialog
extends BaseDialog {
    public DatabaseDialog() {
        super("@database");
        this.shouldPause = true;
        this.addCloseButton();
        this.shown(this::rebuild);
        this.onResize(this::rebuild);
    }

    void rebuild() {
        this.cont.clear();
        Table table = new Table();
        table.margin(20.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        Seq<Content>[] allContent = Vars.content.getContentMap();
        for (int j = 0; j < allContent.length; ++j) {
            ContentType type = ContentType.all[j];
            Seq<Content> array = allContent[j].select(c -> {
                UnlockableContent u;
                Content u$temp = c;
                return u$temp instanceof UnlockableContent && (u = (UnlockableContent)u$temp) == (UnlockableContent)u$temp && (!u.isHidden() || u.node() != null);
            });
            if (array.size == 0) continue;
            table.add("@content." + type.name() + ".name").growX().left().color(Pal.accent);
            table.row();
            table.image().growX().pad(5.0f).padLeft(0.0f).padRight(0.0f).height(3.0f).color(Pal.accent);
            table.row();
            table.table((Table list) -> {
                list.left();
                int cols = Mathf.clamp((Core.graphics.getWidth() - 30) / 42, 1, 18);
                int count = 0;
                for (int i = 0; i < array.size; ++i) {
                    UnlockableContent unlock = (UnlockableContent)array.get(i);
                    Image image = this.unlocked(unlock) ? new Image(unlock.icon(Cicon.medium)).setScaling(Scaling.fit) : new Image((Drawable)Icon.lock, Pal.gray);
                    list.add(image).size(32.0f).pad(3.0f);
                    ClickListener listener = new ClickListener();
                    image.addListener(listener);
                    if (!Vars.mobile && this.unlocked(unlock)) {
                        image.addListener(new HandCursorListener());
                        image.update(() -> image.color.lerp(!listener.isOver() ? Color.lightGray : Color.white, Mathf.clamp(0.4f * Time.delta)));
                    }
                    if (this.unlocked(unlock)) {
                        image.clicked(() -> {
                            if (Core.input.keyDown(KeyCode.shiftLeft) && Fonts.getUnicode(unlock.name) != 0) {
                                Core.app.setClipboardText((char)Fonts.getUnicode(unlock.name) + "");
                                Vars.ui.showInfoFade("@copied");
                            } else {
                                Vars.ui.content.show(unlock);
                            }
                        });
                        image.addListener(new Tooltip(t -> t.background(Tex.button).add(unlock.localizedName)));
                    }
                    if (++count % cols != 0) continue;
                    list.row();
                }
            }).growX().left().padBottom(10.0f);
            table.row();
        }
        this.cont.add(pane);
    }

    boolean unlocked(UnlockableContent content) {
        return !Vars.state.isCampaign() && !Vars.state.isMenu() || content.unlocked();
    }
}

