/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.ui.dialogs.BaseDialog;

public class GameOverDialog
extends BaseDialog {
    private Team winner;

    public GameOverDialog() {
        super("@gameover");
        this.setFillParent(true);
        this.shown(this::rebuild);
        Events.on(EventType.ResetEvent.class, e -> this.hide());
    }

    public void show(Team winner) {
        this.winner = winner;
        this.show();
        if (winner == Vars.player.team()) {
            Events.fire(new EventType.WinEvent());
        } else {
            Events.fire(new EventType.LoseEvent());
        }
    }

    void rebuild() {
        this.title.setText(Vars.state.isCampaign() ? "@sector.curlost" : "@gameover");
        this.buttons.clear();
        this.cont.clear();
        this.buttons.margin(10.0f);
        if (Vars.state.rules.pvp && this.winner != null) {
            this.cont.add(Core.bundle.format("gameover.pvp", this.winner.localized())).pad(6.0f);
            this.buttons.button("@menu", () -> {
                this.hide();
                Vars.logic.reset();
            }).size(130.0f, 60.0f);
        } else {
            if (Vars.control.isHighScore()) {
                this.cont.add("@highscore").pad(6.0f);
                this.cont.row();
            }
            this.cont.pane((Table t) -> {
                t.margin(13.0f);
                t.left().defaults().left();
                t.add(Core.bundle.format("stat.wave", Vars.state.stats.wavesLasted)).row();
                t.add(Core.bundle.format("stat.enemiesDestroyed", Vars.state.stats.enemyUnitsDestroyed)).row();
                t.add(Core.bundle.format("stat.built", Vars.state.stats.buildingsBuilt)).row();
                t.add(Core.bundle.format("stat.destroyed", Vars.state.stats.buildingsDestroyed)).row();
                t.add(Core.bundle.format("stat.deconstructed", Vars.state.stats.buildingsDeconstructed)).row();
                if (Vars.control.saves.getCurrent() != null) {
                    t.add(Core.bundle.format("stat.playtime", Vars.control.saves.getCurrent().getPlayTime())).row();
                }
                if (Vars.state.isCampaign() && !Vars.state.stats.itemsDelivered.isEmpty()) {
                    t.add("@stat.delivered").row();
                    for (Item item : Vars.content.items()) {
                        if (Vars.state.stats.itemsDelivered.get(item, 0) <= 0) continue;
                        t.table((Table items) -> {
                            items.add("    [lightgray]" + Vars.state.stats.itemsDelivered.get(item, 0));
                            items.image(item.icon(Cicon.small)).size(24.0f).pad(4.0f);
                        }).left().row();
                    }
                }
                if (Vars.state.isCampaign() && Vars.net.client()) {
                    t.add("@gameover.waiting").padTop(20.0f).row();
                }
            }).pad(12.0f);
            if (Vars.state.isCampaign()) {
                if (Vars.net.client()) {
                    this.buttons.button("@gameover.disconnect", () -> {
                        Vars.logic.reset();
                        Vars.net.reset();
                        this.hide();
                        Vars.state.set(GameState.State.menu);
                    }).size(170.0f, 60.0f);
                } else {
                    this.buttons.button("@continue", () -> {
                        this.hide();
                        Vars.ui.planet.show();
                    }).size(170.0f, 60.0f);
                }
            } else {
                this.buttons.button("@menu", () -> {
                    this.hide();
                    Vars.logic.reset();
                }).size(140.0f, 60.0f);
            }
        }
    }
}

