/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import java.io.IOException;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.PaletteDialog;

public class HostDialog
extends BaseDialog {
    float w = 300.0f;

    public HostDialog() {
        super("@hostserver");
        this.addCloseButton();
        this.cont.table((Table t) -> {
            t.add("@name").padRight(10.0f);
            t.field(Core.settings.getString("name"), text -> {
                Vars.player.name((String)text);
                Core.settings.put("name", text);
                Vars.ui.listfrag.rebuild();
            }).grow().pad(8.0f).get().setMaxLength(40);
            ImageButton button = t.button(Tex.whiteui, Styles.clearFulli, 40.0f, () -> new PaletteDialog().show((Color color) -> {
                Vars.player.color().set((Color)color);
                Core.settings.put("color-0", color.rgba());
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color();
            });
        }).width(this.w).height(70.0f).pad(4.0f).colspan(3);
        this.cont.row();
        this.cont.add().width(65.0f);
        this.cont.button("@host", () -> {
            if (Core.settings.getString("name").trim().isEmpty()) {
                Vars.ui.showInfo("@noname");
                return;
            }
            this.runHost();
        }).width(this.w).height(70.0f);
        this.cont.button("?", () -> Vars.ui.showInfo("@host.info")).size(65.0f, 70.0f).padLeft(6.0f);
        this.shown(() -> {
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("hostinfo", () -> Vars.ui.showInfo("@host.info")));
            }
        });
    }

    public void runHost() {
        Vars.ui.loadfrag.show("@hosting");
        Time.runTask(5.0f, () -> {
            try {
                Vars.net.host(6567);
                Vars.player.admin(true);
                if (Vars.steam) {
                    Core.app.post(() -> Core.settings.getBoolOnce("steampublic3", () -> Vars.ui.showCustomConfirm("@setting.publichost.name", "@public.confirm", "@yes", "@no", () -> Vars.ui.showCustomConfirm("@setting.publichost.name", "@public.confirm.really", "@no", "@yes", () -> {
                        Core.settings.put("publichost", true);
                        Vars.platform.updateLobby();
                    }, () -> {
                        Core.settings.put("publichost", false);
                        Vars.platform.updateLobby();
                    }), () -> {
                        Core.settings.put("publichost", false);
                        Vars.platform.updateLobby();
                    })));
                    if (Version.modifier.contains("beta") || Version.modifier.contains("alpha")) {
                        Core.settings.put("publichost", false);
                        Vars.platform.updateLobby();
                        Core.settings.getBoolOnce("betapublic", () -> Vars.ui.showInfo("@public.beta"));
                    }
                }
            }
            catch (IOException e) {
                Vars.ui.showException("@server.error", e);
            }
            Vars.ui.loadfrag.hide();
            this.hide();
        });
    }
}

