/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.Net;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timer;
import arc.util.serialization.Jval;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.legacy.LegacyIO;
import mindustry.net.Host;
import mindustry.net.Packets;
import mindustry.net.ServerGroup;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.PaletteDialog;

public class JoinDialog
extends BaseDialog {
    Seq<Server> servers = new Seq();
    Dialog add;
    Server renaming;
    Table local = new Table();
    Table remote = new Table();
    Table global = new Table();
    Table hosts = new Table();
    int totalHosts;
    int refreshes;
    boolean showHidden;
    String lastIp;
    int lastPort;
    Timer.Task ping;

    public JoinDialog() {
        super("@joingame");
        this.loadServers();
        if (!Vars.steam) {
            this.buttons.add().width(60.0f);
        }
        this.buttons.add().growX().width(-1.0f);
        this.addCloseButton();
        this.buttons.add().growX().width(-1.0f);
        if (!Vars.steam) {
            this.buttons.button("?", () -> Vars.ui.showInfo("@join.info")).size(60.0f, 64.0f).width(-1.0f);
        }
        this.add = new BaseDialog("@joingame.title");
        this.add.cont.add("@joingame.ip").padRight(5.0f).left();
        TextField field = this.add.cont.field(Core.settings.getString("ip"), text -> Core.settings.put("ip", text)).size(320.0f, 54.0f).maxTextLength(100).addInputDialog().get();
        this.add.cont.row();
        this.add.buttons.defaults().size(140.0f, 60.0f).pad(4.0f);
        this.add.buttons.button("@cancel", this.add::hide);
        this.add.buttons.button("@ok", () -> {
            if (this.renaming == null) {
                Server server = new Server();
                server.setIP(Core.settings.getString("ip"));
                this.servers.add(server);
            } else {
                this.renaming.setIP(Core.settings.getString("ip"));
            }
            this.saveServers();
            this.setupRemote();
            this.refreshRemote();
            this.add.hide();
        }).disabled(b -> Core.settings.getString("ip").isEmpty() || Vars.net.active());
        this.add.shown(() -> {
            this.add.title.setText(this.renaming != null ? "@server.edit" : "@server.add");
            if (this.renaming != null) {
                field.setText(this.renaming.displayIP());
            }
        });
        this.keyDown(KeyCode.f5, this::refreshAll);
        this.shown(() -> {
            this.setup();
            this.refreshAll();
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("joininfo", () -> Vars.ui.showInfo("@join.info")));
            }
        });
        this.onResize(() -> {
            this.setup();
            this.refreshAll();
        });
    }

    void refreshAll() {
        ++this.refreshes;
        this.refreshLocal();
        this.refreshRemote();
        this.refreshGlobal();
    }

    void setupRemote() {
        this.remote.clear();
        for (Server server : this.servers) {
            TextButton[] buttons = new TextButton[]{null};
            TextButton button = buttons[0] = this.remote.button("[accent]" + server.displayIP(), Styles.cleart, () -> {
                if (!buttons[0].childrenPressed()) {
                    if (server.lastHost != null) {
                        Events.fire(new EventType.ClientPreConnectEvent(server.lastHost));
                        this.safeConnect(server.ip, server.port, server.lastHost.version);
                    } else {
                        this.connect(server.ip, server.port);
                    }
                }
            }).width(this.targetWidth()).pad(4.0f).get();
            button.getLabel().setWrap(true);
            Table inner = new Table();
            button.clearChildren();
            button.add(inner).growX();
            inner.add(button.getLabel()).growX();
            inner.button((Drawable)Icon.upOpen, Styles.emptyi, () -> this.moveRemote(server, -1)).margin(3.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.downOpen, Styles.emptyi, () -> this.moveRemote(server, 1)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.refresh, Styles.emptyi, () -> this.refreshServer(server)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.pencil, Styles.emptyi, () -> {
                this.renaming = server;
                this.add.show();
            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@confirm", "@server.delete", () -> {
                this.servers.remove(server, true);
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            })).margin(3.0f).pad(2.0f).pad(6.0f).top().right();
            button.row();
            server.content = button.table((Table t) -> {}).grow().get();
            this.remote.row();
        }
    }

    void moveRemote(Server server, int sign) {
        int index = this.servers.indexOf(server);
        if (index + sign < 0) {
            return;
        }
        if (index + sign > this.servers.size - 1) {
            return;
        }
        this.servers.remove(index);
        this.servers.insert(index + sign, server);
        this.saveServers();
        this.setupRemote();
        for (Server other : this.servers) {
            if (other.lastHost != null) {
                this.setupServer(other, other.lastHost);
                continue;
            }
            this.refreshServer(other);
        }
    }

    void refreshRemote() {
        for (Server server : this.servers) {
            this.refreshServer(server);
        }
    }

    void refreshServer(Server server) {
        server.content.clear();
        server.content.label(() -> Core.bundle.get("server.refreshing") + Strings.animated(Time.time, 4, 11.0f, "."));
        Vars.net.pingHost(server.ip, server.port, host -> this.setupServer(server, (Host)host), e -> {
            server.content.clear();
            server.content.add("@host.invalid").padBottom(4.0f);
        });
    }

    void setupServer(Server server, Host host) {
        server.lastHost = host;
        server.content.clear();
        this.buildServer(host, server.content);
    }

    void buildServer(Host host, Table content) {
        String versionString = host.version == -1 ? Core.bundle.format("server.version", Core.bundle.get("server.custombuild"), "") : (host.version == 0 ? Core.bundle.get("server.outdated") : (host.version < Version.build && Version.build != -1 ? Core.bundle.get("server.outdated") + "\n" + Core.bundle.format("server.version", host.version, "") : (host.version > Version.build && Version.build != -1 ? Core.bundle.get("server.outdated.client") + "\n" + Core.bundle.format("server.version", host.version, "") : (host.version == Version.build && Version.type.equals(host.versionType) ? "" : Core.bundle.format("server.version", host.version, host.versionType)))));
        content.table((Table t) -> {
            t.add("[lightgray]" + host.name + "   " + versionString).width(this.targetWidth() - 10.0f).left().get().setEllipsis(true);
            t.row();
            if (!host.description.isEmpty()) {
                t.add("[gray]" + host.description).width(this.targetWidth() - 10.0f).left().wrap();
                t.row();
            }
            t.add("[lightgray]" + Core.bundle.format("players" + (host.players == 1 && host.playerLimit <= 0 ? ".single" : ""), (host.players == 0 ? "[lightgray]" : "[accent]") + host.players + (host.playerLimit > 0 ? "[lightgray]/[accent]" + host.playerLimit : "") + "[lightgray]")).left();
            t.row();
            t.add("[lightgray]" + Core.bundle.format("save.map", host.mapname) + "[lightgray] / " + (host.modeName == null ? host.mode.toString() : host.modeName)).width(this.targetWidth() - 10.0f).left().get().setEllipsis(true);
            if (host.ping > 0) {
                t.row();
                t.add("\ue819 " + host.ping + "ms").color(Color.gray).left();
            }
        }).expand().left().bottom().padLeft(12.0f).padBottom(8.0f);
    }

    void setup() {
        this.local.clear();
        this.remote.clear();
        this.global.clear();
        float w = this.targetWidth();
        this.hosts.clear();
        this.section("@servers.local", this.local, false);
        this.section("@servers.remote", this.remote, false);
        this.section("@servers.global", this.global, true);
        ScrollPane pane = new ScrollPane((Element)this.hosts);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabled(true, false);
        this.setupRemote();
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.add("@name").padRight(10.0f);
            t.field(Core.settings.getString("name"), text -> {
                Vars.player.name((String)text);
                Core.settings.put("name", text);
            }).grow().pad(8.0f).addInputDialog(40);
            ImageButton button = t.button(Tex.whiteui, Styles.clearFulli, 40.0f, () -> new PaletteDialog().show((Color color) -> {
                Vars.player.color().set((Color)color);
                Core.settings.put("color-0", color.rgba8888());
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color();
            });
        }).width(w).height(70.0f).pad(4.0f);
        this.cont.row();
        this.cont.add(pane).width(w + 38.0f).pad(0.0f);
        this.cont.row();
        this.cont.buttonCenter("@server.add", Icon.add, () -> {
            this.renaming = null;
            this.add.show();
        }).marginLeft(10.0f).width(w).height(80.0f).update((T button) -> {
            Cell cell;
            float pw = w;
            float pad = 0.0f;
            if (((Element)pane.getChildren().first()).getPrefHeight() > pane.getHeight()) {
                pw = w + 30.0f;
                pad = 6.0f;
            }
            if (!Mathf.equal((cell = ((Table)pane.parent).getCell(button)).minWidth(), pw)) {
                cell.width(pw);
                cell.padLeft(pad);
                pane.parent.invalidateHierarchy();
            }
        });
    }

    void section(String label, Table servers, boolean eye) {
        Collapser coll = new Collapser(servers, Core.settings.getBool("collapsed-" + label, false));
        coll.setDuration(0.1f);
        this.hosts.table((Table name) -> {
            name.add(label).pad(10.0f).growX().left().color(Pal.accent);
            if (eye) {
                name.button((Drawable)Icon.eyeSmall, Styles.emptyi, () -> {
                    this.showHidden = !this.showHidden;
                    this.refreshGlobal();
                }).update((T i) -> {
                    i.getStyle().imageUp = this.showHidden ? Icon.eyeSmall : Icon.eyeOffSmall;
                }).size(40.0f).right().padRight(3.0f).tooltip("@servers.showhidden");
            }
            name.button((Drawable)Icon.downOpen, Styles.emptyi, () -> {
                coll.toggle(false);
                Core.settings.put("collapsed-" + label, coll.isCollapsed());
            }).update((T i) -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).size(40.0f).right().padRight(10.0f);
        }).growX();
        this.hosts.row();
        this.hosts.image().growX().pad(5.0f).padLeft(10.0f).padRight(10.0f).height(3.0f).color(Pal.accent);
        this.hosts.row();
        this.hosts.add(coll).width(this.targetWidth());
        this.hosts.row();
    }

    void refreshLocal() {
        this.totalHosts = 0;
        this.local.clear();
        this.local.background(null);
        this.local.table(Tex.button, t -> t.label(() -> "[accent]" + Core.bundle.get("hosts.discovering.any") + Strings.animated(Time.time, 4, 10.0f, ".")).pad(10.0f)).growX();
        Vars.net.discoverServers(this::addLocalHost, this::finishLocalHosts);
    }

    void refreshGlobal() {
        int cur = this.refreshes;
        this.global.clear();
        this.global.background(null);
        for (ServerGroup group : Vars.defaultServers) {
            boolean hidden = group.hidden();
            if (hidden && !this.showHidden) continue;
            Table[] groupTable = new Table[]{null};
            for (String address : group.addresses) {
                String resaddress = address.contains(":") ? address.split(":")[0] : address;
                int resport = address.contains(":") ? Strings.parseInt(address.split(":")[1]) : 6567;
                Vars.net.pingHost(resaddress, resport, res -> {
                    if (this.refreshes != cur) {
                        return;
                    }
                    res.port = resport;
                    if (groupTable[0] == null) {
                        this.global.table((Table t) -> {
                            groupTable[0] = t;
                        }).row();
                        groupTable[0].table((Table head) -> {
                            if (!group.name.isEmpty()) {
                                head.add(group.name).color(Color.lightGray).padRight(4.0f);
                            }
                            head.image().height(3.0f).growX().color(Color.lightGray);
                            ImageButton[] image = new ImageButton[]{null};
                            image[0] = head.button((Drawable)(hidden ? Icon.eyeOffSmall : Icon.eyeSmall), Styles.accenti, () -> {
                                group.setHidden(!group.hidden());
                                Drawable drawable = image[0].getStyle().imageUp = group.hidden() ? Icon.eyeOffSmall : Icon.eyeSmall;
                                if (group.hidden() && !this.showHidden) {
                                    groupTable[0].remove();
                                }
                            }).size(40.0f).get();
                            image[0].addListener(new Tooltip(t -> t.background(Styles.black6).margin(4.0f).label(() -> !group.hidden() ? "@server.shown" : "@server.hidden")));
                        }).width(this.targetWidth()).padBottom(-2.0f).row();
                    }
                    this.addGlobalHost((Host)res, groupTable[0]);
                    groupTable[0].margin(5.0f);
                    groupTable[0].pack();
                }, e -> {});
            }
        }
    }

    void addGlobalHost(Host host, Table container) {
        this.global.background(null);
        float w = this.targetWidth();
        container.button((Button b) -> this.buildServer(host, (Table)b), (Button.ButtonStyle)Styles.cleart, () -> {
            Events.fire(new EventType.ClientPreConnectEvent(host));
            if (!Core.settings.getBool("server-disclaimer", false)) {
                Vars.ui.showCustomConfirm("@warning", "@servers.disclaimer", "@ok", "@back", () -> {
                    Core.settings.put("server-disclaimer", true);
                    this.safeConnect(host.address, host.port, host.version);
                }, () -> Core.settings.put("server-disclaimer", false));
            } else {
                this.safeConnect(host.address, host.port, host.version);
            }
        }).width(w).row();
    }

    void finishLocalHosts() {
        if (this.totalHosts == 0) {
            this.local.clear();
            this.local.background(Tex.button);
            this.local.add("@hosts.none").pad(10.0f);
            this.local.add().growX();
            this.local.button(Icon.refresh, this::refreshLocal).pad(-12.0f).padLeft(0.0f).size(70.0f);
        } else {
            this.local.background(null);
        }
    }

    void addLocalHost(Host host) {
        if (this.totalHosts == 0) {
            this.local.clear();
        }
        this.local.background(null);
        ++this.totalHosts;
        float w = this.targetWidth();
        this.local.row();
        this.local.button((Button b) -> this.buildServer(host, (Table)b), (Button.ButtonStyle)Styles.cleart, () -> {
            Events.fire(new EventType.ClientPreConnectEvent(host));
            this.safeConnect(host.address, host.port, host.version);
        }).width(w);
    }

    public void connect(String ip, int port) {
        if (Vars.player.name.trim().isEmpty()) {
            Vars.ui.showInfo("@noname");
            return;
        }
        Vars.ui.loadfrag.show("@connecting");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
        Time.runTask(2.0f, () -> {
            Vars.logic.reset();
            Vars.net.reset();
            Vars.netClient.beginConnecting();
            this.lastIp = ip;
            this.lastPort = port;
            Vars.net.connect(this.lastIp, this.lastPort, () -> {
                if (Vars.net.client()) {
                    this.hide();
                    this.add.hide();
                }
            });
        });
    }

    public void reconnect() {
        if (this.lastIp == null || this.lastIp.isEmpty()) {
            return;
        }
        Vars.ui.loadfrag.show("@reconnecting");
        this.ping = Timer.schedule(() -> Vars.net.pingHost(this.lastIp, this.lastPort, host -> {
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
            this.connect(this.lastIp, this.lastPort);
        }, exception -> {}), 1.0f, 1.0f);
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
        });
    }

    void safeConnect(String ip, int port, int version) {
        if (version != Version.build && Version.build != -1 && version != -1) {
            Vars.ui.showInfo("[scarlet]" + (version > Version.build ? Packets.KickReason.clientOutdated : Packets.KickReason.serverOutdated).toString() + "\n[]" + Core.bundle.format("server.versions", Version.build, version));
        } else {
            this.connect(ip, port);
        }
    }

    float targetWidth() {
        return Math.min((float)Core.graphics.getWidth() / Scl.scl() * 0.9f, 500.0f);
    }

    private void loadServers() {
        this.servers = Core.settings.getJson("servers", Seq.class, Server.class, Seq::new);
        if (Core.settings.has("server-list")) {
            this.servers = LegacyIO.readServers();
            Core.settings.remove("server-list");
        }
        String url = Vars.becontrol.active() ? "https://raw.githubusercontent.com/Anuken/Mindustry/master/servers_be.json" : "https://raw.githubusercontent.com/Anuken/Mindustry/master/servers_v6.json";
        Log.info("Fetching community servers at @", url);
        Core.net.httpGet(url, result -> {
            try {
                if (result.getStatus() != Net.HttpStatus.OK) {
                    Log.warn("Failed to fetch community servers: @", new Object[]{result.getStatus()});
                    return;
                }
                Jval val = Jval.read(result.getResultAsString());
                Core.app.post(() -> {
                    try {
                        Vars.defaultServers.clear();
                        val.asArray().each(child -> {
                            String name = child.getString("name", "");
                            String[] addresses = child.has("addresses") || child.has("address") && child.get("address").isArray() ? (String[])(child.has("addresses") ? child.get("addresses") : child.get("address")).asArray().map(Jval::asString).toArray(String.class) : new String[]{child.getString("address", "<invalid>")};
                            Vars.defaultServers.add(new ServerGroup(name, addresses));
                        });
                        Log.info("Fetched @ community servers.", Vars.defaultServers.size);
                    }
                    catch (Throwable e) {
                        Log.err("Failed to parse community servers.", new Object[0]);
                        Log.err(e);
                    }
                });
            }
            catch (Throwable e) {
                Log.err("Failed to fetch community servers.", new Object[0]);
                Log.err(e);
            }
        }, Log::err);
    }

    private void saveServers() {
        Core.settings.putJson("servers", Server.class, this.servers);
    }

    public static class Server {
        public String ip;
        public int port;
        transient Table content;
        transient Host lastHost;

        void setIP(String ip) {
            try {
                boolean isIpv6;
                boolean bl = isIpv6 = Strings.count((CharSequence)ip, ':') > 1;
                if (isIpv6 && ip.lastIndexOf("]:") != -1 && ip.lastIndexOf("]:") != ip.length() - 1) {
                    int idx = ip.indexOf("]:");
                    this.ip = ip.substring(1, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 2));
                } else if (!isIpv6 && ip.lastIndexOf(58) != -1 && ip.lastIndexOf(58) != ip.length() - 1) {
                    int idx = ip.lastIndexOf(58);
                    this.ip = ip.substring(0, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 1));
                } else {
                    this.ip = ip;
                    this.port = 6567;
                }
            }
            catch (Exception e) {
                this.ip = ip;
                this.port = 6567;
            }
        }

        String displayIP() {
            if (Strings.count((CharSequence)this.ip, ':') > 1) {
                return this.port != 6567 ? "[" + this.ip + "]:" + this.port : this.ip;
            }
            return this.ip + (this.port != 6567 ? ":" + this.port : "");
        }
    }
}

