/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Element;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.Strings;
import java.util.Locale;
import mindustry.Vars;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LanguageDialog
extends BaseDialog {
    private Locale lastLocale;
    private ObjectMap<Locale, String> displayNames = ObjectMap.of(Locale.TRADITIONAL_CHINESE, "\u6b63\u9ad4\u4e2d\u6587", Locale.SIMPLIFIED_CHINESE, "\u7b80\u4f53\u4e2d\u6587");

    public LanguageDialog() {
        super("@settings.language");
        this.addCloseButton();
        this.setup();
    }

    private void setup() {
        Table langs = new Table();
        langs.marginRight(24.0f).marginLeft(24.0f);
        ScrollPane pane = new ScrollPane((Element)langs);
        pane.setScrollingDisabled(true, false);
        ButtonGroup group = new ButtonGroup();
        for (Locale loc : Vars.locales) {
            TextButton button = new TextButton(Strings.capitalize(this.displayNames.get(loc, loc.getDisplayName(loc))), Styles.clearTogglet);
            button.clicked(() -> {
                if (this.getLocale().equals(loc)) {
                    return;
                }
                Core.settings.put("locale", loc.toString());
                Log.info("Setting locale: @", loc.toString());
                Vars.ui.showInfo("@language.restart");
            });
            langs.add(button).group(group).update((T t) -> t.setChecked(loc.equals(this.getLocale()))).size(400.0f, 50.0f).row();
        }
        this.cont.add(pane);
    }

    public Locale getLocale() {
        String loc = Core.settings.getString("locale");
        if (loc.equals("default")) {
            this.findClosestLocale();
        }
        if (this.lastLocale == null || !this.lastLocale.toString().equals(loc)) {
            if (loc.contains("_")) {
                String[] split = loc.split("_");
                this.lastLocale = new Locale(split[0], split[1]);
            } else {
                this.lastLocale = new Locale(loc);
            }
        }
        return this.lastLocale;
    }

    void findClosestLocale() {
        for (Locale l : Vars.locales) {
            if (!l.equals(Locale.getDefault())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        for (Locale l : Vars.locales) {
            if (!l.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        Core.settings.put("locale", new Locale("en").toString());
    }
}

