/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Cons;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Schematic;
import mindustry.gen.Icon;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadoutDialog;
import mindustry.ui.dialogs.SchematicsDialog;
import mindustry.world.blocks.storage.CoreBlock;

public class LaunchLoadoutDialog
extends BaseDialog {
    LoadoutDialog loadout = new LoadoutDialog();
    ItemSeq total = new ItemSeq();
    Schematic selected;
    boolean valid;

    public LaunchLoadoutDialog() {
        super("@configure");
    }

    public void show(CoreBlock core, Sector sector, Runnable confirm) {
        this.cont.clear();
        this.buttons.clear();
        this.buttons.defaults().size(160.0f, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide);
        this.addCloseListener();
        ItemSeq sitems = sector.items();
        Runnable update = () -> {
            int cap = this.selected.findCore().itemCapacity;
            ItemSeq resources = Vars.universe.getLaunchResources();
            resources.min(cap);
            Vars.universe.updateLaunchResources(resources);
            this.total.clear();
            this.selected.requirements().each(this.total::add);
            Vars.universe.getLaunchResources().each(this.total::add);
            this.valid = sitems.has(this.total);
        };
        Cons<Table> rebuild = table -> {
            table.clearChildren();
            int i = 0;
            ItemSeq schems = this.selected.requirements();
            ItemSeq launches = Vars.universe.getLaunchResources();
            for (ItemStack s : this.total) {
                table.image(s.item.icon(Cicon.small)).left().size(Cicon.small.size);
                int as = schems.get(s.item);
                int al = launches.get(s.item);
                String amountStr = al + as + "[gray] (" + al + " + " + as + ")";
                table.add(sitems.has(s.item, s.amount) ? amountStr : "[scarlet]" + Math.min(sitems.get(s.item), s.amount) + "[lightgray]/" + amountStr).padLeft(2.0f).left().padRight(4.0f);
                if (++i % 4 != 0) continue;
                table.row();
            }
        };
        Table items = new Table();
        Runnable rebuildItems = () -> rebuild.get(items);
        this.buttons.button("@resources", Icon.terrain, () -> {
            ItemSeq stacks = Vars.universe.getLaunchResources();
            Seq<ItemStack> out = stacks.toSeq();
            ItemSeq realItems = sitems.copy();
            this.selected.requirements().each(realItems::remove);
            this.loadout.show(this.selected.findCore().itemCapacity, realItems, out, UnlockableContent::unlocked, out::clear, () -> {}, () -> {
                Vars.universe.updateLaunchResources(new ItemSeq(out));
                update.run();
                rebuildItems.run();
            });
        }).width(204.0f);
        this.buttons.button("@launch.text", Icon.ok, () -> {
            Vars.universe.updateLoadout(core, this.selected);
            confirm.run();
            this.hide();
        }).disabled(b -> !this.valid);
        int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1);
        ButtonGroup group = new ButtonGroup();
        this.selected = Vars.universe.getLoadout(core);
        if (this.selected == null) {
            this.selected = Vars.schematics.getLoadouts().get((CoreBlock)Blocks.coreShard).first();
        }
        this.cont.add(Core.bundle.format("launch.from", sector.name())).row();
        this.cont.pane((Table t) -> {
            int i = 0;
            for (ObjectMap.Entry entry : Vars.schematics.getLoadouts()) {
                if (((CoreBlock)entry.key).size > core.size) continue;
                for (Schematic s : (Seq)entry.value) {
                    t.button((Button b) -> b.add(new SchematicsDialog.SchematicImage(s)), (Button.ButtonStyle)Styles.togglet, () -> {
                        this.selected = s;
                        update.run();
                        rebuildItems.run();
                    }).group(group).pad(4.0f).checked(s == this.selected).size(200.0f);
                    if (++i % cols != 0) continue;
                    t.row();
                }
            }
        }).growX().get().setScrollingDisabled(true, false);
        this.cont.row();
        this.cont.pane(items);
        this.cont.row();
        this.cont.add("@sector.missingresources").visible(() -> !this.valid);
        update.run();
        rebuildItems.run();
        this.show();
    }
}

