/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolf;
import arc.input.KeyCode;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LoadoutDialog
extends BaseDialog {
    private Runnable hider;
    private Runnable resetter;
    private Runnable updater;
    private Seq<ItemStack> stacks = new Seq();
    private Seq<ItemStack> originalStacks = new Seq();
    private Boolf<Item> validator = i -> true;
    private Table items;
    private int capacity;
    @Nullable
    private ItemSeq total;

    public LoadoutDialog() {
        super("@configure");
        this.setFillParent(true);
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                Core.app.post(this::hide);
            }
        });
        this.cont.pane((Table t) -> {
            this.items = t.margin(10.0f);
        }).left();
        this.shown(this::setup);
        this.hidden(() -> {
            this.originalStacks.selectFrom(this.stacks, s -> s.amount > 0);
            this.updater.run();
            if (this.hider != null) {
                this.hider.run();
            }
        });
        this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
        this.buttons.button("@max", Icon.export, this::maxItems).size(210.0f, 64.0f);
        this.buttons.button("@settings.reset", Icon.refresh, () -> {
            this.resetter.run();
            this.reseed();
            this.updater.run();
            this.setup();
        }).size(210.0f, 64.0f);
    }

    public void maxItems() {
        for (ItemStack stack : this.stacks) {
            stack.amount = this.total == null ? this.capacity : Math.max(Math.min(this.capacity, this.total.get(stack.item)), 0);
        }
    }

    public void show(int capacity, Seq<ItemStack> stacks, Boolf<Item> validator, Runnable reseter, Runnable updater, Runnable hider) {
        this.show(capacity, null, stacks, validator, reseter, updater, hider);
    }

    public void show(int capacity, ItemSeq total, Seq<ItemStack> stacks, Boolf<Item> validator, Runnable reseter, Runnable updater, Runnable hider) {
        this.originalStacks = stacks;
        this.validator = validator;
        this.resetter = reseter;
        this.updater = updater;
        this.capacity = capacity;
        this.total = total;
        this.hider = hider;
        this.reseed();
        this.show();
    }

    void setup() {
        this.items.clearChildren();
        this.items.left();
        float bsize = 40.0f;
        int i = 0;
        for (ItemStack stack : this.stacks) {
            this.items.table(Tex.pane, t -> {
                t.margin(4.0f).marginRight(8.0f).left();
                t.button("-", Styles.cleart, () -> {
                    stack.amount = Math.max(stack.amount - this.step(stack.amount), 0);
                    this.updater.run();
                }).size(bsize);
                t.button("+", Styles.cleart, () -> {
                    stack.amount = Math.min(stack.amount + this.step(stack.amount), this.capacity);
                    this.updater.run();
                }).size(bsize);
                t.button((Drawable)Icon.pencil, Styles.cleari, () -> Vars.ui.showTextInput("@configure", stack.item.localizedName, 10, stack.amount + "", true, str -> {
                    int amount;
                    if (Strings.canParsePositiveInt(str) && (amount = Strings.parseInt(str)) >= 0 && amount <= this.capacity) {
                        stack.amount = amount;
                        this.updater.run();
                        return;
                    }
                    Vars.ui.showInfo(Core.bundle.format("configure.invalid", this.capacity));
                })).size(bsize);
                t.image(stack.item.icon(Cicon.small)).size(24.0f).padRight(4.0f).padLeft(4.0f);
                t.label(() -> stack.amount + "").left().width(90.0f);
            }).pad(2.0f).left().fillX();
            if (++i % 2 != 0 && (!Vars.mobile || !Core.graphics.isPortrait())) continue;
            this.items.row();
        }
    }

    private void reseed() {
        this.stacks = this.originalStacks.map(ItemStack::copy);
        this.stacks.addAll(Vars.content.items().select(i -> this.validator.get((Item)i) && !this.stacks.contains((ItemStack)((Object)((Boolf<ItemStack>)stack -> stack.item == i)))).map(i -> new ItemStack((Item)i, 0)));
        this.stacks.sort(Structs.comparingInt(s -> s.item.id));
    }

    private int step(int amount) {
        if (amount < 1000) {
            return 100;
        }
        if (amount < 2000) {
            return 200;
        }
        if (amount < 5000) {
            return 500;
        }
        return 1000;
    }
}

