/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Element;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CustomRulesDialog;

public class MapPlayDialog
extends BaseDialog {
    CustomRulesDialog dialog = new CustomRulesDialog();
    Rules rules;
    Gamemode selectedGamemode = Gamemode.survival;
    Map lastMap;

    public MapPlayDialog() {
        super("");
        this.setFillParent(false);
        this.onResize(() -> {
            if (this.lastMap != null) {
                Rules rules = this.rules;
                this.show(this.lastMap);
                this.rules = rules;
            }
        });
    }

    public void show(Map map) {
        this.lastMap = map;
        this.title.setText(map.name());
        this.cont.clearChildren();
        if (!this.selectedGamemode.valid(map)) {
            this.selectedGamemode = Structs.find(Gamemode.all, m -> m.valid(map));
            if (this.selectedGamemode == null) {
                this.selectedGamemode = Gamemode.survival;
            }
        }
        this.rules = map.applyRules(this.selectedGamemode);
        Table selmode = new Table();
        selmode.add("@level.mode").colspan(4);
        selmode.row();
        int i = 0;
        Table modes = new Table();
        for (Gamemode mode : Gamemode.values()) {
            if (mode.hidden) continue;
            modes.button(mode.toString(), Styles.togglet, () -> {
                this.selectedGamemode = mode;
                this.rules = map.applyRules(mode);
            }).update((T b) -> b.setChecked(this.selectedGamemode == mode)).size(140.0f, 54.0f).disabled(!mode.valid(map));
            if (i++ % 2 != 1) continue;
            modes.row();
        }
        selmode.add(modes);
        selmode.button("?", this::displayGameModeHelp).width(50.0f).fillY().padLeft(18.0f);
        this.cont.add(selmode);
        this.cont.row();
        this.cont.button("@customize", Icon.settings, () -> this.dialog.show(this.rules, () -> {
            this.rules = map.applyRules(this.selectedGamemode);
            return this.rules;
        })).height(50.0f).width(230.0f);
        this.cont.row();
        this.cont.add(new BorderImage(map.safeTexture(), 3.0f)).size(Vars.mobile && !Core.graphics.isPortrait() ? 150.0f : 250.0f).get().setScaling(Scaling.fit);
        if (Gamemode.survival.valid(map)) {
            this.cont.row();
            this.cont.label(() -> Core.bundle.format("level.highscore", map.getHightScore())).pad(3.0f);
        }
        this.buttons.clearChildren();
        this.addCloseButton();
        this.buttons.button("@play", Icon.play, () -> {
            Vars.control.playMap(map, this.rules);
            this.hide();
            Vars.ui.custom.hide();
        }).size(210.0f, 64.0f);
        this.show();
    }

    private void displayGameModeHelp() {
        BaseDialog d = new BaseDialog(Core.bundle.get("mode.help.title"));
        d.setFillParent(false);
        Table table = new Table();
        table.defaults().pad(1.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        table.row();
        for (Gamemode mode : Gamemode.values()) {
            if (mode.hidden) continue;
            table.labelWrap("[accent]" + mode.toString() + ":[] [lightgray]" + mode.description()).width(400.0f);
            table.row();
        }
        d.cont.add(pane);
        d.buttons.button("@ok", d::hide).size(110.0f, 50.0f).pad(10.0f);
        d.show();
    }
}

