/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.Net;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.scene.event.ClickListener;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.TextButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.mod.ModListing;
import mindustry.mod.Mods;
import mindustry.type.Publishable;
import mindustry.ui.BorderImage;
import mindustry.ui.Cicon;
import mindustry.ui.SearchBar;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class ModsDialog
extends BaseDialog {
    private ObjectMap<String, TextureRegion> textureCache = new ObjectMap();
    private String searchtxt = "";
    @Nullable
    private Seq<ModListing> modList;
    private boolean orderDate = false;
    private BaseDialog currentContent;
    private BaseDialog browser;
    private Table browserTable;

    public ModsDialog() {
        super("@mods");
        this.addCloseButton();
        this.browser = new BaseDialog("@mods.browser");
        this.browser.cont.table((Table table) -> {
            table.left();
            table.image(Icon.zoom);
            table.field(this.searchtxt, res -> {
                this.searchtxt = res;
                this.rebuildBrowser();
            }).growX().get();
            table.button(Icon.list, Styles.clearPartiali, 32.0f, () -> {
                this.orderDate = !this.orderDate;
                this.rebuildBrowser();
            }).update((T b) -> {
                b.getStyle().imageUp = this.orderDate ? Icon.list : Icon.star;
            }).size(40.0f).get().addListener(new Tooltip(tip -> tip.label(() -> this.orderDate ? "@mods.browser.sortdate" : "@mods.browser.sortstars").left()));
        }).fillX().padBottom(4.0f);
        this.browser.cont.row();
        this.browser.cont.pane((Table tablebrow) -> {
            tablebrow.margin(10.0f).top();
            this.browserTable = tablebrow;
        }).get().setScrollingDisabled(true, false);
        this.browser.addCloseButton();
        this.browser.onResize(this::rebuildBrowser);
        this.buttons.button("@mods.guide", Icon.link, () -> Core.app.openURI("https://mindustrygame.github.io/wiki/modding/1-modding/")).size(210.0f, 64.0f);
        if (!Vars.mobile) {
            this.buttons.button("@mods.openfolder", Icon.link, () -> Core.app.openFolder(Vars.modDirectory.absolutePath()));
        }
        this.shown(this::setup);
        if (Vars.mobile) {
            this.onResize(this::setup);
        }
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.currentContent != null) {
                this.currentContent.hide();
                this.currentContent = null;
            }
        });
        this.hidden(() -> {
            if (Vars.mods.requiresReload()) {
                this.reload();
            }
        });
    }

    void modError(Throwable error) {
        Vars.ui.loadfrag.hide();
        if (Strings.getCauses(error).contains((Throwable)((Object)((Boolf<Throwable>)t -> t.getMessage() != null && (t.getMessage().contains("trust anchor") || t.getMessage().contains("SSL") || t.getMessage().contains("protocol")))))) {
            Vars.ui.showErrorMessage("@feature.unsupported");
        } else {
            Vars.ui.showException(error);
        }
    }

    void getModList(Cons<Seq<ModListing>> listener) {
        if (this.modList == null) {
            Core.net.httpGet("https://raw.githubusercontent.com/Anuken/MindustryMods/master/mods.json", response -> {
                String strResult = response.getResultAsString();
                Net.HttpStatus status = response.getStatus();
                Core.app.post(() -> {
                    if (status != Net.HttpStatus.OK) {
                        Vars.ui.showErrorMessage(Core.bundle.format("connectfail", new Object[]{status}));
                    } else {
                        try {
                            this.modList = JsonIO.json.fromJson(Seq.class, ModListing.class, strResult);
                            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                            Func<String, Date> parser = text -> {
                                try {
                                    return d.parse((String)text);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            };
                            this.modList.sortComparing(m -> (Date)parser.get(m.lastUpdated)).reverse();
                            listener.get(this.modList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Vars.ui.showException(e);
                        }
                    }
                });
            }, error -> Core.app.post(() -> this.modError((Throwable)error)));
        } else {
            listener.get(this.modList);
        }
    }

    void setup() {
        float h = 110.0f;
        float w = Vars.mobile ? 440.0f : 524.0f;
        this.cont.clear();
        this.cont.defaults().width(Vars.mobile ? 500.0f : 560.0f).pad(4.0f);
        this.cont.add("@mod.reloadrequired").visible(Vars.mods::requiresReload).center().get().setAlignment(1);
        this.cont.row();
        this.cont.table((Table buttons) -> {
            buttons.left().defaults().growX().height(60.0f).uniformX();
            TextButton.TextButtonStyle style = Styles.clearPartialt;
            float margin = 12.0f;
            buttons.button("@mod.import", (Drawable)Icon.add, style, () -> {
                BaseDialog dialog = new BaseDialog("@mod.import");
                TextButton.TextButtonStyle bstyle = Styles.cleart;
                dialog.cont.table(Tex.button, t -> {
                    t.defaults().size(300.0f, 70.0f);
                    t.margin(12.0f);
                    t.button("@mod.import.file", (Drawable)Icon.file, bstyle, () -> {
                        dialog.hide();
                        Vars.platform.showMultiFileChooser(file -> {
                            Runnable go = () -> {
                                try {
                                    Vars.mods.importMod((Fi)file);
                                    this.setup();
                                }
                                catch (IOException e) {
                                    Vars.ui.showException(e);
                                    e.printStackTrace();
                                }
                            };
                            if (file.extEquals("jar")) {
                                Vars.ui.showConfirm("@warning", "@mod.jarwarn", go);
                            } else {
                                go.run();
                            }
                        }, "zip", "jar");
                    }).margin(12.0f);
                    t.row();
                    t.button("@mod.import.github", (Drawable)Icon.github, bstyle, () -> {
                        dialog.hide();
                        Vars.ui.showTextInput("@mod.import.github", "", 64, Core.settings.getString("lastmod", ""), text -> {
                            if ((text = text.trim().replace(" ", "")).startsWith("https://github.com/")) {
                                text = text.substring("https://github.com/".length());
                            }
                            Core.settings.put("lastmod", text);
                            this.githubImportMod((String)text, false);
                        });
                    }).margin(12.0f);
                });
                dialog.addCloseButton();
                dialog.show();
            }).margin(margin);
            buttons.button("@mods.browser", (Drawable)Icon.menu, style, this::showModBrowser).margin(margin);
        }).width(w);
        this.cont.row();
        if (!Vars.mods.list().isEmpty()) {
            boolean[] anyDisabled = new boolean[]{false};
            SearchBar.add(this.cont, Vars.mods.list(), mod -> mod.meta.displayName(), (table, mod) -> {
                if (!mod.enabled() && !anyDisabled[0] && Vars.mods.list().size > 0) {
                    anyDisabled[0] = true;
                    table.row();
                    table.image().growX().height(4.0f).pad(6.0f).color(Pal.gray);
                    table.row();
                }
                table.button((Button t) -> {
                    t.top().left();
                    t.margin(12.0f);
                    t.defaults().left().top();
                    t.table((Table title) -> {
                        title.left();
                        title.add(new BorderImage((Mods.LoadedMod)mod){
                            final /* synthetic */ Mods.LoadedMod val$mod;
                            {
                                this.val$mod = loadedMod;
                                if (this.val$mod.iconTexture != null) {
                                    this.setDrawable(new TextureRegion(this.val$mod.iconTexture));
                                } else {
                                    this.setDrawable(Tex.nomap);
                                }
                                this.border(Pal.accent);
                            }
                        }).size(h - 8.0f).padTop(-8.0f).padLeft(-8.0f).padRight(8.0f);
                        title.table((Table text) -> {
                            boolean hideDisabled = !mod.isSupported() || mod.hasUnmetDependencies() || mod.hasContentErrors();
                            text.add("[accent]" + Strings.stripColors(mod.meta.displayName()) + "\n[lightgray]v" + Strings.stripColors(this.trimText(mod.meta.version)) + (mod.enabled() || hideDisabled ? "" : "\n" + Core.bundle.get("mod.disabled") + "")).wrap().top().width(300.0f).growX().left();
                            text.row();
                            if (mod.isOutdated()) {
                                text.labelWrap("@mod.outdated").growX();
                                text.row();
                            } else if (!mod.isSupported()) {
                                text.labelWrap(Core.bundle.format("mod.requiresversion", mod.meta.minGameVersion)).growX();
                                text.row();
                            } else if (mod.hasUnmetDependencies()) {
                                text.labelWrap(Core.bundle.format("mod.missingdependencies", mod.missingDependencies.toString(", "))).growX();
                                t.row();
                            } else if (mod.hasContentErrors()) {
                                text.labelWrap("@mod.erroredcontent").growX();
                                text.row();
                            } else if (mod.meta.hidden) {
                                text.labelWrap("@mod.multiplayer.compatible").growX();
                                text.row();
                            }
                        }).top().growX();
                        title.add().growX();
                    }).growX().growY().left();
                    t.table((Table right) -> {
                        right.right();
                        right.button((Drawable)(mod.enabled() ? Icon.downOpen : Icon.upOpen), Styles.clearPartiali, () -> {
                            Vars.mods.setEnabled((Mods.LoadedMod)mod, !mod.enabled());
                            this.setup();
                        }).size(50.0f).disabled(!mod.isSupported());
                        right.button((Drawable)(mod.hasSteamID() ? Icon.link : Icon.trash), Styles.clearPartiali, () -> {
                            if (!mod.hasSteamID()) {
                                Vars.ui.showConfirm("@confirm", "@mod.remove.confirm", () -> {
                                    Vars.mods.removeMod((Mods.LoadedMod)mod);
                                    this.setup();
                                });
                            } else {
                                Vars.platform.viewListing((Publishable)mod);
                            }
                        }).size(50.0f);
                        if (Vars.steam && !mod.hasSteamID()) {
                            right.row();
                            right.button((Drawable)Icon.export, Styles.clearPartiali, () -> Vars.platform.publish((Publishable)mod)).size(50.0f);
                        }
                    }).growX().right().padRight(-8.0f).padTop(-8.0f);
                }, (Button.ButtonStyle)Styles.clearPartialt, () -> this.showMod((Mods.LoadedMod)mod)).size(w, h).growX().pad(4.0f);
                table.row();
            }, !Vars.mobile || Core.graphics.isPortrait()).margin(10.0f).top();
        } else {
            this.cont.table(Styles.black6, t -> t.add("@mods.none")).height(80.0f);
        }
        this.cont.row();
    }

    private void reload() {
        Vars.ui.showInfoOnHidden("@mods.reloadexit", () -> Core.app.exit());
    }

    private void showMod(Mods.LoadedMod mod) {
        BaseDialog dialog = new BaseDialog(mod.meta.displayName());
        dialog.addCloseButton();
        if (!Vars.mobile) {
            dialog.buttons.button("@mods.openfolder", Icon.link, () -> Core.app.openFolder(mod.file.absolutePath()));
        }
        if (mod.getRepo() != null) {
            boolean showImport = !mod.hasSteamID();
            dialog.buttons.button("@mods.github.open", Icon.link, () -> Core.app.openURI("https://github.com/" + mod.getRepo()));
            if (Vars.mobile && showImport) {
                dialog.buttons.row();
            }
            if (showImport) {
                dialog.buttons.button("@mods.browser.reinstall", Icon.download, () -> this.githubImportMod(mod.getRepo(), mod.isJava()));
            }
        }
        dialog.cont.pane((Table desc) -> {
            desc.center();
            desc.defaults().padTop(10.0f).left();
            desc.add("@editor.name").padRight(10.0f).color(Color.gray).padTop(0.0f);
            desc.row();
            desc.add(mod.meta.displayName()).growX().wrap().padTop(2.0f);
            desc.row();
            if (mod.meta.author != null) {
                desc.add("@editor.author").padRight(10.0f).color(Color.gray);
                desc.row();
                desc.add(mod.meta.author).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if (mod.meta.description != null) {
                desc.add("@editor.description").padRight(10.0f).color(Color.gray).top();
                desc.row();
                desc.add(mod.meta.description).growX().wrap().padTop(2.0f);
                desc.row();
            }
        }).width(400.0f);
        Seq all = Seq.with(Vars.content.getContentMap()).flatten().select(c -> c.minfo.mod == mod && c instanceof UnlockableContent).as();
        if (all.any()) {
            dialog.cont.row();
            dialog.cont.button("@mods.viewcontent", Icon.book, () -> {
                BaseDialog d = new BaseDialog(mod.meta.displayName());
                d.cont.pane((Table cs) -> {
                    int i = 0;
                    for (UnlockableContent c : all) {
                        cs.button(new TextureRegionDrawable(c.icon(Cicon.medium)), Styles.cleari, (float)Cicon.medium.size, () -> Vars.ui.content.show(c)).size(50.0f).with(im -> {
                            ClickListener click = im.getClickListener();
                            im.update(() -> im.getImage().color.lerp(!click.isOver() ? Color.lightGray : Color.white, 0.4f * Time.delta));
                        }).tooltip(c.localizedName);
                        if ((float)(++i) % Math.min((float)Core.graphics.getWidth() / Scl.scl(110.0f), 14.0f) != 0.0f) continue;
                        cs.row();
                    }
                }).grow();
                d.addCloseButton();
                d.show();
                this.currentContent = d;
            }).size(300.0f, 50.0f).pad(4.0f);
        }
        dialog.show();
    }

    private void showModBrowser() {
        this.rebuildBrowser();
        this.browser.show();
    }

    private void rebuildBrowser() {
        final ObjectSet<String> installed = Vars.mods.list().map(m -> m.getRepo()).asSet();
        this.browserTable.clear();
        this.browserTable.add("@loading");
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl(480.0f), 1.0f);
        this.getModList(rlistings -> {
            this.browserTable.clear();
            int i = 0;
            Seq<ModListing> listings = rlistings;
            if (!this.orderDate) {
                listings = rlistings.copy();
                listings.sortComparing(m1 -> -m1.stars);
            }
            for (ModListing mod : listings) {
                if (mod.hasJava && Vars.ios || !this.searchtxt.isEmpty() && !mod.repo.toLowerCase().contains(this.searchtxt.toLowerCase()) || Vars.ios && mod.hasScripts) continue;
                float s = 64.0f;
                this.browserTable.button((Button con) -> {
                    con.margin(0.0f);
                    con.left();
                    final String repo = mod.repo;
                    con.add(new BorderImage(){
                        TextureRegion last;
                        {
                            this.border(installed.contains(repo) ? Pal.accent : Color.lightGray);
                            this.setDrawable(Tex.nomap);
                            this.pad = Scl.scl(4.0f);
                        }

                        @Override
                        public void draw() {
                            TextureRegion next;
                            super.draw();
                            if (!ModsDialog.this.textureCache.containsKey(repo)) {
                                this.last = Tex.nomap.getRegion();
                                ModsDialog.this.textureCache.put(repo, this.last);
                                Core.net.httpGet("https://raw.githubusercontent.com/Anuken/MindustryMods/master/icons/" + repo.replace("/", "_"), res -> {
                                    if (res.getStatus() == Net.HttpStatus.OK) {
                                        Pixmap pix = new Pixmap(res.getResult());
                                        Core.app.post(() -> {
                                            try {
                                                Texture tex = new Texture(pix);
                                                tex.setFilter(Texture.TextureFilter.linear);
                                                ModsDialog.this.textureCache.put(repo, new TextureRegion(tex));
                                                pix.dispose();
                                            }
                                            catch (Exception e) {
                                                Log.err(e);
                                            }
                                        });
                                    }
                                }, err -> {});
                            }
                            if (this.last != (next = (TextureRegion)ModsDialog.this.textureCache.get(repo))) {
                                this.last = next;
                                this.setDrawable(next);
                            }
                        }
                    }).size(s).pad(8.0f);
                    con.add("[accent]" + mod.name.replace("\n", "") + (installed.contains(mod.repo) ? "\n[lightgray]" + Core.bundle.get("mod.installed") : "") + "\n[lightgray]\ue809 " + mod.stars + (Version.isAtLeast(mod.minGameVersion) ? "" : "\n" + Core.bundle.format("mod.requiresversion", mod.minGameVersion))).width(358.0f).wrap().grow().pad(4.0f, 2.0f, 4.0f, 6.0f).top().left().labelAlign(10);
                }, (Button.ButtonStyle)Styles.clearPartialt, () -> {
                    BaseDialog sel = new BaseDialog(mod.name);
                    sel.cont.pane((Table p) -> p.add(mod.description + "\n\n[accent]" + Core.bundle.get("editor.author") + "[lightgray] " + mod.author).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).labelAlign(1, 8)).grow();
                    sel.buttons.defaults().size(150.0f, 54.0f).pad(2.0f);
                    sel.buttons.button("@back", Icon.left, () -> {
                        sel.clear();
                        sel.hide();
                    });
                    Mods.LoadedMod found = Vars.mods.list().find((T l) -> mod.repo != null && mod.repo.equals(l.getRepo()));
                    sel.buttons.button(found == null ? "@mods.browser.add" : "@mods.browser.reinstall", Icon.download, () -> {
                        sel.hide();
                        this.githubImportMod(mod.repo, mod.hasJava);
                    });
                    sel.buttons.button("@mods.github.open", Icon.link, () -> Core.app.openURI("https://github.com/" + mod.repo));
                    sel.keyDown(KeyCode.escape, sel::hide);
                    sel.keyDown(KeyCode.back, sel::hide);
                    sel.show();
                }).width(438.0f).pad(4.0f).growX().left().height(s + 16.0f).fillY();
                if (++i % cols != 0) continue;
                this.browserTable.row();
            }
        });
    }

    private String trimText(String text) {
        if (text == null) {
            return "";
        }
        if (text.contains("\n")) {
            return text.substring(0, text.indexOf("\n"));
        }
        return text;
    }

    private void handleMod(String repo, Net.HttpResponse result) {
        try {
            Fi file = Vars.tmpDirectory.child(repo.replace("/", "") + ".zip");
            Streams.copy(result.getResultAsStream(), file.write(false));
            Mods.LoadedMod mod = Vars.mods.importMod(file);
            mod.setRepo(repo);
            file.delete();
            Core.app.post(() -> {
                try {
                    this.setup();
                    Vars.ui.loadfrag.hide();
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                }
            });
        }
        catch (Throwable e) {
            this.modError(e);
        }
    }

    private void importFail(Throwable t) {
        Core.app.post(() -> this.modError(t));
    }

    private void githubImportMod(String repo, boolean isJava) {
        if (isJava) {
            Vars.ui.showConfirm("@warning", "@mod.jarwarn", () -> {
                Vars.ui.loadfrag.show();
                this.githubImportJavaMod(repo);
            });
        } else {
            Vars.ui.loadfrag.show();
            Core.net.httpGet("https://api.github.com/repos/" + repo, res -> {
                if (this.checkError((Net.HttpResponse)res)) {
                    Jval json = Jval.read(res.getResultAsString());
                    String mainBranch = json.getString("default_branch");
                    String language = json.getString("language", "<none>");
                    if (language.equals("Java") || language.equals("Kotlin")) {
                        this.githubImportJavaMod(repo);
                    } else {
                        this.githubImportBranch(mainBranch, repo, this::showStatus);
                    }
                }
            }, this::importFail);
        }
    }

    private void githubImportJavaMod(String repo) {
        Core.net.httpGet("https://api.github.com/repos/" + repo + "/releases/latest", res -> {
            if (this.checkError((Net.HttpResponse)res)) {
                Jval asset;
                Jval json = Jval.read(res.getResultAsString());
                Jval.JsonArray assets = json.get("assets").asArray();
                Jval dexedAsset = assets.find((T j) -> j.getString("name").startsWith("dexed") && j.getString("name").endsWith(".jar"));
                Jval jval = asset = dexedAsset == null ? assets.find((T j) -> j.getString("name").endsWith(".jar")) : dexedAsset;
                if (asset != null) {
                    String url = asset.getString("browser_download_url");
                    Core.net.httpGet(url, result -> {
                        if (this.checkError((Net.HttpResponse)result)) {
                            this.handleMod(repo, (Net.HttpResponse)result);
                        }
                    }, this::importFail);
                } else {
                    throw new ArcRuntimeException("No JAR file found in releases. Make sure you have a valid jar file in the mod's latest Github Release.");
                }
            }
        }, this::importFail);
    }

    private boolean checkError(Net.HttpResponse res) {
        if (res.getStatus() == Net.HttpStatus.OK) {
            return true;
        }
        this.showStatus(res.getStatus());
        return false;
    }

    private void showStatus(Net.HttpStatus status) {
        Core.app.post(() -> {
            Vars.ui.showErrorMessage(Core.bundle.format("connectfail", Strings.capitalize(status.toString().toLowerCase())));
            Vars.ui.loadfrag.hide();
        });
    }

    private void githubImportBranch(String branch, String repo, Cons<Net.HttpStatus> err) {
        Core.net.httpGet("https://api.github.com/repos/" + repo + "/zipball/" + branch, loc -> {
            if (loc.getStatus() == Net.HttpStatus.OK) {
                if (loc.getHeader("Location") != null) {
                    Core.net.httpGet(loc.getHeader("Location"), result -> {
                        if (result.getStatus() != Net.HttpStatus.OK) {
                            err.get(result.getStatus());
                        } else {
                            this.handleMod(repo, (Net.HttpResponse)result);
                        }
                    }, this::importFail);
                } else {
                    this.handleMod(repo, (Net.HttpResponse)loc);
                }
            } else {
                err.get(loc.getStatus());
            }
        }, this::importFail);
    }
}

