/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.KeyBinds;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.scene.Element;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.TechTree;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Objectives;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.input.Binding;
import mindustry.io.legacy.LegacyIO;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LaunchLoadoutDialog;
import mindustry.world.Block;
import mindustry.world.blocks.storage.CoreBlock;

public class PlanetDialog
extends BaseDialog
implements PlanetRenderer.PlanetInterfaceRenderer {
    public static boolean debugSelect = false;
    public static float sectorShowDuration = 144.0f;
    public final FrameBuffer buffer = new FrameBuffer(2, 2, true);
    public final PlanetRenderer planets;
    public final LaunchLoadoutDialog loadouts;
    public float zoom;
    public float selectAlpha;
    @Nullable
    public Sector selected;
    @Nullable
    public Sector hovered;
    @Nullable
    public Sector launchSector;
    public Mode mode;
    public boolean launching;
    public Cons<Sector> listener;
    public Seq<Sector> newPresets;
    public float presetShow;
    public boolean showed;
    public Table sectorTop;
    public Label hoverLabel;

    public PlanetDialog() {
        super("", Styles.fullDialog);
        this.planets = Vars.renderer.planets;
        this.loadouts = new LaunchLoadoutDialog();
        this.zoom = 1.0f;
        this.selectAlpha = 1.0f;
        this.mode = Mode.look;
        this.listener = s -> {};
        this.newPresets = new Seq();
        this.presetShow = 0.0f;
        this.showed = false;
        this.sectorTop = new Table();
        this.hoverLabel = new Label("");
        this.shouldPause = true;
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back || key == Core.keybinds.get((KeyBinds.KeyBind)Binding.planet_map).key) {
                if (this.showing() && this.newPresets.size > 1) {
                    this.newPresets.truncate(1);
                } else if (this.selected != null) {
                    this.selected = null;
                    this.updateSelected();
                } else {
                    Core.app.post(this::hide);
                }
            }
        });
        this.hoverLabel.setStyle(Styles.outlineLabel);
        this.hoverLabel.setAlignment(1);
        this.rebuildButtons();
        this.onResize(this::rebuildButtons);
        this.dragged((cx, cy) -> {
            if (Core.input.getTouches() > 1) {
                return;
            }
            if (this.showing()) {
                this.newPresets.clear();
            }
            Vec3 pos = this.planets.camPos;
            float upV = pos.angle(Vec3.Y);
            float xscale = 9.0f;
            float yscale = 10.0f;
            float margin = 1.0f;
            float speed = 1.0f - Math.abs(upV - 90.0f) / 90.0f;
            pos.rotate(this.planets.cam.up, cx / xscale * speed);
            float amount = cy / yscale;
            amount = Mathf.clamp(upV + amount, margin, 180.0f - margin) - upV;
            pos.rotate(Tmp.v31.set(this.planets.cam.up).rotate(this.planets.cam.direction, 90.0f), amount);
        });
        this.scrolled(value -> {
            this.zoom = Mathf.clamp(this.zoom + value / 10.0f, 0.5f, 2.0f);
        });
        this.addCaptureListener(new ElementGestureListener(){
            float lastZoom = -1.0f;

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (this.lastZoom < 0.0f) {
                    this.lastZoom = PlanetDialog.this.zoom;
                }
                PlanetDialog.this.zoom = Mathf.clamp(initialDistance / distance * this.lastZoom, 0.5f, 2.0f);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                this.lastZoom = PlanetDialog.this.zoom;
            }
        });
        this.shown(this::setup);
    }

    @Override
    public Dialog show() {
        if (Vars.net.client()) {
            Vars.ui.showInfo("@map.multiplayer");
            return this;
        }
        if (Core.settings.has("unlocks") && !Core.settings.has("junction-unlocked")) {
            Core.app.post(() -> Vars.ui.showCustomConfirm("@research", "@research.legacy", "@research.load", "@research.discard", () -> {
                LegacyIO.readResearch();
                Core.settings.remove("unlocks");
            }, () -> Core.settings.remove("unlocks")));
        }
        this.rebuildButtons();
        this.mode = Mode.look;
        this.launchSector = null;
        this.hovered = null;
        this.selected = null;
        this.launching = false;
        this.zoom = 1.0f;
        this.planets.zoom = 1.0f;
        this.selectAlpha = 0.0f;
        this.launchSector = Vars.state.getSector();
        this.presetShow = 0.0f;
        this.showed = false;
        this.newPresets.clear();
        for (SectorPreset preset : Vars.content.sectors()) {
            if (!preset.unlocked() || preset.alwaysUnlocked || preset.sector.info.shown || preset.sector.hasBase()) continue;
            this.newPresets.add(preset.sector);
            preset.sector.info.shown = true;
            preset.sector.saveInfo();
        }
        if (this.newPresets.any()) {
            this.newPresets.add(this.planets.planet.getLastSector());
        }
        this.newPresets.reverse();
        this.updateSelected();
        if (this.planets.planet.getLastSector() != null) {
            this.lookAt(this.planets.planet.getLastSector());
        }
        return super.show();
    }

    void rebuildButtons() {
        this.buttons.clearChildren();
        this.buttons.bottom();
        if (Core.graphics.isPortrait()) {
            this.buttons.add(this.sectorTop).colspan(2).fillX().row();
            this.addBack();
            this.addTech();
        } else {
            this.addBack();
            this.buttons.add().growX();
            this.buttons.add(this.sectorTop).minWidth(230.0f);
            this.buttons.add().growX();
            this.addTech();
        }
    }

    void addBack() {
        this.buttons.button("@back", Icon.left, this::hide).size(200.0f, 54.0f).pad(2.0f).bottom();
    }

    void addTech() {
        this.buttons.button("@techtree", Icon.tree, () -> Vars.ui.research.show()).size(200.0f, 54.0f).pad(2.0f).bottom();
    }

    public void showOverview() {
        BaseDialog dialog = new BaseDialog("@overview");
        dialog.addCloseButton();
        dialog.add("@sectors.captured");
    }

    public void showSelect(Sector sector, Cons<Sector> listener) {
        this.selected = null;
        this.hovered = null;
        this.launching = false;
        this.listener = listener;
        this.lookAt(sector);
        this.zoom = 1.0f;
        this.planets.zoom = 1.0f;
        this.selectAlpha = 0.0f;
        this.launchSector = sector;
        this.mode = Mode.select;
        super.show();
    }

    void lookAt(Sector sector) {
        this.planets.camPos.set(Tmp.v33.set(sector.tile.v).rotate(Vec3.Y, -sector.planet.getRotation()));
    }

    boolean canSelect(Sector sector) {
        if (this.mode == Mode.select) {
            return sector.hasBase();
        }
        if (sector.hasBase()) {
            return true;
        }
        if (sector.preset != null) {
            TechTree.TechNode node = sector.preset.node();
            return node == null || node.parent == null || node.parent.content.unlocked();
        }
        return sector.hasBase() || sector.near().contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase)));
    }

    Sector findLauncher(Sector to) {
        Sector launchSector;
        Sector sector = launchSector = this.launchSector != null && this.launchSector.hasBase() ? this.launchSector : null;
        if (to.near().contains(launchSector)) {
            return launchSector;
        }
        Sector launchFrom = launchSector;
        if ((launchFrom == null || to.preset == null && !to.near().contains(launchSector)) && (launchFrom = to.near().find(Sector::hasBase)) == null && to.preset != null) {
            if (launchSector != null) {
                return launchSector;
            }
            launchFrom = this.planets.planet.sectors.min(s -> !s.hasBase() ? Float.MAX_VALUE : s.tile.v.dst2(to.tile.v));
            if (!launchFrom.hasBase()) {
                launchFrom = null;
            }
        }
        return launchFrom;
    }

    boolean showing() {
        return this.newPresets.any();
    }

    @Override
    public void renderSectors(Planet planet) {
        Sector launchFrom;
        Sector current;
        if (this.selectAlpha > 0.01f) {
            for (Sector sec : planet.sectors) {
                if (this.canSelect(sec) || sec.unlocked() || debugSelect) {
                    Color color = sec.hasBase() ? Tmp.c2.set(Team.sharded.color).lerp(Team.crux.color, sec.hasEnemyBase() ? 0.5f : 0.0f) : (sec.preset != null ? (sec.preset.unlocked() ? Tmp.c2.set(Team.derelict.color).lerp(Color.white, Mathf.absin(Time.time, 10.0f, 1.0f)) : Color.gray) : (sec.hasEnemyBase() ? Team.crux.color : null));
                    if (color == null) continue;
                    this.planets.drawSelection(sec, Tmp.c1.set(color).mul(0.8f).a(this.selectAlpha), 0.026f, -0.001f);
                    continue;
                }
                this.planets.fill(sec, Tmp.c1.set(PlanetRenderer.shadowColor).mul(1.0f, 1.0f, 1.0f, this.selectAlpha), -0.001f);
            }
        }
        Sector sector = current = Vars.state.getSector() != null && Vars.state.getSector().isBeingPlayed() && Vars.state.getSector().planet == this.planets.planet ? Vars.state.getSector() : null;
        if (current != null) {
            this.planets.fill(current, PlanetRenderer.hoverColor, -0.001f);
        }
        if (this.hovered != null) {
            this.planets.fill(this.hovered, PlanetRenderer.hoverColor, -0.001f);
            this.planets.drawBorders(this.hovered, PlanetRenderer.borderColor);
        }
        if (this.selected != null) {
            this.planets.drawSelection(this.selected);
            this.planets.drawBorders(this.selected, PlanetRenderer.borderColor);
        }
        this.planets.batch.flush(4);
        if (this.hovered != null && !this.hovered.hasBase() && (launchFrom = this.findLauncher(this.hovered)) != null && this.hovered != launchFrom && this.canSelect(this.hovered)) {
            this.planets.drawArc(planet, launchFrom.tile.v, this.hovered.tile.v);
        }
        if (this.selectAlpha > 0.001f) {
            for (Sector sec : planet.sectors) {
                if (!sec.hasBase()) continue;
                for (Sector enemy : sec.near()) {
                    if (!enemy.hasEnemyBase()) continue;
                    this.planets.drawArc(planet, enemy.tile.v, sec.tile.v, Team.crux.color.write(Tmp.c2).a(this.selectAlpha), Color.clear, 0.24f, 110.0f, 25);
                }
            }
        }
    }

    @Override
    public void renderProjections(Planet planet) {
        float iw = 12.0f;
        for (Sector sec : planet.sectors) {
            Color color;
            if (sec == this.hovered) continue;
            TextureRegion preficon = sec.icon();
            TextureRegion icon = sec.isAttacked() ? Fonts.getLargeIcon("warning") : (!sec.hasBase() && sec.preset != null && sec.preset.unlocked() && preficon == null ? Fonts.getLargeIcon("terrain") : (sec.preset != null && sec.preset.locked() && sec.preset.node() != null && !sec.preset.node().parent.content.locked() ? Fonts.getLargeIcon("lock") : preficon));
            Color color2 = color = sec.preset != null && !sec.hasBase() ? Team.derelict.color : Team.sharded.color;
            if (icon == null) continue;
            this.planets.drawPlane(sec, () -> {
                Draw.color(color, this.selectAlpha);
                Draw.rect(icon, 0.0f, 0.0f, iw, iw * (float)icon.height / (float)icon.width);
            });
        }
        Draw.reset();
        if (this.hovered != null) {
            this.planets.drawPlane(this.hovered, () -> {
                TextureRegion icon;
                Draw.color(this.hovered.isAttacked() ? Pal.remove : Color.white, Pal.accent, Mathf.absin(5.0f, 1.0f));
                TextureRegion textureRegion = this.hovered.locked() && !this.canSelect(this.hovered) ? Fonts.getLargeIcon("lock") : (icon = this.hovered.isAttacked() ? Fonts.getLargeIcon("warning") : this.hovered.icon());
                if (icon != null) {
                    Draw.rect(icon, 0.0f, 0.0f, iw, iw * (float)icon.height / (float)icon.width);
                }
                Draw.reset();
            });
        }
        Draw.reset();
    }

    void setup() {
        this.planets.zoom = 1.0f;
        this.zoom = 1.0f;
        this.selectAlpha = 1.0f;
        Vars.ui.minimapfrag.hide();
        this.clearChildren();
        this.margin(0.0f);
        this.stack(new Element(){
            {
                this.addListener(new ElementGestureListener(){

                    @Override
                    public void tap(InputEvent event, float x, float y, int count, KeyCode button) {
                        if (PlanetDialog.this.showing()) {
                            return;
                        }
                        if (PlanetDialog.this.hovered != null && PlanetDialog.this.selected == PlanetDialog.this.hovered && count == 2) {
                            PlanetDialog.this.playSelected();
                        }
                        if (PlanetDialog.this.hovered != null && (PlanetDialog.this.canSelect(PlanetDialog.this.hovered) || debugSelect)) {
                            PlanetDialog.this.selected = PlanetDialog.this.hovered;
                        }
                        if (PlanetDialog.this.selected != null) {
                            PlanetDialog.this.updateSelected();
                        }
                    }
                });
            }

            @Override
            public void draw() {
                PlanetDialog.this.planets.orbitAlpha = PlanetDialog.this.selectAlpha;
                PlanetDialog.this.planets.render(PlanetDialog.this);
                if (Core.scene.getDialog() == PlanetDialog.this) {
                    Core.scene.setScrollFocus(PlanetDialog.this);
                }
            }
        }, new Table(t -> {
            t.touchable = Touchable.disabled;
            t.top();
            t.label(() -> this.mode == Mode.select ? "@sectors.select" : "").style(Styles.outlineLabel).color(Pal.accent);
        }), this.buttons, new Table(t -> {
            t.right();
            if (Vars.content.planets().count(p -> p.accessible) > 1) {
                t.table(Styles.black6, pt -> {
                    pt.add("@planets").color(Pal.accent);
                    pt.row();
                    pt.image().growX().height(4.0f).pad(6.0f).color(Pal.accent);
                    pt.row();
                    for (int i = 0; i < Vars.content.planets().size; ++i) {
                        Planet planet = Vars.content.planets().get(i);
                        if (!planet.accessible) continue;
                        pt.button(planet.localizedName, Styles.clearTogglet, () -> {
                            this.selected = null;
                            this.launchSector = null;
                            Vars.renderer.planets.planet = planet;
                        }).width(200.0f).height(40.0f).growX().update((T bb) -> bb.setChecked(Vars.renderer.planets.planet == planet));
                        pt.row();
                    }
                });
            }
        }), new Table(t -> t.top())).grow();
    }

    @Override
    public void draw() {
        boolean doBuffer;
        boolean bl = doBuffer = this.color.a < 0.99f;
        if (doBuffer) {
            this.buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            this.buffer.begin(Color.clear);
        }
        super.draw();
        if (doBuffer) {
            this.buffer.end();
            Draw.color(this.color);
            Draw.rect(Draw.wrap((Texture)this.buffer.getTexture()), this.width / 2.0f, this.height / 2.0f, this.width, -this.height);
            Draw.color();
        }
    }

    public void lookAt(Sector sector, float alpha) {
        float len = this.planets.camPos.len();
        this.planets.camPos.slerp(Tmp.v31.set(sector.tile.v).rotate(Vec3.Y, -sector.planet.getRotation()).setLength(len), alpha);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.hovered != null && !Vars.mobile) {
            this.addChild(this.hoverLabel);
            this.hoverLabel.toFront();
            this.hoverLabel.touchable = Touchable.disabled;
            Vec3 pos = this.planets.cam.project(Tmp.v31.set(this.hovered.tile.v).setLength(1.17f).rotate(Vec3.Y, -this.planets.planet.getRotation()).add(this.planets.planet.position));
            this.hoverLabel.setPosition(pos.x - Core.scene.marginLeft, pos.y - Core.scene.marginBottom, 1);
            this.hoverLabel.getText().setLength(0);
            if (this.hovered != null) {
                StringBuilder tx = this.hoverLabel.getText();
                if (!this.canSelect(this.hovered)) {
                    tx.append("[gray]").append('\ue88d').append(" ").append(Core.bundle.get("locked"));
                } else {
                    tx.append("[accent][[ [white]").append(this.hovered.name()).append("[accent] ]");
                }
            }
            this.hoverLabel.invalidateHierarchy();
        } else {
            this.hoverLabel.remove();
        }
        if (this.launching && this.selected != null) {
            this.lookAt(this.selected, 0.1f);
        }
        if (this.showing()) {
            Sector to = this.newPresets.peek();
            this.presetShow += Time.delta;
            this.lookAt(to, 0.11f);
            this.zoom = 0.75f;
            if (this.presetShow >= 20.0f && !this.showed && this.newPresets.size > 1) {
                this.showed = true;
                Vars.ui.announce("\ue876 [accent]" + to.name(), 2.0f);
            }
            if (this.presetShow > sectorShowDuration) {
                this.newPresets.pop();
                this.showed = false;
                this.presetShow = 0.0f;
            }
        }
        if (this.planets.planet.isLandable()) {
            this.hovered = this.planets.planet.getSector(this.planets.cam.getMouseRay(), 1.17f);
        } else {
            this.selected = null;
            this.hovered = null;
        }
        this.planets.zoom = Mathf.lerpDelta(this.planets.zoom, this.zoom, 0.4f);
        this.selectAlpha = Mathf.lerpDelta(this.selectAlpha, Mathf.num(this.planets.zoom < 1.9f), 0.1f);
    }

    void showStats(Sector sector) {
        BaseDialog dialog = new BaseDialog(sector.name());
        dialog.cont.pane((Table c) -> {
            Cons2<ObjectMap, String> display = (stats, name) -> {
                Table t = new Table().left();
                float scl = sector.getProductionScale();
                int[] i = new int[]{0};
                stats.each((item, stat) -> {
                    int total = (int)(stat.mean * 60.0f * scl);
                    if (total > 1) {
                        t.image(item.icon(Cicon.small)).padRight(3.0f);
                        t.add(UI.formatAmount(total) + " " + Core.bundle.get("unit.perminute")).color(Color.lightGray).padRight(3.0f);
                        i[0] = i[0] + 1;
                        if (i[0] % 3 == 0) {
                            t.row();
                        }
                    }
                });
                if (t.getChildren().any()) {
                    c.add((CharSequence)name).left().row();
                    c.add(t).padLeft(10.0f).left().row();
                }
            };
            c.defaults().padBottom(5.0f);
            c.add(Core.bundle.get("sectors.time") + " [accent]" + sector.save.getPlayTime()).left().row();
            if (sector.info.waves && sector.hasBase()) {
                c.add(Core.bundle.get("sectors.wave") + " [accent]" + (sector.info.wave + sector.info.wavesPassed)).left().row();
            }
            if (sector.isAttacked() || !sector.hasBase()) {
                c.add(Core.bundle.get("sectors.threat") + " [accent]" + sector.displayThreat()).left().row();
            }
            if (sector.save != null && sector.info.resources.any()) {
                c.add("@sectors.resources").left().row();
                c.table((Table t) -> {
                    for (UnlockableContent uc : sector.info.resources) {
                        t.image(uc.icon(Cicon.small)).padRight(3.0f).size(Cicon.small.size);
                    }
                }).padLeft(10.0f).left().row();
            }
            display.get(sector.info.production, "@sectors.production");
            display.get(sector.info.export, "@sectors.export");
            ItemSeq items = sector.items();
            if (sector.hasBase() && items.total > 0) {
                c.add("@sectors.stored").left().row();
                c.table((Table t) -> {
                    t.left();
                    t.table((Table res) -> {
                        int i = 0;
                        for (ItemStack stack : items) {
                            res.image(stack.item.icon(Cicon.small)).padRight(3.0f);
                            res.add(UI.formatAmount(Math.max(stack.amount, 0))).color(Color.lightGray);
                            if (++i % 4 != 0) continue;
                            res.row();
                        }
                    }).padLeft(10.0f);
                }).left().row();
            }
        });
        dialog.addCloseButton();
        dialog.show();
    }

    void updateSelected() {
        boolean locked;
        final Sector sector = this.selected;
        Table stable = this.sectorTop;
        if (sector == null) {
            stable.clear();
            return;
        }
        float x = stable.getX(1);
        float y = stable.getY(1);
        stable.clear();
        stable.background(Styles.black6);
        stable.table((Table title) -> {
            TextureRegionDrawable icon;
            title.add("[accent]" + sector.name()).padLeft(3.0f);
            if (sector.preset == null) {
                title.add().growX();
                title.button((Drawable)Icon.pencilSmall, Styles.clearPartiali, () -> Vars.ui.showTextInput("@sectors.rename", "@name", 20, sector.name(), v -> {
                    sector.setName((String)v);
                    this.updateSelected();
                })).size(40.0f).padLeft(4.0f);
            }
            title.button((Drawable)((icon = Icon.icons.get(sector.info.icon + "Small")) == null ? Icon.noneSmall : icon), Styles.clearPartiali, () -> new Dialog(""){
                {
                    super(title);
                    this.closeOnBack();
                    this.setFillParent(true);
                    this.cont.pane((Table t) -> {
                        t.marginRight(19.0f);
                        t.defaults().size(48.0f);
                        t.button((Drawable)Icon.none, Styles.clearTogglei, () -> {
                            sector2.info.icon = null;
                            sector.saveInfo();
                            this.hide();
                            PlanetDialog.this.updateSelected();
                        }).checked(sector2.info.icon == null);
                        int i = 1;
                        for (ObjectMap.Entry entry : Icon.icons.entries()) {
                            if (((String)entry.key).endsWith("Small") || ((String)entry.key).contains("none")) continue;
                            String key = (String)entry.key;
                            t.button((Drawable)entry.value, Styles.cleari, () -> {
                                sector2.info.icon = key;
                                sector.saveInfo();
                                this.hide();
                                PlanetDialog.this.updateSelected();
                            }).checked(((String)entry.key).equals(sector2.info.icon));
                            if (++i % 8 != 0) continue;
                            t.row();
                        }
                    });
                    this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
                }
            }.show()).size(40.0f);
        }).row();
        stable.image().color(Pal.accent).fillX().height(3.0f).pad(3.0f).row();
        boolean bl = locked = sector.preset != null && sector.preset.locked() && !sector.hasBase() && sector.preset.node() != null;
        if (locked) {
            stable.table((Table r) -> {
                r.add("@complete").colspan(2).left();
                r.row();
                for (Objectives.Objective o : sector.preset.node().objectives) {
                    if (o.complete()) continue;
                    r.add("> " + o.display()).color(Color.lightGray).left();
                    r.image(o.complete() ? Icon.ok : Icon.cancel, o.complete() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                    r.row();
                }
            }).row();
        } else if (!sector.hasBase()) {
            stable.add(Core.bundle.get("sectors.threat") + " [accent]" + sector.displayThreat()).row();
        }
        if (sector.isAttacked()) {
            stable.add(Core.bundle.format("sectors.underattack", (int)(sector.info.damage * 100.0f)));
            stable.row();
            if (sector.info.wavesSurvived >= 0 && sector.info.wavesSurvived - sector.info.wavesPassed >= 0 && !sector.isBeingPlayed()) {
                int toCapture = sector.info.attack || sector.info.winWave <= 1 ? -1 : sector.info.winWave - (sector.info.wave + sector.info.wavesPassed);
                boolean plus = sector.info.wavesSurvived - sector.info.wavesPassed >= 39;
                stable.add(Core.bundle.format("sectors.survives", Math.min(sector.info.wavesSurvived - sector.info.wavesPassed, toCapture <= 0 ? 200 : toCapture) + (plus ? "+" : "") + (toCapture < 0 ? "" : "/" + toCapture)));
                stable.row();
            }
        } else if (sector.hasBase() && sector.near().contains((Sector)((Object)((Boolf<Sector>)Sector::hasEnemyBase)))) {
            stable.add("@sectors.vulnerable");
            stable.row();
        } else if (!sector.hasBase() && sector.hasEnemyBase()) {
            stable.add("@sectors.enemybase");
            stable.row();
        }
        if (sector.save != null && sector.info.resources.any()) {
            stable.table((Table t) -> {
                t.add("@sectors.resources").padRight(4.0f);
                for (UnlockableContent c : sector.info.resources) {
                    if (c == null) continue;
                    t.image(c.icon(Cicon.small)).padRight(3.0f).size(Cicon.small.size);
                }
            }).padLeft(10.0f).fillX().row();
        }
        stable.row();
        if (sector.hasBase()) {
            stable.button("@stats", (Drawable)Icon.info, Styles.transt, () -> this.showStats(sector)).height(40.0f).fillX().row();
        }
        if (sector.hasBase() && this.mode == Mode.look || this.canSelect(sector) || sector.preset != null && sector.preset.alwaysUnlocked || debugSelect) {
            stable.button(this.mode == Mode.select ? "@sectors.select" : (sector.isBeingPlayed() ? "@sectors.resume" : (sector.hasBase() ? "@sectors.go" : (locked ? "@locked" : "@sectors.launch"))), locked ? Icon.lock : Icon.play, this::playSelected).growX().height(54.0f).minWidth(170.0f).padTop(4.0f).disabled(locked);
        }
        stable.pack();
        stable.setPosition(x, y, 1);
        stable.update(() -> {
            if (this.selected != null) {
                if (this.launching) {
                    stable.color.sub(0.0f, 0.0f, 0.0f, 0.05f * Time.delta);
                } else {
                    Tmp.v31.set(this.selected.tile.v).rotate(Vec3.Y, -this.planets.planet.getRotation()).scl(-1.0f).nor();
                    float dot = this.planets.cam.direction.dot(Tmp.v31);
                    stable.color.a = Math.max(dot, 0.0f) * 2.0f;
                    if (dot * 2.0f <= -0.1f) {
                        this.selected = null;
                        this.updateSelected();
                    }
                }
            }
        });
        stable.act(0.0f);
    }

    void playSelected() {
        if (this.selected == null) {
            return;
        }
        Sector sector = this.selected;
        if (sector.isBeingPlayed()) {
            this.hide();
            return;
        }
        if (sector.preset != null && sector.preset.locked() && !sector.hasBase()) {
            return;
        }
        boolean shouldHide = true;
        if (Vars.control.saves.getCurrent() != null && Vars.state.isGame() && this.mode != Mode.select) {
            try {
                Vars.control.saves.getCurrent().save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
        }
        if (this.mode == Mode.look && !sector.hasBase()) {
            shouldHide = false;
            Sector from = this.findLauncher(sector);
            if (from == null) {
                Vars.universe.clearLoadoutInfo();
                Vars.control.playSector(sector);
            } else {
                CoreBlock b;
                Block block = from.info.bestCoreType;
                CoreBlock block2 = block instanceof CoreBlock && (b = (CoreBlock)block) == (CoreBlock)block ? b : (CoreBlock)Blocks.coreShard;
                this.loadouts.show(block2, from, () -> {
                    from.removeItems(Vars.universe.getLastLoadout().requirements());
                    from.removeItems(Vars.universe.getLaunchResources());
                    this.launching = true;
                    this.zoom = 0.5f;
                    Vars.ui.hudfrag.showLaunchDirect();
                    Time.runTask(140.0f, () -> Vars.control.playSector(from, sector));
                });
            }
        } else if (this.mode == Mode.select) {
            this.listener.get(sector);
        } else {
            Vars.control.playSector(sector);
        }
        if (shouldHide) {
            this.hide();
        }
    }

    public static enum Mode {
        look,
        select;

    }
}

