/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.KeyBinds;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.actions.RelativeTemporalAction;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Structs;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.UI;
import mindustry.game.EventType;
import mindustry.game.Objectives;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Cicon;
import mindustry.ui.ItemsDisplay;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.layout.BranchTreeLayout;
import mindustry.ui.layout.TreeLayout;

public class ResearchDialog
extends BaseDialog {
    public final float nodeSize = Scl.scl(60.0f);
    public ObjectSet<TechTreeNode> nodes = new ObjectSet();
    public TechTreeNode root = new TechTreeNode(TechTree.root, null);
    public Rect bounds = new Rect();
    public ItemsDisplay itemDisplay;
    public View view;
    public ItemSeq items;

    public ResearchDialog() {
        super("");
        this.titleTable.remove();
        this.margin(0.0f).marginBottom(8.0f);
        Element[] elementArray = new Element[2];
        this.view = new View();
        elementArray[0] = this.view;
        this.itemDisplay = new ItemsDisplay();
        elementArray[1] = this.itemDisplay;
        this.cont.stack(elementArray).grow();
        this.shouldPause = true;
        this.shown(() -> {
            this.items = new ItemSeq(){
                ObjectMap<Sector, ItemSeq> cache = new ObjectMap();
                {
                    for (Planet planet : Vars.content.planets()) {
                        for (Sector sector : planet.sectors) {
                            if (!sector.hasSave() || !sector.hasBase()) continue;
                            ItemSeq cached = sector.items();
                            this.cache.put(sector, cached);
                            cached.each((item, amount) -> {
                                short s = item.id;
                                this.values[s] = this.values[s] + Math.max(amount, 0);
                                this.total += Math.max(amount, 0);
                            });
                        }
                    }
                }

                @Override
                public void add(Item item, int amount) {
                    if (amount < 0) {
                        amount = -amount;
                        double percentage = (double)amount / (double)this.get(item);
                        int[] counter = new int[]{amount};
                        this.cache.each((K sector, V seq) -> {
                            if (counter[0] == 0) {
                                return;
                            }
                            int toRemove = Math.min((int)Math.ceil(percentage * (double)seq.get(item)), counter[0]);
                            sector.removeItem(item, toRemove);
                            seq.remove(item, toRemove);
                            counter[0] = counter[0] - toRemove;
                        });
                        amount = -amount;
                    }
                    super.add(item, amount);
                }
            };
            this.checkNodes(this.root);
            this.treeLayout();
        });
        this.hidden(Vars.ui.planet::setup);
        this.addCloseButton();
        this.keyDown(key -> {
            if (key == Core.keybinds.get((KeyBinds.KeyBind)Binding.research).key) {
                Core.app.post(this::hide);
            }
        });
        this.buttons.button("@database", Icon.book, () -> {
            this.hide();
            Vars.ui.database.show();
        }).size(210.0f, 64.0f).name("database");
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                ResearchDialog.this.view.setScale(Mathf.clamp(ResearchDialog.this.view.scaleX - amountY / 10.0f * ResearchDialog.this.view.scaleX, 0.25f, 1.0f));
                ResearchDialog.this.view.setOrigin(1);
                ResearchDialog.this.view.setTransform(true);
                return true;
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                ResearchDialog.this.view.requestScroll();
                return super.mouseMoved(event, x, y);
            }
        });
        this.touchable = Touchable.enabled;
        this.addCaptureListener(new ElementGestureListener(){

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (ResearchDialog.this.view.lastZoom < 0.0f) {
                    ResearchDialog.this.view.lastZoom = ResearchDialog.this.view.scaleX;
                }
                ResearchDialog.this.view.setScale(Mathf.clamp(distance / initialDistance * ResearchDialog.this.view.lastZoom, 0.25f, 1.0f));
                ResearchDialog.this.view.setOrigin(1);
                ResearchDialog.this.view.setTransform(true);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                ResearchDialog.this.view.lastZoom = ResearchDialog.this.view.scaleX;
            }

            @Override
            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                ResearchDialog.this.view.panX += deltaX / ResearchDialog.this.view.scaleX;
                ResearchDialog.this.view.panY += deltaY / ResearchDialog.this.view.scaleY;
                ResearchDialog.this.view.moved = true;
                ResearchDialog.this.view.clamp();
            }
        });
    }

    void treeLayout() {
        final float spacing = 20.0f;
        LayoutNode node = new LayoutNode(this.root, null);
        LayoutNode[] children = (LayoutNode[])node.children;
        LayoutNode[] leftHalf = Arrays.copyOfRange((LayoutNode[])node.children, 0, Mathf.ceil((float)((LayoutNode[])node.children).length / 2.0f));
        LayoutNode[] rightHalf = Arrays.copyOfRange((LayoutNode[])node.children, Mathf.ceil((float)((LayoutNode[])node.children).length / 2.0f), ((LayoutNode[])node.children).length);
        node.children = leftHalf;
        new BranchTreeLayout(){
            {
                this.gapBetweenLevels = this.gapBetweenNodes = spacing;
                this.rootLocation = BranchTreeLayout.TreeLocation.top;
            }
        }.layout(node);
        float lastY = node.y;
        if (rightHalf.length > 0) {
            node.children = rightHalf;
            new BranchTreeLayout(){
                {
                    this.gapBetweenLevels = this.gapBetweenNodes = spacing;
                    this.rootLocation = BranchTreeLayout.TreeLocation.bottom;
                }
            }.layout(node);
            this.shift(leftHalf, node.y - lastY);
        }
        node.children = children;
        float minx = 0.0f;
        float miny = 0.0f;
        float maxx = 0.0f;
        float maxy = 0.0f;
        this.copyInfo(node);
        for (TechTreeNode n : this.nodes) {
            if (!n.visible) continue;
            minx = Math.min(n.x - n.width / 2.0f, minx);
            maxx = Math.max(n.x + n.width / 2.0f, maxx);
            miny = Math.min(n.y - n.height / 2.0f, miny);
            maxy = Math.max(n.y + n.height / 2.0f, maxy);
        }
        this.bounds = new Rect(minx, miny, maxx - minx, maxy - miny);
        this.bounds.y += this.nodeSize * 1.5f;
    }

    void shift(LayoutNode[] children, float amount) {
        for (LayoutNode node : children) {
            node.y += amount;
            if (node.children == null || ((LayoutNode[])node.children).length <= 0) continue;
            this.shift((LayoutNode[])node.children, amount);
        }
    }

    void copyInfo(LayoutNode node) {
        node.node.x = node.x;
        node.node.y = node.y;
        if (node.children != null) {
            for (LayoutNode child : (LayoutNode[])node.children) {
                this.copyInfo(child);
            }
        }
    }

    void checkNodes(TechTreeNode node) {
        boolean locked = this.locked(node.node);
        if (!locked) {
            node.visible = true;
        }
        node.selectable = this.selectable(node.node);
        for (TechTreeNode l : (TechTreeNode[])node.children) {
            l.visible = !locked;
            this.checkNodes(l);
        }
        this.itemDisplay.rebuild(this.items);
    }

    boolean selectable(TechTree.TechNode node) {
        return node.content.unlocked() || !node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)i -> !i.complete())));
    }

    boolean locked(TechTree.TechNode node) {
        return node.content.locked();
    }

    public class TechTreeNode
    extends TreeLayout.TreeNode<TechTreeNode> {
        public final TechTree.TechNode node;
        public boolean visible = true;
        public boolean selectable = true;

        public TechTreeNode(TechTree.TechNode node, TechTreeNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = ResearchDialog.this.nodeSize;
            ResearchDialog.this.nodes.add(this);
            if (node.children != null) {
                this.children = new TechTreeNode[node.children.size];
                for (int i = 0; i < ((TechTreeNode[])this.children).length; ++i) {
                    ((TechTreeNode[])this.children)[i] = new TechTreeNode(node.children.get(i), this);
                }
            }
        }
    }

    public class View
    extends Group {
        public float panX = 0.0f;
        public float panY = -200.0f;
        public float lastZoom = -1.0f;
        public boolean moved = false;
        public ImageButton hoverNode;
        public Table infoTable = new Table();

        public View() {
            this.infoTable.touchable = Touchable.enabled;
            for (TechTreeNode node : ResearchDialog.this.nodes) {
                ImageButton button = new ImageButton(node.node.content.icon(Cicon.medium), Styles.nodei);
                button.visible(() -> node.visible);
                button.clicked(() -> {
                    if (this.moved) {
                        return;
                    }
                    if (Vars.mobile) {
                        this.hoverNode = button;
                        this.rebuild();
                        float right = this.infoTable.getRight();
                        if (right > (float)Core.graphics.getWidth()) {
                            final float moveBy = right - (float)Core.graphics.getWidth();
                            this.addAction(new RelativeTemporalAction(){
                                {
                                    this.setDuration(0.1f);
                                    this.setInterpolation(Interp.fade);
                                }

                                @Override
                                protected void updateRelative(float percentDelta) {
                                    View.this.panX -= moveBy * percentDelta;
                                }
                            });
                        }
                    } else if (this.canSpend(node.node) && ResearchDialog.this.locked(node.node)) {
                        this.spend(node.node);
                    }
                });
                button.hovered(() -> {
                    if (!Vars.mobile && this.hoverNode != button && node.visible) {
                        this.hoverNode = button;
                        this.rebuild();
                    }
                });
                button.exited(() -> {
                    if (!(Vars.mobile || this.hoverNode != button || this.infoTable.hasMouse() || this.hoverNode.hasMouse())) {
                        this.hoverNode = null;
                        this.rebuild();
                    }
                });
                button.touchable(() -> !node.visible ? Touchable.disabled : Touchable.enabled);
                button.userObject = node.node;
                button.setSize(ResearchDialog.this.nodeSize);
                button.update(() -> {
                    float offset = (float)(Core.graphics.getHeight() % 2) / 2.0f;
                    button.setPosition(node.x + this.panX + this.width / 2.0f, node.y + this.panY + this.height / 2.0f + offset, 1);
                    button.getStyle().up = !ResearchDialog.this.locked(node.node) ? Tex.buttonOver : (!ResearchDialog.this.selectable(node.node) || !this.canSpend(node.node) ? Tex.buttonRed : Tex.button);
                    ((TextureRegionDrawable)button.getStyle().imageUp).setRegion(node.selectable ? node.node.content.icon(Cicon.medium) : Icon.lock.getRegion());
                    button.getImage().setColor(!ResearchDialog.this.locked(node.node) ? Color.white : (node.selectable ? Color.gray : Pal.gray));
                    button.getImage().setScaling(Scaling.bounded);
                });
                this.addChild(button);
            }
            if (Vars.mobile) {
                this.tapped(() -> {
                    Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
                    if (e == this) {
                        this.hoverNode = null;
                        this.rebuild();
                    }
                });
            }
            this.setOrigin(1);
            this.setTransform(true);
            this.released(() -> {
                this.moved = false;
            });
        }

        void clamp() {
            float pad = ResearchDialog.this.nodeSize;
            float ox = this.width / 2.0f;
            float oy = this.height / 2.0f;
            float rx = ResearchDialog.this.bounds.x + this.panX + ox;
            float ry = this.panY + oy + ResearchDialog.this.bounds.y;
            float rw = ResearchDialog.this.bounds.width;
            float rh = ResearchDialog.this.bounds.height;
            rx = Mathf.clamp(rx, -rw + pad, (float)Core.graphics.getWidth() - pad);
            ry = Mathf.clamp(ry, -rh + pad, (float)Core.graphics.getHeight() - pad);
            this.panX = rx - ResearchDialog.this.bounds.x - ox;
            this.panY = ry - ResearchDialog.this.bounds.y - oy;
        }

        boolean canSpend(TechTree.TechNode node) {
            if (!ResearchDialog.this.selectable(node)) {
                return false;
            }
            if (node.requirements.length == 0) {
                return true;
            }
            for (int i = 0; i < node.requirements.length; ++i) {
                if (node.finishedRequirements[i].amount >= node.requirements[i].amount || !ResearchDialog.this.items.has(node.requirements[i].item)) continue;
                return true;
            }
            return node.content.locked();
        }

        void spend(TechTree.TechNode node) {
            boolean complete = true;
            boolean[] shine = new boolean[node.requirements.length];
            boolean[] usedShine = new boolean[Vars.content.items().size];
            for (int i = 0; i < node.requirements.length; ++i) {
                ItemStack req = node.requirements[i];
                ItemStack completed = node.finishedRequirements[i];
                int used = Math.max(Math.min(req.amount - completed.amount, ResearchDialog.this.items.get(req.item)), 0);
                ResearchDialog.this.items.remove(req.item, used);
                completed.amount += used;
                if (used > 0) {
                    shine[i] = true;
                    usedShine[req.item.id] = true;
                }
                if (completed.amount >= req.amount) continue;
                complete = false;
            }
            if (complete) {
                this.unlock(node);
            }
            node.save();
            Core.scene.act();
            this.rebuild(shine);
            ResearchDialog.this.itemDisplay.rebuild(ResearchDialog.this.items, usedShine);
        }

        void unlock(TechTree.TechNode node) {
            node.content.unlock();
            TechTree.TechNode parent = node.parent;
            while (parent != null) {
                parent.content.unlock();
                parent = parent.parent;
            }
            ResearchDialog.this.checkNodes(ResearchDialog.this.root);
            this.hoverNode = null;
            ResearchDialog.this.treeLayout();
            this.rebuild();
            Core.scene.act();
            Sounds.unlock.play();
            Events.fire(new EventType.ResearchEvent(node.content));
        }

        void rebuild() {
            this.rebuild(null);
        }

        void rebuild(@Nullable boolean[] shine) {
            ImageButton button = this.hoverNode;
            this.infoTable.remove();
            this.infoTable.clear();
            this.infoTable.update(null);
            if (button == null) {
                return;
            }
            TechTree.TechNode node = (TechTree.TechNode)button.userObject;
            this.infoTable.exited(() -> {
                if (this.hoverNode == button && !this.infoTable.hasMouse() && !this.hoverNode.hasMouse()) {
                    this.hoverNode = null;
                    this.rebuild();
                }
            });
            this.infoTable.update(() -> this.infoTable.setPosition(button.x + button.getWidth(), button.y + button.getHeight(), 10));
            this.infoTable.left();
            this.infoTable.background(Tex.button).margin(8.0f);
            boolean selectable = ResearchDialog.this.selectable(node);
            this.infoTable.table(b -> {
                b.margin(0.0f).left().defaults().left();
                if (selectable && (node.content.description != null || node.content.stats.toMap().size > 0)) {
                    b.button((Drawable)Icon.info, Styles.cleari, () -> Vars.ui.content.show(node.content)).growY().width(50.0f);
                }
                b.add().grow();
                b.table(desc -> {
                    desc.left().defaults().left();
                    desc.add(selectable ? node.content.localizedName : "[accent]???");
                    desc.row();
                    if (ResearchDialog.this.locked(node)) {
                        desc.table(t -> {
                            t.left();
                            if (selectable) {
                                if (Structs.contains(node.finishedRequirements, s -> s.amount > 0)) {
                                    float sum = 0.0f;
                                    float used = 0.0f;
                                    boolean shiny = false;
                                    for (int i = 0; i < node.requirements.length; ++i) {
                                        sum += node.requirements[i].item.cost * (float)node.requirements[i].amount;
                                        used += node.finishedRequirements[i].item.cost * (float)node.finishedRequirements[i].amount;
                                        if (shine == null) continue;
                                        shiny |= shine[i];
                                    }
                                    Label label = t.add(Core.bundle.format("research.progress", Math.min((int)(used / sum * 100.0f), 99))).left().get();
                                    if (shiny) {
                                        label.setColor(Pal.accent);
                                        label.actions(Actions.color(Color.lightGray, 0.75f, Interp.fade));
                                    } else {
                                        label.setColor(Color.lightGray);
                                    }
                                    t.row();
                                }
                                for (int i = 0; i < node.requirements.length; ++i) {
                                    ItemStack req = node.requirements[i];
                                    ItemStack completed = node.finishedRequirements[i];
                                    if (req.amount <= completed.amount) continue;
                                    boolean shiny = shine != null && shine[i];
                                    t.table(list -> {
                                        Color targetColor;
                                        int reqAmount = req.amount - completed.amount;
                                        list.left();
                                        list.image(req.item.icon(Cicon.small)).size(24.0f).padRight(3.0f);
                                        list.add(req.item.localizedName).color(Color.lightGray);
                                        Label label = list.label(() -> " " + UI.formatAmount(Math.min(ResearchDialog.this.items.get(req.item), reqAmount)) + " / " + UI.formatAmount(reqAmount)).get();
                                        Color color = targetColor = ResearchDialog.this.items.has(req.item) ? Color.lightGray : Color.scarlet;
                                        if (shiny) {
                                            label.setColor(Pal.accent);
                                            label.actions(Actions.color(targetColor, 0.75f, Interp.fade));
                                        } else {
                                            label.setColor(targetColor);
                                        }
                                    }).fillX().left();
                                    t.row();
                                }
                            } else if (node.objectives.size > 0) {
                                t.table(r -> {
                                    r.add("@complete").colspan(2).left();
                                    r.row();
                                    for (Objectives.Objective o : node.objectives) {
                                        if (o.complete()) continue;
                                        r.add("> " + o.display()).color(Color.lightGray).left();
                                        r.image(o.complete() ? Icon.ok : Icon.cancel, o.complete() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                                        r.row();
                                    }
                                });
                                t.row();
                            }
                        });
                    } else {
                        desc.add("@completed");
                    }
                }).pad(9.0f);
                if (Vars.mobile && ResearchDialog.this.locked(node)) {
                    b.row();
                    b.button("@research", (Drawable)Icon.ok, Styles.nodet, () -> this.spend(node)).disabled(i -> !this.canSpend(node)).growX().height(44.0f).colspan(3);
                }
            });
            this.infoTable.row();
            if (node.content.description != null && node.content.inlineDescription && selectable) {
                this.infoTable.table(t -> t.margin(3.0f).left().labelWrap(node.content.displayDescription()).color(Color.lightGray).growX()).fillX();
            }
            this.addChild(this.infoTable);
            this.infoTable.pack();
            this.infoTable.act(Core.graphics.getDeltaTime());
        }

        @Override
        public void drawChildren() {
            this.clamp();
            float offsetX = this.panX + this.width / 2.0f;
            float offsetY = this.panY + this.height / 2.0f;
            Draw.sort(true);
            for (TechTreeNode node : ResearchDialog.this.nodes) {
                if (!node.visible) continue;
                for (TechTreeNode child : (TechTreeNode[])node.children) {
                    if (!child.visible) continue;
                    boolean lock = ResearchDialog.this.locked(node.node) || ResearchDialog.this.locked(child.node);
                    Draw.z(lock ? 1.0f : 2.0f);
                    Lines.stroke(Scl.scl(4.0f), lock ? Pal.gray : Pal.accent);
                    Draw.alpha(this.parentAlpha);
                    if (Mathf.equal(Math.abs(node.y - child.y), Math.abs(node.x - child.x), 1.0f) && Mathf.dstm(node.x, node.y, child.x, child.y) <= node.width * 3.0f) {
                        Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                        continue;
                    }
                    Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, node.y + offsetY);
                    Lines.line(child.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                }
            }
            Draw.sort(false);
            Draw.reset();
            super.drawChildren();
        }
    }

    class LayoutNode
    extends TreeLayout.TreeNode<LayoutNode> {
        final TechTreeNode node;

        LayoutNode(TechTreeNode node, LayoutNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = ResearchDialog.this.nodeSize;
            if (node.children != null) {
                this.children = (TreeLayout.TreeNode[])Seq.with((TechTreeNode[])node.children).map(t -> new LayoutNode((TechTreeNode)t, this)).toArray(LayoutNode.class);
            }
        }
    }
}

