/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.storage.CoreBlock;

public class SchematicsDialog
extends BaseDialog {
    private SchematicInfoDialog info = new SchematicInfoDialog();
    private Schematic firstSchematic;
    private String search = "";
    private TextField searchField;

    public SchematicsDialog() {
        super("@schematics");
        Core.assets.load((String)"sprites/schematic-background.png", Texture.class).loaded = t -> ((Texture)t).setWrap(Texture.TextureWrap.repeat);
        this.shouldPause = true;
        this.addCloseButton();
        this.buttons.button("@schematic.import", Icon.download, this::showImport);
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        this.search = "";
        final Runnable[] rebuildPane = new Runnable[]{null};
        this.cont.top();
        this.cont.clear();
        this.cont.table((Table s) -> {
            s.left();
            s.image(Icon.zoom);
            this.searchField = s.field(this.search, res -> {
                this.search = res;
                rebuildPane[0].run();
            }).growX().get();
        }).fillX().padBottom(4.0f);
        this.cont.row();
        this.cont.pane((Table t) -> {
            t.top();
            t.margin(20.0f);
            t.update(() -> {
                if (Core.input.keyTap(Binding.chat) && Core.scene.getKeyboardFocus() == this.searchField && this.firstSchematic != null) {
                    if (!Vars.state.rules.schematicsAllowed) {
                        Vars.ui.showInfo("@schematic.disabled");
                    } else {
                        Vars.control.input.useSchematic(this.firstSchematic);
                        this.hide();
                    }
                }
            });
            rebuildPane[0] = () -> {
                int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1);
                t.clear();
                int i = 0;
                String regex = "[`~!@#$%^&*()-_=+{}|;:'\",<.>/?]";
                String searchString = this.search.toLowerCase().replaceAll(regex, " ");
                this.firstSchematic = null;
                for (final Schematic s : Vars.schematics.all()) {
                    if (!this.search.isEmpty() && !s.name().toLowerCase().replaceAll(regex, " ").contains(searchString)) continue;
                    if (this.firstSchematic == null) {
                        this.firstSchematic = s;
                    }
                    Button[] sel = new Button[]{null};
                    sel[0] = t.button((Button b) -> {
                        b.top();
                        b.margin(0.0f);
                        b.table((Table buttons) -> {
                            buttons.left();
                            buttons.defaults().size(50.0f);
                            ImageButton.ImageButtonStyle style = Styles.clearPartiali;
                            buttons.button((Drawable)Icon.info, style, () -> this.showInfo(s));
                            buttons.button((Drawable)Icon.upload, style, () -> this.showExport(s));
                            buttons.button((Drawable)Icon.pencil, style, () -> new Dialog("@schematic.rename"){
                                {
                                    super(title);
                                    this.cont.margin(30.0f).add("@name").padRight(6.0f);
                                    TextField nameField = this.cont.field(s.name(), null).size(400.0f, 55.0f).addInputDialog().get();
                                    this.cont.row();
                                    this.cont.margin(30.0f).add("@editor.description").padRight(6.0f);
                                    TextField descripionField = this.cont.area(s.description(), Styles.areaField, t -> {}).size(400.0f, 140.0f).addInputDialog().get();
                                    Runnable accept = () -> {
                                        s2.tags.put("name", nameField.getText());
                                        s2.tags.put("description", descripionField.getText());
                                        s.save();
                                        this.hide();
                                        rebuildPane[0].run();
                                    };
                                    this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                                    this.buttons.button("@ok", accept).disabled(b -> nameField.getText().isEmpty());
                                    this.buttons.button("@cancel", this::hide);
                                    this.keyDown(KeyCode.enter, () -> {
                                        if (!nameField.getText().isEmpty() && Core.scene.getKeyboardFocus() != descripionField) {
                                            accept.run();
                                        }
                                    });
                                    this.keyDown(KeyCode.escape, this::hide);
                                    this.keyDown(KeyCode.back, this::hide);
                                    this.show();
                                }
                            });
                            if (s.hasSteamID()) {
                                buttons.button((Drawable)Icon.link, style, () -> Vars.platform.viewListing(s));
                            } else {
                                buttons.button((Drawable)Icon.trash, style, () -> {
                                    if (s.mod != null) {
                                        Vars.ui.showInfo(Core.bundle.format("mod.item.remove", s.mod.meta.displayName()));
                                    } else {
                                        Vars.ui.showConfirm("@confirm", "@schematic.delete.confirm", () -> {
                                            Vars.schematics.remove(s);
                                            rebuildPane[0].run();
                                        });
                                    }
                                });
                            }
                        }).growX().height(50.0f);
                        b.row();
                        b.stack(new SchematicImage(s).setScaling(Scaling.fit), new Table(n -> {
                            n.top();
                            n.table(Styles.black3, c -> {
                                Label label = c.add(s.name()).style(Styles.outlineLabel).color(Color.white).top().growX().maxWidth(192.0f).get();
                                label.setEllipsis(true);
                                label.setAlignment(1);
                            }).growX().margin(1.0f).pad(4.0f).maxWidth(Scl.scl(192.0f)).padBottom(0.0f);
                        })).size(200.0f);
                    }, () -> {
                        if (sel[0].childrenPressed()) {
                            return;
                        }
                        if (Vars.state.isMenu()) {
                            this.showInfo(s);
                        } else if (!Vars.state.rules.schematicsAllowed) {
                            Vars.ui.showInfo("@schematic.disabled");
                        } else {
                            Vars.control.input.useSchematic(s);
                            this.hide();
                        }
                    }).pad(4.0f).style(Styles.cleari).get();
                    sel[0].getStyle().up = Tex.pane;
                    if (++i % cols != 0) continue;
                    t.row();
                }
                if (this.firstSchematic == null) {
                    t.add("@none");
                }
            };
            rebuildPane[0].run();
        }).get().setScrollingDisabled(true, false);
    }

    public void showInfo(Schematic schematic) {
        this.info.show(schematic);
    }

    public void showImport() {
        BaseDialog dialog = new BaseDialog("@editor.export");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 60.0f).left();
                t.row();
                t.button("@schematic.copy.import", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.readBase64(Core.app.getClipboardText());
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        Vars.ui.showInfoFade("@schematic.saved");
                        this.showInfo(s);
                    }
                    catch (Throwable e) {
                        Vars.ui.showException(e);
                    }
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("bXNjaA"));
                t.row();
                t.button("@schematic.importfile", (Drawable)Icon.download, style, () -> Vars.platform.showFileChooser(true, "msch", file -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.read(file);
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        this.showInfo(s);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                })).marginLeft(12.0f);
                t.row();
                if (Vars.steam) {
                    t.button("@schematic.browseworkshop", (Drawable)Icon.book, style, () -> {
                        dialog.hide();
                        Vars.platform.openWorkshop();
                    }).marginLeft(12.0f);
                }
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void showExport(Schematic s) {
        BaseDialog dialog = new BaseDialog("@editor.export");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 60.0f).left();
                if (Vars.steam && !s.hasSteamID()) {
                    t.button("@schematic.shareworkshop", (Drawable)Icon.book, style, () -> Vars.platform.publish(s)).marginLeft(12.0f);
                    t.row();
                    dialog.hide();
                }
                t.button("@schematic.copy", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    Vars.ui.showInfoFade("@copied");
                    Core.app.setClipboardText(Vars.schematics.writeBase64(s));
                }).marginLeft(12.0f);
                t.row();
                t.button("@schematic.exportfile", (Drawable)Icon.export, style, () -> {
                    dialog.hide();
                    Vars.platform.export(s.name(), "msch", file -> Schematics.write(s, file));
                }).marginLeft(12.0f);
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void focusSearchField() {
        if (this.searchField == null) {
            return;
        }
        Core.scene.setKeyboardFocus(this.searchField);
    }

    @Override
    public Dialog show() {
        super.show();
        if (Core.app.isDesktop()) {
            this.focusSearchField();
        }
        return this;
    }

    public static class SchematicInfoDialog
    extends BaseDialog {
        SchematicInfoDialog() {
            super("");
            this.setFillParent(true);
            this.addCloseButton();
        }

        public void show(Schematic schem) {
            this.cont.clear();
            this.title.setText("[[" + Core.bundle.get("schematic") + "] " + schem.name());
            this.cont.add(Core.bundle.format("schematic.info", schem.width, schem.height, schem.tiles.size)).color(Color.lightGray);
            this.cont.row();
            this.cont.add(new SchematicImage(schem)).maxSize(800.0f);
            this.cont.row();
            ItemSeq arr = schem.requirements();
            this.cont.table((Table r) -> {
                int i = 0;
                for (ItemStack s : arr) {
                    r.image(s.item.icon(Cicon.small)).left();
                    r.label(() -> {
                        CoreBlock.CoreBuild core = Vars.player.core();
                        if (core == null || Vars.state.rules.infiniteResources || core.items.has(s.item, s.amount)) {
                            return "[lightgray]" + s.amount + "";
                        }
                        return (core.items.has(s.item, s.amount) ? "[lightgray]" : "[scarlet]") + Math.min(core.items.get(s.item), s.amount) + "[lightgray]/" + s.amount;
                    }).padLeft(2.0f).left().padRight(4.0f);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
            });
            this.cont.row();
            float cons = schem.powerConsumption() * 60.0f;
            float prod = schem.powerProduction() * 60.0f;
            if (!Mathf.zero(cons) || !Mathf.zero(prod)) {
                this.cont.table((Table t) -> {
                    if (!Mathf.zero(prod)) {
                        t.image(Icon.powerSmall).color(Pal.powerLight).padRight(3.0f);
                        t.add("+" + Strings.autoFixed(prod, 2)).color(Pal.powerLight).left();
                        if (!Mathf.zero(cons)) {
                            t.add().width(15.0f);
                        }
                    }
                    if (!Mathf.zero(cons)) {
                        t.image(Icon.powerSmall).color(Pal.remove).padRight(3.0f);
                        t.add("-" + Strings.autoFixed(cons, 2)).color(Pal.remove).left();
                    }
                });
            }
            this.show();
        }
    }

    public static class SchematicImage
    extends Image {
        public float scaling = 16.0f;
        public float thickness = 4.0f;
        public Color borderColor = Pal.gray;
        private Schematic schematic;
        boolean set;

        public SchematicImage(Schematic s) {
            super(Tex.clear);
            this.setScaling(Scaling.fit);
            this.schematic = s;
            if (Vars.schematics.hasPreview(s)) {
                this.setPreview();
                this.set = true;
            }
        }

        @Override
        public void draw() {
            boolean checked = this.parent.parent instanceof Button && ((Button)this.parent.parent).isOver();
            boolean wasSet = this.set;
            if (!this.set) {
                Core.app.post(this::setPreview);
                this.set = true;
            }
            Texture background = Core.assets.get("sprites/schematic-background.png", Texture.class);
            TextureRegion region = Draw.wrap(background);
            float xr = this.width / this.scaling;
            float yr = this.height / this.scaling;
            region.setU2(xr);
            region.setV2(yr);
            Draw.color();
            Draw.alpha(this.parentAlpha);
            Draw.rect(region, this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
            if (wasSet) {
                super.draw();
            } else {
                Draw.rect(Icon.refresh.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width / 4.0f, this.height / 4.0f);
            }
            Draw.color(checked ? Pal.accent : this.borderColor);
            Draw.alpha(this.parentAlpha);
            Lines.stroke(Scl.scl(this.thickness));
            Lines.rect(this.x, this.y, this.width, this.height);
            Draw.reset();
        }

        private void setPreview() {
            TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(Vars.schematics.getPreview(this.schematic)));
            this.setDrawable(draw);
            this.setScaling(Scaling.fit);
        }
    }
}

