/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.graphics.Texture;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.SettingsDialog;
import arc.scene.ui.Slider;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.io.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Saves;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.input.DesktopInput;
import mindustry.input.MobileInput;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class SettingsMenuDialog
extends SettingsDialog {
    public SettingsDialog.SettingsTable graphics;
    public SettingsDialog.SettingsTable game;
    public SettingsDialog.SettingsTable sound;
    private Table prefs;
    private Table menu;
    private BaseDialog dataDialog;
    private boolean wasPaused;

    public SettingsMenuDialog() {
        this.hidden(() -> {
            Sounds.back.play();
            if (Vars.state.isGame() && (!this.wasPaused || Vars.net.active())) {
                Vars.state.set(GameState.State.playing);
            }
        });
        this.shown(() -> {
            this.back();
            if (Vars.state.isGame()) {
                this.wasPaused = Vars.state.is(GameState.State.paused);
                Vars.state.set(GameState.State.paused);
            }
            this.rebuildMenu();
        });
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.add(new Image()).growX().height(3.0f).pad(4.0f).get().setColor(Pal.accent);
        this.cont.clearChildren();
        this.cont.remove();
        this.buttons.remove();
        this.menu = new Table(Tex.button);
        this.game = new SettingsDialog.SettingsTable();
        this.graphics = new SettingsDialog.SettingsTable();
        this.sound = new SettingsDialog.SettingsTable();
        this.prefs = new Table();
        this.prefs.top();
        this.prefs.margin(14.0f);
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
        this.dataDialog = new BaseDialog("@settings.data");
        this.dataDialog.addCloseButton();
        this.dataDialog.cont.table(Tex.button, t -> {
            t.defaults().size(280.0f, 60.0f).left();
            TextButton.TextButtonStyle style = Styles.cleart;
            t.button("@settings.cleardata", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearall.confirm", () -> {
                ObjectMap<String, Object> map = new ObjectMap<String, Object>();
                for (String value : Core.settings.keys()) {
                    if (!value.contains("usid") && !value.contains("uuid")) continue;
                    map.put(value, Core.settings.get(value, null));
                }
                Core.settings.clear();
                Core.settings.putAll(map);
                for (Fi file : Vars.dataDirectory.list()) {
                    file.deleteDirectory();
                }
                Core.app.exit();
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearsaves.confirm", () -> Vars.control.saves.deleteAll())).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearresearch", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearresearch.confirm", () -> {
                Vars.universe.clearLoadoutInfo();
                for (TechTree.TechNode node : TechTree.all) {
                    node.reset();
                }
                Vars.content.each(c -> {
                    UnlockableContent u;
                    Content u$temp = c;
                    if (u$temp instanceof UnlockableContent && (u = (UnlockableContent)u$temp) == (UnlockableContent)u$temp) {
                        u.clearUnlock();
                    }
                });
                Core.settings.remove("unlocks");
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearcampaignsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearcampaignsaves.confirm", () -> {
                for (Planet planet : Vars.content.planets()) {
                    for (Sector sec : planet.sectors) {
                        sec.clearInfo();
                        if (sec.save == null) continue;
                        sec.save.delete();
                        sec.save = null;
                    }
                }
                for (Saves.SaveSlot slot : Vars.control.saves.getSaveSlots().copy()) {
                    if (!slot.isSector()) continue;
                    slot.delete();
                }
            })).marginLeft(4.0f);
            t.row();
            t.button("@data.export", (Drawable)Icon.upload, style, () -> {
                if (Vars.ios) {
                    Fi file2 = Core.files.local("mindustry-data-export.zip");
                    try {
                        this.exportData(file2);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                    Vars.platform.shareFile(file2);
                } else {
                    Vars.platform.showFileChooser(false, "zip", file -> {
                        try {
                            this.exportData((Fi)file);
                            Vars.ui.showInfo("@data.exported");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Vars.ui.showException(e);
                        }
                    });
                }
            }).marginLeft(4.0f);
            t.row();
            t.button("@data.import", (Drawable)Icon.download, style, () -> Vars.ui.showConfirm("@confirm", "@data.import.confirm", () -> Vars.platform.showFileChooser(true, "zip", file -> {
                try {
                    this.importData((Fi)file);
                    Core.app.exit();
                }
                catch (IllegalArgumentException e) {
                    Vars.ui.showErrorMessage("@data.invalid");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() == null || !e.getMessage().contains("too short")) {
                        Vars.ui.showException(e);
                    }
                    Vars.ui.showErrorMessage("@data.invalid");
                }
            }))).marginLeft(4.0f);
            if (!Vars.mobile) {
                t.row();
                t.button("@data.openfolder", (Drawable)Icon.folder, style, () -> Core.app.openFolder(Core.settings.getDataDirectory().absolutePath())).marginLeft(4.0f);
            }
            t.row();
            t.button("@crash.export", (Drawable)Icon.upload, style, () -> {
                if (Core.settings.getDataDirectory().child("crashes").list().length == 0 && !Core.settings.getDataDirectory().child("last_log.txt").exists()) {
                    Vars.ui.showInfo("@crash.none");
                } else if (Vars.ios) {
                    Fi logs = Vars.tmpDirectory.child("logs.txt");
                    logs.writeString(this.getLogs());
                    Vars.platform.shareFile(logs);
                } else {
                    Vars.platform.showFileChooser(false, "txt", file -> {
                        file.writeString(this.getLogs());
                        Core.app.post(() -> Vars.ui.showInfo("@crash.exported"));
                    });
                }
            }).marginLeft(4.0f);
        });
        final ScrollPane pane = new ScrollPane((Element)this.prefs);
        pane.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                Element actor = pane.hit(x, y, true);
                if (actor instanceof Slider) {
                    pane.setFlickScroll(false);
                    return true;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                pane.setFlickScroll(true);
                super.touchUp(event, x, y, pointer, button);
            }
        });
        pane.setFadeScrollBars(false);
        this.row();
        this.add(pane).grow().top();
        this.row();
        this.add(this.buttons).fillX();
        this.addSettings();
    }

    String getLogs() {
        Fi log = Core.settings.getDataDirectory().child("last_log.txt");
        StringBuilder out = new StringBuilder();
        for (Fi fi : Core.settings.getDataDirectory().child("crashes").list()) {
            out.append(fi.name()).append("\n\n").append(fi.readString()).append("\n");
        }
        if (log.exists()) {
            out.append("\nlast log:\n").append(log.readString());
        }
        return out.toString();
    }

    void rebuildMenu() {
        this.menu.clearChildren();
        TextButton.TextButtonStyle style = Styles.cleart;
        this.menu.defaults().size(300.0f, 60.0f);
        this.menu.button("@settings.game", style, () -> this.visible(0));
        this.menu.row();
        this.menu.button("@settings.graphics", style, () -> this.visible(1));
        this.menu.row();
        this.menu.button("@settings.sound", style, () -> this.visible(2));
        this.menu.row();
        this.menu.button("@settings.language", style, Vars.ui.language::show);
        if (!Vars.mobile || Core.settings.getBool("keyboard")) {
            this.menu.row();
            this.menu.button("@settings.controls", style, Vars.ui.controls::show);
        }
        this.menu.row();
        this.menu.button("@settings.data", style, () -> this.dataDialog.show());
    }

    void addSettings() {
        this.sound.sliderPref("musicvol", Core.bundle.get("setting.musicvol.name", "Music Volume"), 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("sfxvol", Core.bundle.get("setting.sfxvol.name", "SFX Volume"), 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("ambientvol", Core.bundle.get("setting.ambientvol.name", "Ambient Volume"), 100, 0, 100, 1, i -> i + "%");
        this.game.screenshakePref();
        if (Vars.mobile) {
            this.game.checkPref("autotarget", true);
            this.game.checkPref("keyboard", false, val -> Vars.control.setInput(val ? new DesktopInput() : new MobileInput()));
            if (Core.settings.getBool("keyboard")) {
                Vars.control.setInput(new DesktopInput());
            }
        }
        this.game.sliderPref("saveinterval", 60, 10, 600, 10, i -> Core.bundle.format("setting.seconds", i));
        if (!Vars.mobile) {
            this.game.checkPref("crashreport", true);
        }
        this.game.checkPref("savecreate", true);
        this.game.checkPref("blockreplace", true);
        this.game.checkPref("conveyorpathfinding", true);
        this.game.checkPref("hints", true);
        this.game.checkPref("logichints", true);
        if (!Vars.mobile) {
            this.game.checkPref("backgroundpause", true);
            this.game.checkPref("buildautopause", false);
        }
        this.game.checkPref("doubletapmine", false);
        if (!Vars.ios) {
            this.game.checkPref("modcrashdisable", true);
        }
        if (Vars.steam) {
            this.game.sliderPref("playerlimit", 16, 2, 32, i -> {
                Vars.platform.updateLobby();
                return i + "";
            });
            if (!Version.modifier.contains("beta")) {
                this.game.checkPref("publichost", false, i -> Vars.platform.updateLobby());
            }
        }
        this.graphics.sliderPref("uiscale", 100, 25, 300, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("uiscalechanged", true);
            }
            return s + "%";
        });
        this.graphics.sliderPref("fpscap", 240, 15, 245, 5, s -> s > 240 ? Core.bundle.get("setting.fpscap.none") : Core.bundle.format("setting.fpscap.text", s));
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("lasersopacity", 100, 0, 100, 5, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("preferredlaseropacity", s);
            }
            return s + "%";
        });
        this.graphics.sliderPref("bridgeopacity", 100, 0, 100, 5, s -> s + "%");
        if (!Vars.mobile) {
            this.graphics.checkPref("vsync", true, b -> Core.graphics.setVSync(b));
            this.graphics.checkPref("fullscreen", false, b -> {
                if (b) {
                    Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode());
                } else {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                }
            });
            this.graphics.checkPref("borderlesswindow", false, b -> Core.graphics.setUndecorated(b));
            Core.graphics.setVSync(Core.settings.getBool("vsync"));
            if (Core.settings.getBool("fullscreen")) {
                Core.app.post(() -> Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode()));
            }
            if (Core.settings.getBool("borderlesswindow")) {
                Core.app.post(() -> Core.graphics.setUndecorated(true));
            }
        } else if (!Vars.ios) {
            this.graphics.checkPref("landscape", false, b -> {
                if (b) {
                    Vars.platform.beginForceLandscape();
                } else {
                    Vars.platform.endForceLandscape();
                }
            });
            if (Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
        }
        this.graphics.checkPref("effects", true);
        this.graphics.checkPref("atmosphere", !Vars.mobile);
        this.graphics.checkPref("destroyedblocks", true);
        this.graphics.checkPref("blockstatus", false);
        this.graphics.checkPref("playerchat", true);
        if (!Vars.mobile) {
            this.graphics.checkPref("coreitems", true);
        }
        this.graphics.checkPref("minimap", !Vars.mobile);
        this.graphics.checkPref("smoothcamera", true);
        this.graphics.checkPref("position", false);
        this.graphics.checkPref("fps", false);
        this.graphics.checkPref("playerindicators", true);
        this.graphics.checkPref("indicators", true);
        this.graphics.checkPref("showweather", true);
        this.graphics.checkPref("animatedwater", true);
        if (Shaders.shield != null) {
            this.graphics.checkPref("animatedshields", !Vars.mobile);
        }
        this.graphics.checkPref("bloom", true, val -> Vars.renderer.toggleBloom(val));
        this.graphics.checkPref("pixelate", false, val -> {
            if (val) {
                Events.fire(EventType.Trigger.enablePixelation);
            }
        });
        this.graphics.checkPref("linear", !Vars.mobile, b -> {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = b ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
                tex.setFilter(filter, filter);
            }
        });
        if (Core.settings.getBool("linear")) {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = Texture.TextureFilter.linear;
                tex.setFilter(filter, filter);
            }
        }
        if (!Vars.mobile) {
            Core.settings.put("swapdiagonal", false);
        }
        this.graphics.checkPref("flow", true);
    }

    public void exportData(Fi file) throws IOException {
        Seq<Fi> files = new Seq<Fi>();
        files.add(Core.settings.getSettingsFile());
        files.addAll(Vars.customMapDirectory.list());
        files.addAll(Vars.saveDirectory.list());
        files.addAll(Vars.screenshotDirectory.list());
        files.addAll(Vars.modDirectory.list());
        files.addAll(Vars.schematicDirectory.list());
        String base = Core.settings.getDataDirectory().path();
        for (Fi other : files.copy()) {
            Fi parent = other.parent();
            while (!files.contains(parent) && !parent.equals(Core.settings.getDataDirectory())) {
                files.add(parent);
            }
        }
        try (OutputStream fos = file.write(false, 2048);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (Fi add : files) {
                String path = add.path().substring(base.length());
                if (add.isDirectory()) {
                    path = path + "/";
                }
                path = path.startsWith("/") ? path.substring(1) : path;
                zos.putNextEntry(new ZipEntry(path));
                if (!add.isDirectory()) {
                    Streams.copy(add.read(), zos);
                }
                zos.closeEntry();
            }
        }
    }

    public void importData(Fi file) {
        Fi dest = Core.files.local("zipdata.zip");
        file.copyTo(dest);
        ZipFi zipped = new ZipFi(dest);
        Fi base = Core.settings.getDataDirectory();
        if (!((Fi)zipped).child("settings.bin").exists()) {
            throw new IllegalArgumentException("Not valid save data.");
        }
        Vars.saveDirectory.deleteDirectory();
        Vars.tmpDirectory.deleteDirectory();
        zipped.walk(f -> f.copyTo(base.child(f.path())));
        dest.delete();
        Core.settings.clear();
        Core.settings.load();
    }

    private void back() {
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
    }

    private void visible(int index) {
        this.prefs.clearChildren();
        this.prefs.add((new Table[]{this.game, this.graphics, this.sound})[index]);
    }

    @Override
    public void addCloseButton() {
        this.buttons.button("@back", Icon.left, () -> {
            if (this.prefs.getChildren().first() != this.menu) {
                this.back();
            } else {
                this.hide();
            }
        }).size(210.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                if (this.prefs.getChildren().first() != this.menu) {
                    this.back();
                } else {
                    this.hide();
                }
            }
        });
    }
}

