/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.math.Interp;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.ui.fragments.Fragment;

public class BlockConfigFragment
extends Fragment {
    Table table = new Table();
    Building configTile;

    @Override
    public void build(Group parent) {
        this.table.visible = false;
        parent.addChild(this.table);
        Core.scene.add(new Element(){

            @Override
            public void act(float delta) {
                super.act(delta);
                if (Vars.state.isMenu()) {
                    BlockConfigFragment.this.table.visible = false;
                    BlockConfigFragment.this.configTile = null;
                }
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.table.visible = false;
            this.configTile = null;
        });
    }

    public boolean isShown() {
        return this.table.visible && this.configTile != null;
    }

    public Building getSelectedTile() {
        return this.configTile;
    }

    public void showConfig(Building tile) {
        if (tile.configTapped()) {
            this.configTile = tile;
            this.table.visible = true;
            this.table.clear();
            tile.buildConfiguration(this.table);
            this.table.pack();
            this.table.setTransform(true);
            this.table.actions(Actions.scaleTo(0.0f, 1.0f), Actions.visible(true), Actions.scaleTo(1.0f, 1.0f, 0.07f, Interp.pow3Out));
            this.table.update(() -> {
                if (this.configTile != null && this.configTile.shouldHideConfigure(Vars.player)) {
                    this.hideConfig();
                    return;
                }
                this.table.setOrigin(1);
                if (this.configTile == null || this.configTile.block == Blocks.air || !this.configTile.isValid()) {
                    this.hideConfig();
                } else {
                    this.configTile.updateTableAlign(this.table);
                }
            });
        }
    }

    public boolean hasConfigMouse() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.graphics.getHeight() - Core.input.mouseY(), true);
        return e != null && (e == this.table || e.isDescendantOf(this.table));
    }

    public void hideConfig() {
        this.configTile = null;
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interp.pow3Out), Actions.visible(false));
    }
}

