/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.func.Boolp;
import arc.func.Prov;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.IntSet;
import arc.util.Time;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.ui.fragments.Fragment;

public class BlockInventoryFragment
extends Fragment {
    private static final float holdWithdraw = 20.0f;
    private static final float holdShrink = 120.0f;
    Table table = new Table();
    Building tile;
    float holdTime = 0.0f;
    float emptyTime;
    boolean holding;
    float[] shrinkHoldTimes;
    Item lastItem;

    public BlockInventoryFragment() {
        this.shrinkHoldTimes = new float[Vars.content.items().size];
        Events.on(EventType.WorldLoadEvent.class, e -> this.hide());
    }

    @Override
    public void build(Group parent) {
        this.table.name = "inventory";
        this.table.setTransform(true);
        parent.setTransform(true);
        parent.addChild(this.table);
    }

    public void showFor(Building t) {
        if (this.tile == t) {
            this.hide();
            return;
        }
        this.tile = t;
        if (this.tile == null || !this.tile.block.isAccessible() || this.tile.items.total() == 0) {
            return;
        }
        this.rebuild(true);
    }

    public void hide() {
        if (this.table == null) {
            return;
        }
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interp.pow3Out), Actions.run(() -> {
            this.table.clearChildren();
            this.table.clearListeners();
            this.table.update(null);
        }), Actions.visible(false));
        this.table.touchable = Touchable.disabled;
        this.tile = null;
    }

    private void rebuild(boolean actions) {
        IntSet container = new IntSet();
        Arrays.fill(this.shrinkHoldTimes, 0.0f);
        this.emptyTime = 0.0f;
        this.holdTime = 0.0f;
        this.table.clearChildren();
        this.table.clearActions();
        this.table.background(Tex.inventory);
        this.table.touchable = Touchable.enabled;
        this.table.update(() -> {
            if (Vars.state.isMenu() || this.tile == null || !this.tile.isValid() || !this.tile.block.isAccessible() || this.emptyTime >= 120.0f) {
                this.hide();
            } else {
                this.emptyTime = this.tile.items.total() == 0 ? (this.emptyTime += Time.delta) : 0.0f;
                if (this.holding && this.lastItem != null) {
                    this.holdTime += Time.delta;
                    if (this.holdTime >= 20.0f) {
                        int amount = Math.min(this.tile.items.get(this.lastItem), Vars.player.unit().maxAccepted(this.lastItem));
                        Call.requestItem(Vars.player, this.tile, this.lastItem, amount);
                        this.holding = false;
                        this.holdTime = 0.0f;
                        if (Vars.net.client()) {
                            Events.fire(new EventType.WithdrawEvent(this.tile, Vars.player, this.lastItem, amount));
                        }
                    }
                }
                this.updateTablePosition();
                if (this.tile.block.hasItems) {
                    boolean dirty = false;
                    if (this.shrinkHoldTimes.length != Vars.content.items().size) {
                        this.shrinkHoldTimes = new float[Vars.content.items().size];
                    }
                    for (int i = 0; i < Vars.content.items().size; ++i) {
                        boolean has = this.tile.items.has(Vars.content.item(i));
                        boolean had = container.contains(i);
                        if (has) {
                            this.shrinkHoldTimes[i] = 0.0f;
                            dirty |= !had;
                            continue;
                        }
                        if (!had) continue;
                        int n = i;
                        this.shrinkHoldTimes[n] = this.shrinkHoldTimes[n] + Time.delta;
                        dirty |= this.shrinkHoldTimes[i] >= 120.0f;
                    }
                    if (dirty) {
                        this.rebuild(false);
                    }
                }
                if (this.table.getChildren().isEmpty()) {
                    this.hide();
                }
            }
        });
        int cols = 3;
        int row = 0;
        this.table.margin(4.0f);
        this.table.defaults().size(40.0f).pad(4.0f);
        if (this.tile.block.hasItems) {
            for (int i = 0; i < Vars.content.items().size; ++i) {
                final Item item = Vars.content.item(i);
                if (!this.tile.items.has(item)) continue;
                container.add(i);
                final Boolp canPick = () -> Vars.player.unit().acceptsItem(item) && !Vars.state.isPaused() && Vars.player.within(this.tile, 220.0f);
                HandCursorListener l = new HandCursorListener();
                l.enabled = canPick;
                Element image = this.itemImage(item.icon(Cicon.xlarge), () -> {
                    if (this.tile == null || !this.tile.isValid()) {
                        return "";
                    }
                    return this.round(this.tile.items.get(item));
                });
                image.addListener(l);
                image.addListener(new InputListener(){

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        if (!(canPick.get() && BlockInventoryFragment.this.tile != null && BlockInventoryFragment.this.tile.isValid() && BlockInventoryFragment.this.tile.items != null && BlockInventoryFragment.this.tile.items.has(item))) {
                            return false;
                        }
                        int amount = Math.min(1, Vars.player.unit().maxAccepted(item));
                        if (amount > 0) {
                            Call.requestItem(Vars.player, BlockInventoryFragment.this.tile, item, amount);
                            BlockInventoryFragment.this.lastItem = item;
                            BlockInventoryFragment.this.holding = true;
                            BlockInventoryFragment.this.holdTime = 0.0f;
                            if (Vars.net.client()) {
                                Events.fire(new EventType.WithdrawEvent(BlockInventoryFragment.this.tile, Vars.player, item, amount));
                            }
                        }
                        return true;
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        BlockInventoryFragment.this.holding = false;
                        BlockInventoryFragment.this.lastItem = null;
                    }
                });
                this.table.add(image);
                if (row++ % cols != cols - 1) continue;
                this.table.row();
            }
        }
        if (row == 0) {
            this.table.setSize(0.0f, 0.0f);
        }
        this.updateTablePosition();
        this.table.visible = true;
        if (actions) {
            this.table.setScale(0.0f, 1.0f);
            this.table.actions(Actions.scaleTo(1.0f, 1.0f, 0.07f, Interp.pow3Out));
        } else {
            this.table.setScale(1.0f, 1.0f);
        }
    }

    private String round(float f) {
        if ((f = (float)((int)f)) >= 1000000.0f) {
            return (int)(f / 1000000.0f) + "[gray]" + Core.bundle.getOrNull("unit.millions") + "[]";
        }
        if (f >= 1000.0f) {
            return (int)(f / 1000.0f) + Core.bundle.getOrNull("unit.thousands");
        }
        return (int)f + "";
    }

    private void updateTablePosition() {
        Vec2 v = Core.input.mouseScreen(this.tile.x + (float)(this.tile.block.size * 8) / 2.0f, this.tile.y + (float)(this.tile.block.size * 8) / 2.0f);
        this.table.pack();
        this.table.setPosition(v.x, v.y, 10);
    }

    private Element itemImage(TextureRegion region, Prov<CharSequence> text) {
        Stack stack = new Stack();
        Table t = new Table().left().bottom();
        t.label(text);
        stack.add(new Image(region));
        stack.add(t);
        return stack;
    }
}

