/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Input;
import arc.func.Boolp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.scene.Group;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.gen.Call;
import mindustry.input.Binding;
import mindustry.ui.Fonts;
import mindustry.ui.fragments.Fragment;

public class ChatFragment
extends Table {
    private static final int messagesShown = 10;
    private Seq<ChatMessage> messages = new Seq();
    private float fadetime;
    private boolean shown = false;
    private TextField chatfield;
    private Label fieldlabel = new Label(">");
    private ChatMode mode = ChatMode.normal;
    private Font font;
    private GlyphLayout layout = new GlyphLayout();
    private float offsetx = Scl.scl(4.0f);
    private float offsety = Scl.scl(4.0f);
    private float fontoffsetx = Scl.scl(2.0f);
    private float chatspace = Scl.scl(50.0f);
    private Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private float textspacing = Scl.scl(10.0f);
    private Seq<String> history = new Seq();
    private int historyPos = 0;
    private int scrollPos = 0;
    private Fragment container = new Fragment(){

        @Override
        public void build(Group parent) {
            Core.scene.add(ChatFragment.this);
        }
    };

    public ChatFragment() {
        this.setFillParent(true);
        this.font = Fonts.def;
        this.visible(() -> {
            if (!Vars.net.active() && this.messages.size > 0) {
                this.clearMessages();
                if (this.shown) {
                    this.hide();
                }
            }
            return Vars.net.active() && Vars.ui.hudfrag.shown;
        });
        this.update(() -> {
            if (Vars.net.active() && Core.input.keyTap(Binding.chat) && (Core.scene.getKeyboardFocus() == this.chatfield || Core.scene.getKeyboardFocus() == null || Vars.ui.minimapfrag.shown()) && !Vars.ui.scriptfrag.shown()) {
                this.toggle();
            }
            if (this.shown) {
                if (Core.input.keyTap(Binding.chat_history_prev) && this.historyPos < this.history.size - 1) {
                    if (this.historyPos == 0) {
                        this.history.set(0, this.chatfield.getText());
                    }
                    ++this.historyPos;
                    this.updateChat();
                }
                if (Core.input.keyTap(Binding.chat_history_next) && this.historyPos > 0) {
                    --this.historyPos;
                    this.updateChat();
                }
                if (Core.input.keyTap(Binding.chat_mode)) {
                    this.nextMode();
                }
                this.scrollPos = (int)Mathf.clamp((float)this.scrollPos + Core.input.axis(Binding.chat_scroll), 0.0f, (float)Math.max(0, this.messages.size - 10));
            }
        });
        this.history.insert(0, "");
        this.setup();
    }

    public Fragment container() {
        return this.container;
    }

    public void clearMessages() {
        this.messages.clear();
        this.history.clear();
        this.history.insert(0, "");
    }

    private void setup() {
        this.fieldlabel.setStyle(new Label.LabelStyle(this.fieldlabel.getStyle()));
        this.fieldlabel.getStyle().font = this.font;
        this.fieldlabel.setStyle(this.fieldlabel.getStyle());
        this.chatfield = new TextField("", new TextField.TextFieldStyle(Core.scene.getStyle(TextField.TextFieldStyle.class)));
        this.chatfield.setMaxLength(150);
        this.chatfield.getStyle().background = null;
        this.chatfield.getStyle().font = Fonts.chat;
        this.chatfield.getStyle().fontColor = Color.white;
        this.chatfield.setStyle(this.chatfield.getStyle());
        this.bottom().left().marginBottom(this.offsety).marginLeft(this.offsetx * 2.0f).add(this.fieldlabel).padBottom(6.0f);
        this.add(this.chatfield).padBottom(this.offsety).padLeft(this.offsetx).growX().padRight(this.offsetx).height(28.0f);
        if (Vars.mobile) {
            this.marginBottom(105.0f);
            this.marginRight(240.0f);
        }
    }

    @Override
    public void draw() {
        float opacity = (float)Core.settings.getInt("chatopacity") / 100.0f;
        float textWidth = Math.min((float)Core.graphics.getWidth() / 1.5f, Scl.scl(700.0f));
        Draw.color(this.shadowColor);
        if (this.shown) {
            Fill.crect(this.offsetx, this.chatfield.y + Core.scene.marginBottom, this.chatfield.getWidth() + 15.0f, this.chatfield.getHeight() - 1.0f);
        }
        super.draw();
        float spacing = this.chatspace;
        this.chatfield.visible = this.shown;
        this.fieldlabel.visible = this.shown;
        Draw.color(this.shadowColor);
        Draw.alpha(this.shadowColor.a * opacity);
        float theight = this.offsety + spacing + this.getMarginBottom() + Core.scene.marginBottom;
        for (int i = this.scrollPos; i < this.messages.size && i < 10 + this.scrollPos && ((float)i < this.fadetime || this.shown); ++i) {
            this.layout.setText(this.font, this.messages.get((int)i).formattedMessage, Color.white, textWidth, 12, true);
            theight += this.layout.height + this.textspacing;
            if (i - this.scrollPos == 0) {
                theight -= this.textspacing + 1.0f;
            }
            this.font.getCache().clear();
            this.font.getCache().addText(this.messages.get((int)i).formattedMessage, this.fontoffsetx + this.offsetx, this.offsety + theight, textWidth, 12, true);
            if (!this.shown && this.fadetime - (float)i < 1.0f && this.fadetime - (float)i >= 0.0f) {
                this.font.getCache().setAlphas((this.fadetime - (float)i) * opacity);
                Draw.color(0.0f, 0.0f, 0.0f, this.shadowColor.a * (this.fadetime - (float)i) * opacity);
            } else {
                this.font.getCache().setAlphas(opacity);
            }
            Fill.crect(this.offsetx, theight - this.layout.height - 2.0f, textWidth + Scl.scl(4.0f), this.layout.height + this.textspacing);
            Draw.color(this.shadowColor);
            Draw.alpha(opacity * this.shadowColor.a);
            this.font.getCache().draw();
        }
        Draw.color();
        if (this.fadetime > 0.0f && !this.shown) {
            this.fadetime -= Time.delta / 180.0f;
        }
    }

    private void sendMessage() {
        String message = this.chatfield.getText().trim();
        this.clearChatInput();
        if (message.isEmpty()) {
            return;
        }
        this.history.insert(1, message);
        Call.sendChatMessage(message);
    }

    public void toggle() {
        if (!this.shown) {
            Core.scene.setKeyboardFocus(this.chatfield);
            this.shown = true;
            if (Vars.mobile) {
                Input.TextInput input = new Input.TextInput();
                input.maxLength = 150;
                input.accepted = text -> {
                    this.chatfield.setText((String)text);
                    this.sendMessage();
                    this.hide();
                    Core.input.setOnscreenKeyboardVisible(false);
                };
                input.canceled = this::hide;
                Core.input.getTextInput(input);
            } else {
                this.chatfield.fireClick();
            }
        } else {
            Time.runTask(2.0f, () -> {
                Core.scene.setKeyboardFocus(null);
                this.shown = false;
                this.scrollPos = 0;
                this.sendMessage();
            });
        }
    }

    public void hide() {
        Core.scene.setKeyboardFocus(null);
        this.shown = false;
        this.clearChatInput();
    }

    public void updateChat() {
        this.chatfield.setText(this.mode.normalizedPrefix() + this.history.get(this.historyPos));
        this.updateCursor();
    }

    public void nextMode() {
        ChatMode prev = this.mode;
        do {
            this.mode = this.mode.next();
        } while (!this.mode.isValid());
        if (this.chatfield.getText().startsWith(prev.normalizedPrefix())) {
            this.chatfield.setText(this.mode.normalizedPrefix() + this.chatfield.getText().substring(prev.normalizedPrefix().length()));
        } else {
            this.chatfield.setText(this.mode.normalizedPrefix());
        }
        this.updateCursor();
    }

    public void clearChatInput() {
        this.historyPos = 0;
        this.history.set(0, "");
        this.chatfield.setText(this.mode.normalizedPrefix());
        this.updateCursor();
    }

    public void updateCursor() {
        this.chatfield.setCursorPosition(this.chatfield.getText().length());
    }

    public boolean shown() {
        return this.shown;
    }

    public void addMessage(String message, String sender) {
        if (sender == null && message == null) {
            return;
        }
        this.messages.insert(0, new ChatMessage(message, sender));
        this.fadetime += 1.0f;
        this.fadetime = Math.min(this.fadetime, 10.0f) + 1.0f;
        if (this.scrollPos > 0) {
            ++this.scrollPos;
        }
    }

    private static enum ChatMode {
        normal(""),
        team("/t"),
        admin("/a", Vars.player::admin);

        public String prefix;
        public Boolp valid;
        public static final ChatMode[] all;

        private ChatMode(String prefix) {
            this.prefix = prefix;
            this.valid = () -> true;
        }

        private ChatMode(String prefix, Boolp valid) {
            this.prefix = prefix;
            this.valid = valid;
        }

        public ChatMode next() {
            return all[(this.ordinal() + 1) % all.length];
        }

        public String normalizedPrefix() {
            return this.prefix.isEmpty() ? "" : this.prefix + " ";
        }

        public boolean isValid() {
            return this.valid.get();
        }

        static {
            all = ChatMode.values();
        }
    }

    private static class ChatMessage {
        public final String sender;
        public final String message;
        public final String formattedMessage;

        public ChatMessage(String message, String sender) {
            this.message = message;
            this.sender = sender;
            this.formattedMessage = sender == null ? (message == null ? "" : message) : "[coral][[" + sender + "[coral]]:[white] " + message;
        }
    }
}

