/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.func.Boolp;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.SectorPresets;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.fragments.Fragment;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;

public class HintsFragment
extends Fragment {
    private static final Boolp isTutorial = () -> Vars.state.rules.sector == SectorPresets.groundZero.sector;
    private static final float foutTime = 0.6f;
    public Seq<Hint> hints = new Seq<DefaultHint>().and(DefaultHint.values()).as();
    @Nullable
    Hint current;
    Group group = new WidgetGroup();
    ObjectSet<String> events = new ObjectSet();
    ObjectSet<Block> placedBlocks = new ObjectSet();
    Table last;

    @Override
    public void build(Group parent) {
        this.group.setFillParent(true);
        this.group.touchable = Touchable.childrenOnly;
        this.group.visibility = () -> Core.settings.getBool("hints", true) && Vars.ui.hudfrag.shown;
        this.group.update(() -> {
            if (this.current != null) {
                if (this.current.complete()) {
                    this.complete();
                } else if (!this.current.show()) {
                    this.hide();
                }
            } else if (this.hints.size > 0) {
                Hint hint = this.hints.find(Hint::show);
                if (hint != null && hint.complete()) {
                    this.hints.remove(hint);
                } else if (hint != null) {
                    this.display(hint);
                }
            }
        });
        parent.addChild(this.group);
        this.checkNext();
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking && event.unit == Vars.player.unit()) {
                this.placedBlocks.add(event.tile.block());
            }
            if (event.breaking) {
                this.events.add("break");
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.placedBlocks.clear();
            this.events.clear();
        });
    }

    void checkNext() {
        if (this.current != null) {
            return;
        }
        this.hints.removeAll(h -> !h.valid() || h.finished() || h.show() && h.complete());
        this.hints.sort(Hint::order);
        Hint first = this.hints.find(Hint::show);
        if (first != null) {
            this.hints.remove(first);
            this.display(first);
        }
    }

    void display(Hint hint) {
        if (this.current != null) {
            return;
        }
        this.group.fill(t -> {
            this.last = t;
            t.left();
            t.table(Styles.black5, cont -> {
                cont.actions(Actions.alpha(0.0f), Actions.alpha(1.0f, 1.0f, Interp.smooth));
                cont.margin(6.0f).add(hint.text()).width(Vars.mobile ? 270.0f : 400.0f).left().labelAlign(8).wrap();
            });
            t.row();
            t.button("@hint.skip", Styles.nonet, () -> {
                if (this.current != null) {
                    this.complete();
                }
            }).size(112.0f, 40.0f).left();
        });
        this.current = hint;
    }

    void complete() {
        if (this.current == null) {
            return;
        }
        this.current.finish();
        this.hints.remove(this.current);
        this.hide();
    }

    void hide() {
        if (this.last != null) {
            this.last.actions(Actions.parallel((Action)Actions.alpha(0.0f, 0.6f, Interp.smooth), (Action)Actions.translateBy(0.0f, Scl.scl(-200.0f), 0.6f, Interp.smooth)), Actions.remove());
        }
        this.current = null;
        this.last = null;
        this.checkNext();
    }

    public boolean shown() {
        return this.current != null;
    }

    public static enum DefaultHint implements Hint
    {
        desktopMove(1, () -> Core.input.axis(Binding.move_x) != 0.0f || Core.input.axis(Binding.move_y) != 0.0f),
        zoom(1, () -> Core.input.axis(KeyCode.scroll) != 0.0f),
        mine(() -> Vars.player.unit().canMine() && isTutorial.get(), () -> Vars.player.unit().mining()),
        placeDrill(HintsFragment.access$000(), () -> Vars.ui.hints.placedBlocks.contains(Blocks.mechanicalDrill)),
        placeConveyor(HintsFragment.access$000(), () -> Vars.ui.hints.placedBlocks.contains(Blocks.conveyor)),
        placeTurret(HintsFragment.access$000(), () -> Vars.ui.hints.placedBlocks.contains(Blocks.duo)),
        breaking(HintsFragment.access$000(), () -> Vars.ui.hints.events.contains("break")),
        desktopShoot(1, () -> Vars.state.enemies > 0, () -> Vars.player.shooting),
        depositItems(() -> Vars.player.unit().hasItem(), () -> !Vars.player.unit().hasItem()),
        desktopPause(1, () -> isTutorial.get() && !Vars.net.active(), () -> Core.input.keyTap(Binding.pause)),
        research(HintsFragment.access$000(), () -> Vars.ui.research.isShown()),
        unitControl(() -> Vars.state.rules.defaultTeam.data().units.size > 2 && !Vars.net.active() && !Vars.player.dead(), () -> !Vars.player.dead() && !Vars.player.unit().spawnedByCore),
        respawn(2, () -> !Vars.player.dead() && !Vars.player.unit().spawnedByCore, () -> !Vars.player.dead() && Vars.player.unit().spawnedByCore),
        launch(() -> isTutorial.get() && Vars.state.rules.sector.isCaptured(), () -> Vars.ui.planet.isShown()),
        schematicSelect(1, () -> Vars.ui.hints.placedBlocks.contains(Blocks.router), () -> Core.input.keyRelease(Binding.schematic_select) || Core.input.keyTap(Binding.pick)),
        conveyorPathfind(() -> Vars.control.input.block == Blocks.titaniumConveyor, () -> Core.input.keyRelease(Binding.diagonal_placement) || Vars.mobile && Core.settings.getBool("swapdiagonal")),
        boost(1, () -> !Vars.player.dead() && Vars.player.unit().type.canBoost, () -> Core.input.keyDown(Binding.boost)),
        command(() -> Vars.state.rules.defaultTeam.data().units.size > 3 && !Vars.net.active(), () -> Vars.player.unit().isCommanding()),
        payloadPickup(() -> {
            Payloadc p;
            Unit p$temp;
            return !Vars.player.unit().dead && (p$temp = Vars.player.unit()) instanceof Payloadc && (p = (Payloadc)((Object)p$temp)) == (Payloadc)((Object)p$temp) && p.payloads().isEmpty();
        }, () -> {
            Payloadc p;
            Unit p$temp = Vars.player.unit();
            return p$temp instanceof Payloadc && (p = (Payloadc)((Object)p$temp)) == (Payloadc)((Object)p$temp) && p.payloads().any();
        }),
        payloadDrop(() -> {
            Payloadc p;
            Unit p$temp;
            return !Vars.player.unit().dead && (p$temp = Vars.player.unit()) instanceof Payloadc && (p = (Payloadc)((Object)p$temp)) == (Payloadc)((Object)p$temp) && p.payloads().any();
        }, () -> {
            Payloadc p;
            Unit p$temp = Vars.player.unit();
            return p$temp instanceof Payloadc && (p = (Payloadc)((Object)p$temp)) == (Payloadc)((Object)p$temp) && p.payloads().isEmpty();
        }),
        waveFire(() -> Groups.fire.size() > 0 && Blocks.wave.unlockedNow(), () -> Vars.indexer.getAllied(Vars.state.rules.defaultTeam, BlockFlag.extinguisher).size() > 0),
        generator(() -> Vars.control.input.block == Blocks.combustionGenerator, () -> Vars.ui.hints.placedBlocks.contains(Blocks.combustionGenerator)),
        guardian(() -> Vars.state.boss() != null && Vars.state.boss().armor >= 4.0f, () -> Vars.state.boss() == null),
        coreUpgrade(() -> Vars.state.isCampaign() && Blocks.coreFoundation.unlocked() && Vars.state.rules.defaultTeam.core() != null && Vars.state.rules.defaultTeam.core().block == Blocks.coreShard && Vars.state.rules.defaultTeam.core().items.has(Blocks.coreFoundation.requirements), () -> Vars.ui.hints.placedBlocks.contains(Blocks.coreFoundation)),
        presetLaunch(() -> Vars.state.isCampaign() && Vars.state.getSector().preset == null && SectorPresets.frozenForest.unlocked() && SectorPresets.frozenForest.sector.save == null, () -> Vars.state.isCampaign() && Vars.state.getSector().preset == SectorPresets.frozenForest),
        coreIncinerate(() -> Vars.state.isCampaign() && Vars.state.rules.defaultTeam.core() != null && Vars.state.rules.defaultTeam.core().items.get(Items.copper) >= Vars.state.rules.defaultTeam.core().storageCapacity - 10, () -> false),
        coopCampaign(() -> Vars.net.client() && Vars.state.isCampaign() && SectorPresets.groundZero.sector.hasBase(), () -> false);

        @Nullable
        String text;
        int visibility = 3;
        Hint[] dependencies = new Hint[0];
        boolean finished;
        boolean cached;
        Boolp complete;
        Boolp shown = () -> true;

        private DefaultHint(Boolp complete) {
            this.complete = complete;
        }

        private DefaultHint(int visiblity, Boolp complete) {
            this(complete);
            this.visibility = visiblity;
        }

        private DefaultHint(Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
        }

        private DefaultHint(int visiblity, Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
            this.visibility = visiblity;
        }

        @Override
        public boolean finished() {
            if (!this.cached) {
                this.cached = true;
                this.finished = Core.settings.getBool(this.name() + "-hint-done", false);
            }
            return this.finished;
        }

        @Override
        public void finish() {
            this.finished = true;
            Core.settings.put(this.name() + "-hint-done", true);
        }

        @Override
        public String text() {
            if (this.text == null) {
                String string = this.text = Vars.mobile && Core.bundle.has("hint." + this.name() + ".mobile") ? Core.bundle.get("hint." + this.name() + ".mobile") : Core.bundle.get("hint." + this.name());
                if (!Vars.mobile) {
                    this.text = this.text.replace("tap", "click").replace("Tap", "Click");
                }
            }
            return this.text;
        }

        @Override
        public boolean complete() {
            return this.complete.get();
        }

        @Override
        public boolean show() {
            return this.shown.get() && (this.dependencies.length == 0 || !Structs.contains(this.dependencies, d -> !d.finished()));
        }

        @Override
        public int order() {
            return this.ordinal();
        }

        @Override
        public boolean valid() {
            return Vars.mobile && (this.visibility & 2) != 0 || !Vars.mobile && (this.visibility & 1) != 0;
        }
    }

    public static interface Hint {
        public static final int visibleDesktop = 1;
        public static final int visibleMobile = 2;
        public static final int visibleAll = 3;

        public String name();

        public String text();

        public boolean complete();

        public boolean show();

        public int order();

        public boolean valid();

        default public void finish() {
            Core.settings.put(this.name() + "-hint-done", true);
        }

        default public boolean finished() {
            return Core.settings.getBool(this.name() + "-hint-done", false);
        }
    }
}

