/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.MenuRenderer;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.ui.MobileButton;
import mindustry.ui.Styles;
import mindustry.ui.fragments.Fragment;

public class MenuFragment
extends Fragment {
    private Table container;
    private Table submenu;
    private Button currentMenu;
    private MenuRenderer renderer;

    @Override
    public void build(Group parent) {
        this.renderer = new MenuRenderer();
        WidgetGroup group = new WidgetGroup();
        ((Element)group).setFillParent(true);
        group.visible(() -> !Vars.ui.editor.isShown());
        parent.addChild(group);
        parent = group;
        parent.fill((x, y, w, h) -> this.renderer.render());
        parent.fill(c -> {
            this.container = c;
            c.name = "menu container";
            if (!Vars.mobile) {
                this.buildDesktop();
                Events.on(EventType.ResizeEvent.class, event -> this.buildDesktop());
            } else {
                this.buildMobile();
                Events.on(EventType.ResizeEvent.class, event -> this.buildMobile());
            }
        });
        if (Vars.mobile) {
            parent.fill(c -> c.bottom().left().button("", Styles.infot, Vars.ui.about::show).size(84.0f, 45.0f).name("info"));
            parent.fill(c -> c.bottom().right().button("", Styles.discordt, Vars.ui.discord::show).size(84.0f, 45.0f).name("discord"));
        } else if (Vars.becontrol.active()) {
            parent.fill(c -> c.bottom().right().button("@be.check", Icon.refresh, () -> {
                Vars.ui.loadfrag.show();
                Vars.becontrol.checkUpdate(result -> {
                    Vars.ui.loadfrag.hide();
                    if (!result) {
                        Vars.ui.showInfo("@be.noupdates");
                    }
                });
            }).size(200.0f, 60.0f).name("becheck").update(t -> t.getLabel().setColor(Vars.becontrol.isUpdateAvailable() ? Tmp.c1.set(Color.white).lerp(Pal.accent, Mathf.absin(5.0f, 1.0f)) : Color.white)));
        }
        String versionText = (Version.build == -1 ? "[#fc8140aa]" : "[#ffffffba]") + Version.combined();
        parent.fill((Table.DrawRect)(Table.DrawRect)LambdaMetafactory.metafactory(null, null, null, (FFFF)V, lambda$build$11(java.lang.String float float float float ), (FFFF)V)((String)versionText)).touchable = Touchable.disabled;
    }

    private void buildMobile() {
        this.container.clear();
        this.container.name = "buttons";
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float size = 120.0f;
        this.container.defaults().size(size).pad(5.0f).padTop(4.0f);
        MobileButton play = new MobileButton((Drawable)Icon.play, "@campaign", () -> this.checkPlay(Vars.ui.planet::show));
        MobileButton custom = new MobileButton((Drawable)Icon.rightOpenOut, "@customgame", () -> this.checkPlay(Vars.ui.custom::show));
        MobileButton maps = new MobileButton((Drawable)Icon.download, "@loadgame", () -> this.checkPlay(Vars.ui.load::show));
        MobileButton join = new MobileButton((Drawable)Icon.add, "@joingame", () -> this.checkPlay(Vars.ui.join::show));
        MobileButton editor = new MobileButton((Drawable)Icon.terrain, "@editor", () -> this.checkPlay(Vars.ui.maps::show));
        MobileButton tools = new MobileButton((Drawable)Icon.settings, "@settings", Vars.ui.settings::show);
        MobileButton mods = new MobileButton((Drawable)Icon.book, "@mods", Vars.ui.mods::show);
        MobileButton exit = new MobileButton((Drawable)Icon.exit, "@quit", () -> Core.app.exit());
        if (!Core.graphics.isPortrait()) {
            this.container.marginTop(60.0f);
            this.container.add(play);
            this.container.add(join);
            this.container.add(custom);
            this.container.add(maps);
            this.container.row();
            this.container.table(table -> {
                table.defaults().set(this.container.defaults());
                table.add(editor);
                table.add(tools);
                table.add(mods);
                if (!Vars.ios) {
                    table.add(exit);
                }
            }).colspan(4);
        } else {
            this.container.marginTop(0.0f);
            this.container.add(play);
            this.container.add(maps);
            this.container.row();
            this.container.add(custom);
            this.container.add(join);
            this.container.row();
            this.container.add(editor);
            this.container.add(tools);
            this.container.row();
            this.container.table(table -> {
                table.defaults().set(this.container.defaults());
                table.add(mods);
                if (!Vars.ios) {
                    table.add(exit);
                }
            }).colspan(2);
        }
    }

    private void buildDesktop() {
        this.container.clear();
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float width = 230.0f;
        Drawable background = Styles.black6;
        this.container.left();
        this.container.add().width((float)Core.graphics.getWidth() / 10.0f);
        this.container.table(background, t -> {
            t.defaults().width(width).height(70.0f);
            t.name = "buttons";
            Buttoni[] buttoniArray = new Buttoni[7];
            buttoniArray[0] = new Buttoni("@play", (Drawable)Icon.play, new Buttoni("@campaign", (Drawable)Icon.play, () -> this.checkPlay(Vars.ui.planet::show)), new Buttoni("@joingame", (Drawable)Icon.add, () -> this.checkPlay(Vars.ui.join::show)), new Buttoni("@customgame", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.custom::show)), new Buttoni("@loadgame", (Drawable)Icon.download, () -> this.checkPlay(Vars.ui.load::show)));
            buttoniArray[1] = new Buttoni("@editor", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.maps::show));
            buttoniArray[2] = Vars.steam ? new Buttoni("@workshop", (Drawable)Icon.steam, Vars.platform::openWorkshop) : null;
            buttoniArray[3] = new Buttoni("@mods", (Drawable)Icon.book, Vars.ui.mods::show);
            buttoniArray[4] = new Buttoni("@settings", (Drawable)Icon.settings, Vars.ui.settings::show);
            buttoniArray[5] = new Buttoni("@about.button", (Drawable)Icon.info, Vars.ui.about::show);
            buttoniArray[6] = new Buttoni("@quit", (Drawable)Icon.exit, Core.app::exit);
            this.buttons((Table)t, buttoniArray);
        }).width(width).growY();
        this.container.table(background, t -> {
            this.submenu = t;
            t.name = "submenu";
            t.color.a = 0.0f;
            t.top();
            t.defaults().width(width).height(70.0f);
            t.visible(() -> !t.getChildren().isEmpty());
        }).width(width).growY();
    }

    private void checkPlay(Runnable run) {
        if (!Vars.mods.hasContentErrors()) {
            run.run();
        } else {
            Vars.ui.showInfo("@mod.noerrorplay");
        }
    }

    private void fadeInMenu() {
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f, 0.15f, Interp.fade));
    }

    private void fadeOutMenu() {
        if (this.submenu.getChildren().isEmpty()) {
            return;
        }
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f), Actions.alpha(0.0f, 0.2f, Interp.fade), Actions.run(() -> this.submenu.clearChildren()));
    }

    private void buttons(Table t, Buttoni ... buttons) {
        for (Buttoni b : buttons) {
            if (b == null) continue;
            Button[] out = new Button[]{null};
            out[0] = t.button(b.text, b.icon, Styles.clearToggleMenut, () -> {
                if (this.currentMenu == out[0]) {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                } else if (b.submenu != null) {
                    this.currentMenu = out[0];
                    this.submenu.clearChildren();
                    this.fadeInMenu();
                    this.submenu.add().height(((float)Core.graphics.getHeight() - Core.scene.marginTop - Core.scene.marginBottom - out[0].getY(10)) / Scl.scl(1.0f));
                    this.submenu.row();
                    this.buttons(this.submenu, b.submenu);
                } else {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                    b.runnable.run();
                }
            }).marginLeft(11.0f).get();
            out[0].update(() -> out[0].setChecked(this.currentMenu == out[0]));
            t.row();
        }
    }

    private static /* synthetic */ void lambda$build$11(String versionText, float x, float y, float w, float h) {
        TextureAtlas.AtlasRegion logo = Core.atlas.find("logo");
        float width = Core.graphics.getWidth();
        float height = (float)Core.graphics.getHeight() - Core.scene.marginTop;
        float logoscl = Scl.scl(1.0f);
        float logow = Math.min((float)logo.width * logoscl, (float)Core.graphics.getWidth() - Scl.scl(20.0f));
        float logoh = logow * (float)logo.height / (float)logo.width;
        float fx = (int)(width / 2.0f);
        float fy = (float)((int)(height - 6.0f - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl(30.0f) : 0.0f);
        Draw.color();
        Draw.rect((TextureRegion)logo, fx, fy, logow, logoh);
        Fonts.def.setColor(Color.white);
        Fonts.def.draw(versionText, fx, fy - logoh / 2.0f, 1);
    }

    private static class Buttoni {
        final Drawable icon;
        final String text;
        final Runnable runnable;
        final Buttoni[] submenu;

        public Buttoni(String text, Drawable icon, Runnable runnable) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = null;
        }

        public Buttoni(String text, Drawable icon, Buttoni ... buttons) {
            this.icon = icon;
            this.text = text;
            this.runnable = () -> {};
            this.submenu = buttons;
        }
    }
}

