/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.fragments.Fragment;

public class MinimapFragment
extends Fragment {
    private boolean shown;
    float panx;
    float pany;
    float zoom = 1.0f;
    float lastZoom = -1.0f;
    private float baseSize = Scl.scl(5.0f);
    public Element elem;

    @Override
    public void build(Group parent) {
        this.elem = parent.fill((x, y, w, h) -> {
            w = Core.graphics.getWidth();
            h = Core.graphics.getHeight();
            float size = this.baseSize * this.zoom * (float)Vars.world.width();
            Draw.color(Color.black);
            Fill.crect(0.0f, 0.0f, w, h);
            if (Vars.renderer.minimap.getTexture() != null) {
                Draw.color();
                float ratio = (float)Vars.renderer.minimap.getTexture().height / (float)Vars.renderer.minimap.getTexture().width;
                TextureRegion reg = Draw.wrap(Vars.renderer.minimap.getTexture());
                Draw.rect(reg, w / 2.0f + this.panx * this.zoom, h / 2.0f + this.pany * this.zoom, size, size * ratio);
                Vars.renderer.minimap.drawEntities(w / 2.0f + this.panx * this.zoom - size / 2.0f, h / 2.0f + this.pany * this.zoom - size / 2.0f * ratio, size, size * ratio, this.zoom, true);
            }
            Draw.reset();
        });
        this.elem.visible(() -> this.shown);
        this.elem.update(() -> {
            if (!Vars.ui.chatfrag.shown()) {
                this.elem.requestKeyboard();
                this.elem.requestScroll();
            }
            this.elem.setFillParent(true);
            this.elem.setBounds(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
            if (Core.input.keyTap(Binding.menu)) {
                this.shown = false;
            }
        });
        this.elem.touchable = Touchable.enabled;
        this.elem.addListener(new ElementGestureListener(){

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (MinimapFragment.this.lastZoom < 0.0f) {
                    MinimapFragment.this.lastZoom = MinimapFragment.this.zoom;
                }
                MinimapFragment.this.zoom = Mathf.clamp(distance / initialDistance * MinimapFragment.this.lastZoom, 0.25f, 10.0f);
            }

            @Override
            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                MinimapFragment.this.panx += deltaX / MinimapFragment.this.zoom;
                MinimapFragment.this.pany += deltaY / MinimapFragment.this.zoom;
            }

            @Override
            public void touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                MinimapFragment.this.lastZoom = MinimapFragment.this.zoom;
            }
        });
        this.elem.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                MinimapFragment.this.zoom = Mathf.clamp(MinimapFragment.this.zoom - amountY / 10.0f * MinimapFragment.this.zoom, 0.25f, 10.0f);
                return true;
            }
        });
        parent.fill(t -> {
            t.setFillParent(true);
            t.visible(() -> this.shown);
            t.update(() -> t.setBounds(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight()));
            t.add("@minimap").style(Styles.outlineLabel).pad(10.0f);
            t.row();
            t.add().growY();
            t.row();
            t.button("@back", Icon.leftOpen, () -> {
                this.shown = false;
            }).size(220.0f, 60.0f).pad(10.0f);
        });
    }

    public boolean shown() {
        return this.shown;
    }

    public void hide() {
        this.shown = false;
    }

    public void toggle() {
        float size = this.baseSize * this.zoom * (float)Vars.world.width();
        float ratio = (float)Vars.renderer.minimap.getTexture().height / (float)Vars.renderer.minimap.getTexture().width;
        float px = Vars.player.dead() ? Core.camera.position.x : Vars.player.x;
        float py = Vars.player.dead() ? Core.camera.position.y : Vars.player.y;
        this.panx = (size / 2.0f - px / (float)(Vars.world.width() * 8) * size) / this.zoom;
        this.pany = (size * ratio / 2.0f - py / (float)(Vars.world.height() * 8) * size * ratio) / this.zoom;
        this.shown = !this.shown;
    }
}

