/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.KeyBinds;
import arc.func.Prov;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.Displayable;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.fragments.Fragment;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;

public class PlacementFragment
extends Fragment {
    final int rowWidth = 4;
    public Category currentCategory = Category.distribution;
    Seq<Block> returnArray = new Seq();
    Seq<Block> returnArray2 = new Seq();
    Seq<Category> returnCatArray = new Seq();
    boolean[] categoryEmpty = new boolean[Category.all.length];
    ObjectMap<Category, Block> selectedBlocks = new ObjectMap();
    ObjectFloatMap<Category> scrollPositions = new ObjectFloatMap();
    Block menuHoverBlock;
    Displayable hover;
    Object lastDisplayState;
    boolean wasHovered;
    Table blockTable;
    Table toggler;
    Table topTable;
    ScrollPane blockPane;
    boolean blockSelectEnd;
    int blockSelectSeq;
    long blockSelectSeqMillis;
    Binding[] blockSelect = new Binding[]{Binding.block_select_01, Binding.block_select_02, Binding.block_select_03, Binding.block_select_04, Binding.block_select_05, Binding.block_select_06, Binding.block_select_07, Binding.block_select_08, Binding.block_select_09, Binding.block_select_10, Binding.block_select_left, Binding.block_select_right, Binding.block_select_up, Binding.block_select_down};

    public PlacementFragment() {
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> {
            Vars.control.input.block = null;
            this.rebuild();
        }));
        Events.on(EventType.UnlockEvent.class, event -> {
            if (event.content instanceof Block) {
                this.rebuild();
            }
        });
        Events.on(EventType.ResetEvent.class, event -> this.selectedBlocks.clear());
    }

    public Displayable hover() {
        return this.hover;
    }

    void rebuild() {
        this.currentCategory = Category.turret;
        Group group = this.toggler.parent;
        int index = this.toggler.getZIndex();
        this.toggler.remove();
        this.build(group);
        this.toggler.setZIndex(index);
    }

    boolean gridUpdate(InputHandler input) {
        this.scrollPositions.put(this.currentCategory, this.blockPane.getScrollY());
        if (Core.input.keyTap(Binding.pick) && Vars.player.isBuilder()) {
            ConstructBlock.ConstructBuild c;
            Object object;
            Building build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            Block tryRecipe = build == null ? null : ((object = build) instanceof ConstructBlock.ConstructBuild && (c = (ConstructBlock.ConstructBuild)object) == (ConstructBlock.ConstructBuild)object ? c.cblock : build.block);
            Object tryConfig = build == null || !build.block.copyConfig ? null : build.config();
            for (BuildPlan req : Vars.player.unit().plans()) {
                if (req.breaking || !req.block.bounds(req.x, req.y, Tmp.r1).contains(Core.input.mouseWorld())) continue;
                tryRecipe = req.block;
                tryConfig = req.config;
                break;
            }
            if (tryRecipe != null && tryRecipe.isVisible() && this.unlocked(tryRecipe)) {
                input.block = tryRecipe;
                tryRecipe.lastConfig = tryConfig;
                this.currentCategory = input.block.category;
                return true;
            }
        }
        if (Vars.ui.chatfrag.shown() || Core.scene.hasKeyboard()) {
            return false;
        }
        for (int i = 0; i < this.blockSelect.length; ++i) {
            Seq<Block> blocks;
            if (!Core.input.keyTap(this.blockSelect[i])) continue;
            if (i > 9) {
                blocks = this.getUnlockedByCategory(this.currentCategory);
                Block currentBlock = this.getSelectedBlock(this.currentCategory);
                for (int j = 0; j < blocks.size; ++j) {
                    if (blocks.get(j) != currentBlock) continue;
                    switch (i) {
                        case 10: {
                            j = (j - 1 + blocks.size) % blocks.size;
                            break;
                        }
                        case 11: {
                            j = (j + 1) % blocks.size;
                            break;
                        }
                        case 12: {
                            j = j > 3 ? j - 4 : blocks.size - blocks.size % 4 + j;
                            j -= j < blocks.size ? 0 : 4;
                            break;
                        }
                        case 13: {
                            j = j < blocks.size - 4 ? j + 4 : j % 4;
                        }
                    }
                    input.block = blocks.get(j);
                    this.selectedBlocks.put(this.currentCategory, input.block);
                    break;
                }
            } else if (this.blockSelectEnd || Time.timeSinceMillis(this.blockSelectSeqMillis) > 400L) {
                if (!this.getUnlockedByCategory(Category.all[i]).isEmpty()) {
                    this.currentCategory = Category.all[i];
                    if (input.block != null) {
                        input.block = this.getSelectedBlock(this.currentCategory);
                    }
                    this.blockSelectEnd = false;
                    this.blockSelectSeq = 0;
                    this.blockSelectSeqMillis = Time.millis();
                }
            } else {
                if (this.blockSelectSeq == 0) {
                    this.blockSelectSeq = i + 1;
                } else {
                    i += (this.blockSelectSeq - (i != 9 ? 0 : 1)) * 10;
                    this.blockSelectEnd = true;
                }
                blocks = this.getByCategory(this.currentCategory);
                if (i >= blocks.size || !this.unlocked(blocks.get(i))) {
                    return true;
                }
                input.block = i < blocks.size ? blocks.get(i) : null;
                this.selectedBlocks.put(this.currentCategory, input.block);
                this.blockSelectSeqMillis = Time.millis();
            }
            return true;
        }
        if (Core.input.keyTap(Binding.category_prev)) {
            do {
                this.currentCategory = this.currentCategory.prev();
            } while (this.categoryEmpty[this.currentCategory.ordinal()]);
            input.block = this.getSelectedBlock(this.currentCategory);
            return true;
        }
        if (Core.input.keyTap(Binding.category_next)) {
            do {
                this.currentCategory = this.currentCategory.next();
            } while (this.categoryEmpty[this.currentCategory.ordinal()]);
            input.block = this.getSelectedBlock(this.currentCategory);
            return true;
        }
        if (Core.input.keyTap(Binding.block_info)) {
            Block displayBlock;
            Block block = displayBlock = this.menuHoverBlock != null ? this.menuHoverBlock : input.block;
            if (displayBlock != null) {
                Vars.ui.content.show(displayBlock);
                Events.fire(new EventType.BlockInfoEvent());
            }
        }
        return false;
    }

    @Override
    public void build(Group parent) {
        parent.fill(full -> {
            this.toggler = full;
            full.bottom().right().visible(() -> Vars.ui.hudfrag.shown);
            full.table(frame -> {
                Runnable rebuildCategory = () -> {
                    this.blockTable.clear();
                    this.blockTable.top().margin(5.0f);
                    int index = 0;
                    ButtonGroup group = new ButtonGroup();
                    group.setMinCheckCount(0);
                    for (Block block : this.getUnlockedByCategory(this.currentCategory)) {
                        if (!this.unlocked(block)) continue;
                        if (index++ % 4 == 0) {
                            this.blockTable.row();
                        }
                        ImageButton button = this.blockTable.button((Drawable)new TextureRegionDrawable(block.icon(Cicon.medium)), Styles.selecti, () -> {
                            if (this.unlocked(block)) {
                                if (Core.input.keyDown(KeyCode.shiftLeft) && Fonts.getUnicode(block.name) != 0) {
                                    Core.app.setClipboardText((char)Fonts.getUnicode(block.name) + "");
                                    Vars.ui.showInfoFade("@copied");
                                } else {
                                    Vars.control.input.block = Vars.control.input.block == block ? null : block;
                                    this.selectedBlocks.put(this.currentCategory, Vars.control.input.block);
                                }
                            }
                        }).size(46.0f).group(group).name("block-" + block.name).get();
                        button.resizeImage(Cicon.medium.size);
                        button.update(() -> {
                            CoreBlock.CoreBuild core = Vars.player.core();
                            Color color = (Vars.state.rules.infiniteResources || core != null && (core.items.has(block.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources)) && Vars.player.isBuilder() ? Color.white : Color.gray;
                            button.forEach(elem -> elem.setColor(color));
                            button.setChecked(Vars.control.input.block == block);
                            if (!block.isPlaceable()) {
                                button.forEach(elem -> elem.setColor(Color.darkGray));
                            }
                        });
                        button.hovered(() -> {
                            this.menuHoverBlock = block;
                        });
                        button.exited(() -> {
                            if (this.menuHoverBlock == block) {
                                this.menuHoverBlock = null;
                            }
                        });
                    }
                    if (index < 4) {
                        for (int i = 0; i < 4 - index; ++i) {
                            this.blockTable.add().size(46.0f);
                        }
                    }
                    this.blockTable.act(0.0f);
                    this.blockPane.setScrollYForce(this.scrollPositions.get(this.currentCategory, 0.0f));
                    Core.app.post(() -> {
                        this.blockPane.setScrollYForce(this.scrollPositions.get(this.currentCategory, 0.0f));
                        this.blockPane.act(0.0f);
                        this.blockPane.layout();
                    });
                };
                frame.table(Tex.buttonEdge2, top -> {
                    this.topTable = top;
                    top.add(new Table()).growX().update(topTable -> {
                        boolean isHovered;
                        Displayable hovered = this.hover;
                        Block displayBlock = this.menuHoverBlock != null ? this.menuHoverBlock : Vars.control.input.block;
                        Object displayState = displayBlock != null ? displayBlock : hovered;
                        boolean bl = isHovered = displayBlock == null;
                        if (this.wasHovered == isHovered && this.lastDisplayState == displayState) {
                            return;
                        }
                        topTable.clear();
                        topTable.top().left().margin(5.0f);
                        this.lastDisplayState = displayState;
                        this.wasHovered = isHovered;
                        if (displayBlock != null) {
                            topTable.table(header -> {
                                String keyCombo = "";
                                if (!Vars.mobile) {
                                    Seq<Block> blocks = this.getByCategory(this.currentCategory);
                                    for (int i = 0; i < blocks.size; ++i) {
                                        if (blocks.get(i) != displayBlock || (i + 1) / 10 - 1 >= this.blockSelect.length) continue;
                                        keyCombo = Core.bundle.format("placement.blockselectkeys", Core.keybinds.get((KeyBinds.KeyBind)this.blockSelect[this.currentCategory.ordinal()]).key.toString()) + (i < 10 ? "" : Core.keybinds.get((KeyBinds.KeyBind)this.blockSelect[(i + 1) / 10 - 1]).key.toString() + ",") + Core.keybinds.get((KeyBinds.KeyBind)this.blockSelect[i % 10]).key.toString() + "]";
                                        break;
                                    }
                                }
                                String keyComboFinal = keyCombo;
                                header.left();
                                header.add(new Image(displayBlock.icon(Cicon.medium))).size(32.0f);
                                header.labelWrap(() -> !this.unlocked(displayBlock) ? Core.bundle.get("block.unknown") : displayBlock.localizedName + keyComboFinal).left().width(190.0f).padLeft(5.0f);
                                header.add().growX();
                                if (this.unlocked(displayBlock)) {
                                    header.button("?", Styles.clearPartialt, () -> {
                                        Vars.ui.content.show(displayBlock);
                                        Events.fire(new EventType.BlockInfoEvent());
                                    }).size(40.0f).padTop(-5.0f).padRight(-5.0f).right().grow().name("blockinfo");
                                }
                            }).growX().left();
                            topTable.row();
                            topTable.table(req -> {
                                req.top().left();
                                for (ItemStack stack : displayBlock.requirements) {
                                    req.table(line -> {
                                        line.left();
                                        line.image(stack.item.icon(Cicon.small)).size(16.0f);
                                        line.add(stack.item.localizedName).maxWidth(140.0f).fillX().color(Color.lightGray).padLeft(2.0f).left().get().setEllipsis(true);
                                        line.labelWrap(() -> {
                                            int stackamount;
                                            CoreBlock.CoreBuild core = Vars.player.core();
                                            if (core == null || Vars.state.rules.infiniteResources) {
                                                return "*/*";
                                            }
                                            int amount = core.items.get(stack.item);
                                            String color = (float)amount < (float)(stackamount = Math.round((float)stack.amount * Vars.state.rules.buildCostMultiplier)) / 2.0f ? "[scarlet]" : (amount < stackamount ? "[accent]" : "[white]");
                                            return color + UI.formatAmount(amount) + "[white]/" + stackamount;
                                        }).padLeft(5.0f);
                                    }).left();
                                    req.row();
                                }
                            }).growX().left().margin(3.0f);
                            if (!displayBlock.isPlaceable() || !Vars.player.isBuilder()) {
                                topTable.row();
                                topTable.table(b -> {
                                    b.image(Icon.cancel).padRight(2.0f).color(Color.scarlet);
                                    b.add(!Vars.player.isBuilder() ? "@unit.nobuild" : "@banned").width(190.0f).wrap();
                                    b.left();
                                }).padTop(2.0f).left();
                            }
                        } else if (hovered != null) {
                            hovered.display((Table)topTable);
                        }
                    });
                }).colspan(3).fillX().visible(this::hasInfoBox).touchable(Touchable.enabled);
                frame.row();
                frame.image().color(Pal.gray).colspan(3).height(4.0f).growX();
                frame.row();
                frame.table(Tex.pane2, blocksSelect -> {
                    blocksSelect.margin(4.0f).marginTop(0.0f);
                    this.blockPane = blocksSelect.pane(blocks -> {
                        this.blockTable = blocks;
                    }).height(194.0f).update(pane -> {
                        Element result;
                        if (pane.hasScroll() && ((result = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true)) == null || !result.isDescendantOf((Element)pane))) {
                            Core.scene.setScrollFocus(null);
                        }
                    }).grow().get();
                    this.blockPane.setStyle(Styles.smallPane);
                    blocksSelect.row();
                    blocksSelect.table(Vars.control.input::buildPlacementUI).name("inputTable").growX();
                }).fillY().bottom().touchable(Touchable.enabled);
                frame.table(categories -> {
                    categories.bottom();
                    categories.add(new Image(Styles.black6){

                        @Override
                        public void draw() {
                            if (this.height <= Scl.scl(3.0f)) {
                                return;
                            }
                            this.getDrawable().draw(this.x, this.y, this.width, this.height - Scl.scl(3.0f));
                        }
                    }).colspan(2).growX().growY().padTop(-3.0f).row();
                    categories.defaults().size(50.0f);
                    ButtonGroup group = new ButtonGroup();
                    for (Category cat : Category.all) {
                        Seq<Block> blocks = this.getUnlockedByCategory(cat);
                        this.categoryEmpty[cat.ordinal()] = blocks.isEmpty();
                    }
                    int f = 0;
                    for (Category cat : this.getCategories()) {
                        if (f++ % 2 == 0) {
                            categories.row();
                        }
                        if (this.categoryEmpty[cat.ordinal()]) {
                            categories.image(Styles.black6);
                            continue;
                        }
                        categories.button((Drawable)Vars.ui.getIcon(cat.name()), Styles.clearToggleTransi, () -> {
                            this.currentCategory = cat;
                            if (Vars.control.input.block != null) {
                                Vars.control.input.block = this.getSelectedBlock(this.currentCategory);
                            }
                            rebuildCategory.run();
                        }).group(group).update(i -> i.setChecked(this.currentCategory == cat)).name("category-" + cat.name());
                    }
                }).fillY().bottom().touchable(Touchable.enabled);
                rebuildCategory.run();
                frame.update(() -> {
                    if (this.gridUpdate(Vars.control.input)) {
                        rebuildCategory.run();
                    }
                });
            });
        });
    }

    Seq<Category> getCategories() {
        return this.returnCatArray.clear().addAll((Category[])Category.all).sort((c1, c2) -> Boolean.compare(this.categoryEmpty[c1.ordinal()], this.categoryEmpty[c2.ordinal()]));
    }

    Seq<Block> getByCategory(Category cat) {
        return this.returnArray.selectFrom(Vars.content.blocks(), block -> block.category == cat && block.isVisible());
    }

    Seq<Block> getUnlockedByCategory(Category cat) {
        return this.returnArray2.selectFrom(Vars.content.blocks(), block -> block.category == cat && block.isVisible() && this.unlocked((Block)block)).sort((b1, b2) -> Boolean.compare(!b1.isPlaceable(), !b2.isPlaceable()));
    }

    Block getSelectedBlock(Category cat) {
        return (Block)((Object)this.selectedBlocks.get(cat, (Block)((Object)((Prov<Block>)() -> this.getByCategory(cat).find(this::unlocked)))));
    }

    boolean unlocked(Block block) {
        return block.unlockedNow();
    }

    boolean hasInfoBox() {
        this.hover = this.hovered();
        return Vars.control.input.block != null || this.menuHoverBlock != null || this.hover != null;
    }

    @Nullable
    Displayable hovered() {
        Vec2 v = this.topTable.stageToLocalCoordinates(Core.input.mouse());
        if (Core.scene.hasMouse() || this.topTable.hit(v.x, v.y, false) != null) {
            return null;
        }
        Unit unit = Units.closestOverlap(Vars.player.team(), Core.input.mouseWorldX(), Core.input.mouseWorldY(), 5.0f, u -> !u.isLocal());
        if (unit != null) {
            return unit;
        }
        Tile hoverTile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (hoverTile != null) {
            if (hoverTile.build != null) {
                hoverTile.build.updateFlow = true;
                return hoverTile.build;
            }
            if (hoverTile.drop() != null) {
                return hoverTile;
            }
        }
        return null;
    }
}

