/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Styles;
import mindustry.ui.fragments.Fragment;

public class PlayerListFragment
extends Fragment {
    public Table content = new Table().marginRight(13.0f).marginLeft(13.0f);
    private boolean visible = false;
    private Interval timer = new Interval();
    private TextField sField;
    private Seq<Player> players = new Seq();

    @Override
    public void build(Group parent) {
        this.content.name = "players";
        parent.fill(cont -> {
            cont.name = "playerlist";
            cont.visible(() -> this.visible);
            cont.update(() -> {
                if (!Vars.net.active() || !Vars.state.isGame()) {
                    this.visible = false;
                    return;
                }
                if (this.visible && this.timer.get(20.0f)) {
                    this.rebuild();
                    this.content.pack();
                    this.content.act(Core.graphics.getDeltaTime());
                    Core.scene.act(0.0f);
                }
            });
            cont.table(Tex.buttonTrans, pane -> {
                pane.label(() -> Core.bundle.format(Groups.player.size() == 1 ? "players.single" : "players", Groups.player.size()));
                pane.row();
                this.sField = pane.field(null, text -> this.rebuild()).grow().pad(8.0f).get();
                this.sField.name = "search";
                this.sField.setMaxLength(40);
                this.sField.setMessageText(Core.bundle.format("players.search", new Object[0]));
                pane.row();
                pane.pane(this.content).grow().get().setScrollingDisabled(true, false);
                pane.row();
                pane.table(menu -> {
                    menu.defaults().growX().height(50.0f).fillY();
                    menu.name = "menu";
                    menu.button("@server.bans", Vars.ui.bans::show).disabled(b -> Vars.net.client());
                    menu.button("@server.admins", Vars.ui.admins::show).disabled(b -> Vars.net.client());
                    menu.button("@close", this::toggle);
                }).margin(0.0f).pad(10.0f).growX();
            }).touchable(Touchable.enabled).margin(14.0f).minWidth(360.0f);
        });
        this.rebuild();
    }

    public void rebuild() {
        this.content.clear();
        float h = 74.0f;
        boolean found = false;
        this.players.clear();
        Groups.player.copy(this.players);
        this.players.sort(Structs.comps(Structs.comparing(Player::team), Structs.comparingBool(p -> !p.admin)));
        for (Player user : this.players) {
            found = true;
            NetConnection connection = user.con;
            if (connection == null && Vars.net.server() && !user.isLocal()) {
                return;
            }
            if (this.sField.getText().length() > 0 && !user.name().toLowerCase().contains(this.sField.getText().toLowerCase()) && !Strings.stripColors(user.name().toLowerCase()).contains(this.sField.getText().toLowerCase())) {
                return;
            }
            Table button = new Table();
            button.left();
            button.margin(5.0f).marginBottom(10.0f);
            Table table = new Table(){

                @Override
                public void draw() {
                    super.draw();
                    Draw.color(Pal.gray);
                    Draw.alpha(this.parentAlpha);
                    Lines.stroke(Scl.scl(4.0f));
                    Lines.rect(this.x, this.y, this.width, this.height);
                    Draw.reset();
                }
            };
            table.margin(8.0f);
            table.add(new Image(user.icon()).setScaling(Scaling.bounded)).grow();
            table.name = user.name();
            button.add(table).size(h);
            button.labelWrap("[#" + user.color().toString().toUpperCase() + "]" + user.name()).width(170.0f).pad(10.0f);
            button.add().grow();
            button.image(Icon.admin).visible(() -> user.admin && (user.isLocal() || !Vars.net.server())).padRight(5.0f).get().updateVisibility();
            if (!(!Vars.net.server() && !Vars.player.admin || user.isLocal() || user.admin && !Vars.net.server())) {
                button.add().growY();
                float bs = h / 2.0f;
                button.table(t -> {
                    t.defaults().size(bs);
                    t.button((Drawable)Icon.hammer, Styles.clearPartiali, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmban", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.ban)));
                    t.button((Drawable)Icon.cancel, Styles.clearPartiali, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmkick", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.kick)));
                    t.row();
                    t.button((Drawable)Icon.admin, Styles.clearTogglePartiali, () -> {
                        if (Vars.net.client()) {
                            return;
                        }
                        String id = user.uuid();
                        if (Vars.netServer.admins.isAdmin(id, connection.address)) {
                            Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmunadmin", user.name()), () -> Vars.netServer.admins.unAdminPlayer(id));
                        } else {
                            Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmadmin", user.name()), () -> Vars.netServer.admins.adminPlayer(id, user.usid()));
                        }
                    }).update(b -> b.setChecked(user.admin)).disabled(b -> Vars.net.client()).touchable(() -> Vars.net.client() ? Touchable.disabled : Touchable.enabled).checked(user.admin);
                    t.button((Drawable)Icon.zoom, Styles.clearPartiali, () -> Call.adminRequest(user, Packets.AdminAction.trace));
                }).padRight(12.0f).size(bs + 10.0f, bs);
            } else if (!user.isLocal() && !user.admin && Vars.net.client() && Groups.player.size() >= 3 && Vars.player.team() == user.team()) {
                button.add().growY();
                button.button((Drawable)Icon.hammer, Styles.clearPartiali, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmvotekick", user.name()), () -> Call.sendChatMessage("/votekick " + user.name()))).size(h);
            }
            this.content.add(button).padBottom(-6.0f).width(350.0f).maxHeight(h + 14.0f);
            this.content.row();
            this.content.image().height(4.0f).color(Vars.state.rules.pvp ? user.team().color : Pal.gray).growX();
            this.content.row();
        }
        if (!found) {
            this.content.add(Core.bundle.format("players.notfound", new Object[0])).padBottom(6.0f).width(350.0f).maxHeight(h + 14.0f);
        }
        this.content.marginBottom(5.0f);
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (this.visible) {
            this.rebuild();
        } else {
            Core.scene.setKeyboardFocus(null);
            this.sField.clearText();
        }
    }
}

