/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Input;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.scene.Group;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.input.Binding;
import mindustry.ui.Fonts;
import mindustry.ui.fragments.Fragment;

public class ScriptConsoleFragment
extends Table {
    private static final int messagesShown = 30;
    private Seq<String> messages = new Seq();
    private boolean open = false;
    private boolean shown;
    private TextField chatfield;
    private Label fieldlabel = new Label(">");
    private Font font;
    private GlyphLayout layout = new GlyphLayout();
    private float offsetx = Scl.scl(4.0f);
    private float offsety = Scl.scl(4.0f);
    private float fontoffsetx = Scl.scl(2.0f);
    private float chatspace = Scl.scl(50.0f);
    private Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private float textspacing = Scl.scl(10.0f);
    private Seq<String> history = new Seq();
    private int historyPos = 0;
    private int scrollPos = 0;
    private Fragment container = new Fragment(){

        @Override
        public void build(Group parent) {
            Core.scene.add(ScriptConsoleFragment.this);
        }
    };

    public ScriptConsoleFragment() {
        this.setFillParent(true);
        this.font = Fonts.def;
        this.visible(() -> {
            if (Core.input.keyTap(Binding.console) && (Core.scene.getKeyboardFocus() == this.chatfield || Core.scene.getKeyboardFocus() == null) && !Vars.ui.chatfrag.shown()) {
                boolean bl = this.shown = !this.shown;
                if (this.shown && !this.open && Vars.enableConsole) {
                    this.toggle();
                }
                this.clearChatInput();
            }
            return this.shown;
        });
        this.update(() -> {
            if (Core.input.keyTap(Binding.chat) && Vars.enableConsole && (Core.scene.getKeyboardFocus() == this.chatfield || Core.scene.getKeyboardFocus() == null)) {
                this.toggle();
            }
            if (this.open) {
                if (Core.input.keyTap(Binding.chat_history_prev) && this.historyPos < this.history.size - 1) {
                    if (this.historyPos == 0) {
                        this.history.set(0, this.chatfield.getText());
                    }
                    ++this.historyPos;
                    this.updateChat();
                }
                if (Core.input.keyTap(Binding.chat_history_next) && this.historyPos > 0) {
                    --this.historyPos;
                    this.updateChat();
                }
            }
            this.scrollPos = (int)Mathf.clamp((float)this.scrollPos + Core.input.axis(Binding.chat_scroll), 0.0f, (float)Math.max(0, this.messages.size - 30));
        });
        this.history.insert(0, "");
        this.setup();
    }

    public Fragment container() {
        return this.container;
    }

    public void clearMessages() {
        this.messages.clear();
        this.history.clear();
        this.history.insert(0, "");
    }

    private void setup() {
        this.fieldlabel.setStyle(new Label.LabelStyle(this.fieldlabel.getStyle()));
        this.fieldlabel.getStyle().font = this.font;
        this.fieldlabel.setStyle(this.fieldlabel.getStyle());
        this.chatfield = new TextField("", new TextField.TextFieldStyle(Core.scene.getStyle(TextField.TextFieldStyle.class)));
        this.chatfield.getStyle().background = null;
        this.chatfield.getStyle().font = Fonts.chat;
        this.chatfield.getStyle().fontColor = Color.white;
        this.chatfield.setStyle(this.chatfield.getStyle());
        this.bottom().left().marginBottom(this.offsety).marginLeft(this.offsetx * 2.0f).add(this.fieldlabel).padBottom(6.0f);
        this.add(this.chatfield).padBottom(this.offsety).padLeft(this.offsetx).growX().padRight(this.offsetx).height(28.0f);
    }

    @Override
    public void draw() {
        float opacity = 1.0f;
        float textWidth = (float)Core.graphics.getWidth() - this.offsetx * 2.0f;
        Draw.color(this.shadowColor);
        if (this.open) {
            Fill.crect(this.offsetx, this.chatfield.y + Core.scene.marginBottom, this.chatfield.getWidth() + 15.0f, this.chatfield.getHeight() - 1.0f);
        }
        super.draw();
        float spacing = this.chatspace;
        this.chatfield.visible = this.open;
        this.fieldlabel.visible = this.open;
        Draw.color(this.shadowColor);
        Draw.alpha(this.shadowColor.a * opacity);
        float theight = this.offsety + spacing + this.getMarginBottom() + Core.scene.marginBottom;
        for (int i = this.scrollPos; i < this.messages.size && i < 30 + this.scrollPos; ++i) {
            this.layout.setText(this.font, this.messages.get(i), Color.white, textWidth, 12, true);
            theight += this.layout.height + this.textspacing;
            if (i - this.scrollPos == 0) {
                theight -= this.textspacing + 1.0f;
            }
            this.font.getCache().clear();
            this.font.getCache().addText(this.messages.get(i), this.fontoffsetx + this.offsetx, this.offsety + theight, textWidth, 12, true);
            if (!this.open) {
                this.font.getCache().setAlphas(opacity);
                Draw.color(0.0f, 0.0f, 0.0f, this.shadowColor.a * opacity);
            } else {
                this.font.getCache().setAlphas(opacity);
            }
            Fill.crect(this.offsetx, theight - this.layout.height - 2.0f, textWidth + Scl.scl(4.0f), this.layout.height + this.textspacing);
            Draw.color(this.shadowColor);
            Draw.alpha(opacity * this.shadowColor.a);
            this.font.getCache().draw();
        }
        Draw.color();
    }

    private void sendMessage() {
        String message = this.chatfield.getText();
        this.clearChatInput();
        if (message.replace(" ", "").isEmpty()) {
            return;
        }
        if (message.equals("clear")) {
            this.clearMessages();
            return;
        }
        this.history.insert(1, message);
        this.addMessage("[lightgray]> " + message.replace("[", "[["));
        this.addMessage(Vars.mods.getScripts().runConsole(message).replace("[", "[["));
    }

    public void toggle() {
        if (!this.open) {
            Core.scene.setKeyboardFocus(this.chatfield);
            boolean bl = this.open = !this.open;
            if (Vars.mobile) {
                Input.TextInput input = new Input.TextInput();
                input.accepted = text -> {
                    this.chatfield.setText((String)text);
                    this.sendMessage();
                    this.hide();
                    Core.input.setOnscreenKeyboardVisible(false);
                };
                input.canceled = this::hide;
                Core.input.getTextInput(input);
            } else {
                this.chatfield.fireClick();
            }
        } else {
            Core.scene.setKeyboardFocus(null);
            this.open = !this.open;
            this.scrollPos = 0;
            this.sendMessage();
        }
    }

    public void hide() {
        Core.scene.setKeyboardFocus(null);
        this.open = false;
        this.clearChatInput();
    }

    public void updateChat() {
        this.chatfield.setText(this.history.get(this.historyPos));
        this.chatfield.setCursorPosition(this.chatfield.getText().length());
    }

    public void clearChatInput() {
        this.historyPos = 0;
        this.history.set(0, "");
        this.chatfield.setText("");
    }

    public boolean open() {
        return this.open;
    }

    public boolean shown() {
        return this.shown;
    }

    public void addMessage(String message) {
        this.messages.insert(0, message);
    }
}

