/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.layout;

import arc.math.geom.Rect;
import arc.struct.FloatSeq;
import mindustry.ui.layout.TreeLayout;

public class BranchTreeLayout
implements TreeLayout {
    public TreeLocation rootLocation = TreeLocation.top;
    public TreeAlignment alignment = TreeAlignment.awayFromRoot;
    public float gapBetweenLevels = 10.0f;
    public float gapBetweenNodes = 10.0f;
    private final FloatSeq sizeOfLevel = new FloatSeq();
    private float boundsLeft = Float.MAX_VALUE;
    private float boundsRight = Float.MIN_VALUE;
    private float boundsTop = Float.MAX_VALUE;
    private float boundsBottom = Float.MIN_VALUE;

    @Override
    public void layout(TreeLayout.TreeNode root) {
        this.firstWalk(root, null);
        this.calcSizeOfLevels(root, 0);
        this.secondWalk(root, -root.prelim, 0, 0.0f);
    }

    private float getWidthOrHeightOfNode(TreeLayout.TreeNode treeNode, boolean returnWidth) {
        return returnWidth ? treeNode.width : treeNode.height;
    }

    private float getNodeThickness(TreeLayout.TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, !this.isLevelChangeInYAxis());
    }

    private float getNodeSize(TreeLayout.TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, this.isLevelChangeInYAxis());
    }

    private boolean isLevelChangeInYAxis() {
        return this.rootLocation == TreeLocation.top || this.rootLocation == TreeLocation.bottom;
    }

    private int getLevelChangeSign() {
        return this.rootLocation == TreeLocation.bottom || this.rootLocation == TreeLocation.right ? -1 : 1;
    }

    private void updateBounds(TreeLayout.TreeNode node, float centerX, float centerY) {
        float width = node.width;
        float height = node.height;
        float left = centerX - width / 2.0f;
        float right = centerX + width / 2.0f;
        float top = centerY - height / 2.0f;
        float bottom = centerY + height / 2.0f;
        if (this.boundsLeft > left) {
            this.boundsLeft = left;
        }
        if (this.boundsRight < right) {
            this.boundsRight = right;
        }
        if (this.boundsTop > top) {
            this.boundsTop = top;
        }
        if (this.boundsBottom < bottom) {
            this.boundsBottom = bottom;
        }
    }

    public Rect getBounds() {
        return new Rect(this.boundsLeft, this.boundsBottom, this.boundsRight - this.boundsLeft, this.boundsTop - this.boundsBottom);
    }

    private void calcSizeOfLevels(TreeLayout.TreeNode node, int level) {
        float oldSize;
        if (this.sizeOfLevel.size <= level) {
            this.sizeOfLevel.add(0.0f);
            oldSize = 0.0f;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        float size = this.getNodeThickness(node);
        if (oldSize < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!node.isLeaf()) {
            for (Object child : node.children) {
                this.calcSizeOfLevels((TreeLayout.TreeNode)child, level + 1);
            }
        }
    }

    public int getLevelCount() {
        return this.sizeOfLevel.size;
    }

    public float getGapBetweenNodes(TreeLayout.TreeNode a, TreeLayout.TreeNode b) {
        return this.gapBetweenNodes;
    }

    public float getSizeOfLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be >= 0");
        }
        if (level >= this.getLevelCount()) {
            throw new IllegalArgumentException("level must be < levelCount");
        }
        return this.sizeOfLevel.get(level);
    }

    private TreeLayout.TreeNode getAncestor(TreeLayout.TreeNode node) {
        return node.ancestor != null ? node.ancestor : node;
    }

    private float getDistance(TreeLayout.TreeNode v, TreeLayout.TreeNode w) {
        float sizeOfNodes = this.getNodeSize(v) + this.getNodeSize(w);
        return sizeOfNodes / 2.0f + this.getGapBetweenNodes(v, w);
    }

    private TreeLayout.TreeNode nextLeft(TreeLayout.TreeNode v) {
        return v.isLeaf() ? v.thread : v.children[0];
    }

    private TreeLayout.TreeNode nextRight(TreeLayout.TreeNode v) {
        return v.isLeaf() ? v.thread : v.children[v.children.length - 1];
    }

    private int getNumber(TreeLayout.TreeNode node, TreeLayout.TreeNode parentNode) {
        if (node.number == -1) {
            int number = 1;
            for (Object child : parentNode.children) {
                ((TreeLayout.TreeNode)child).number = number++;
            }
        }
        return node.number;
    }

    private TreeLayout.TreeNode ancestor(TreeLayout.TreeNode vIMinus, TreeLayout.TreeNode parentOfV, TreeLayout.TreeNode defaultAncestor) {
        TreeLayout.TreeNode ancestor = this.getAncestor(vIMinus);
        return ancestor.parent == parentOfV ? ancestor : defaultAncestor;
    }

    private void moveSubtree(TreeLayout.TreeNode wMinus, TreeLayout.TreeNode wPlus, TreeLayout.TreeNode parent, float shift) {
        int subtrees = this.getNumber(wPlus, parent) - this.getNumber(wMinus, parent);
        wPlus.change -= shift / (float)subtrees;
        wPlus.shift += shift;
        wMinus.change += shift / (float)subtrees;
        wPlus.prelim += shift;
        wPlus.mode += shift;
    }

    private TreeLayout.TreeNode apportion(TreeLayout.TreeNode v, TreeLayout.TreeNode defaultAncestor, TreeLayout.TreeNode leftSibling, TreeLayout.TreeNode parentOfV) {
        if (leftSibling == null) {
            return defaultAncestor;
        }
        TreeLayout.TreeNode vOPlus = v;
        TreeLayout.TreeNode vIPlus = v;
        TreeLayout.TreeNode vIMinus = leftSibling;
        Object vOMinus = parentOfV.children[0];
        float sIPlus = vIPlus.mode;
        float sOPlus = vOPlus.mode;
        float sIMinus = vIMinus.mode;
        float sOMinus = ((TreeLayout.TreeNode)vOMinus).mode;
        TreeLayout.TreeNode nextRightVIMinus = this.nextRight(vIMinus);
        TreeLayout.TreeNode nextLeftVIPlus = this.nextLeft(vIPlus);
        while (nextRightVIMinus != null && nextLeftVIPlus != null) {
            vIMinus = nextRightVIMinus;
            vIPlus = nextLeftVIPlus;
            vOMinus = this.nextLeft((TreeLayout.TreeNode)vOMinus);
            vOPlus = this.nextRight(vOPlus);
            vOPlus.ancestor = v;
            float shift = vIMinus.prelim + sIMinus - (vIPlus.prelim + sIPlus) + this.getDistance(vIMinus, vIPlus);
            if (shift > 0.0f) {
                this.moveSubtree(this.ancestor(vIMinus, parentOfV, defaultAncestor), v, parentOfV, shift);
                sIPlus += shift;
                sOPlus += shift;
            }
            sIMinus += vIMinus.mode;
            sIPlus += vIPlus.mode;
            sOMinus += ((TreeLayout.TreeNode)vOMinus).mode;
            sOPlus += vOPlus.mode;
            nextRightVIMinus = this.nextRight(vIMinus);
            nextLeftVIPlus = this.nextLeft(vIPlus);
        }
        if (nextRightVIMinus != null && this.nextRight(vOPlus) == null) {
            vOPlus.thread = nextRightVIMinus;
            vOPlus.mode += sIMinus - sOPlus;
        }
        if (nextLeftVIPlus != null && this.nextLeft((TreeLayout.TreeNode)vOMinus) == null) {
            ((TreeLayout.TreeNode)vOMinus).thread = nextLeftVIPlus;
            ((TreeLayout.TreeNode)vOMinus).mode += sIPlus - sOMinus;
            defaultAncestor = v;
        }
        return defaultAncestor;
    }

    private void executeShifts(TreeLayout.TreeNode v) {
        float shift = 0.0f;
        float change = 0.0f;
        for (int i = v.children.length - 1; i >= 0; --i) {
            Object w = v.children[i];
            ((TreeLayout.TreeNode)w).prelim += shift;
            ((TreeLayout.TreeNode)w).mode += shift;
            shift += ((TreeLayout.TreeNode)w).shift + (change += ((TreeLayout.TreeNode)w).change);
        }
    }

    private void firstWalk(TreeLayout.TreeNode v, TreeLayout.TreeNode leftSibling) {
        if (v.isLeaf()) {
            if (leftSibling != null) {
                v.prelim = leftSibling.prelim + this.getDistance(v, leftSibling);
            }
        } else {
            Object defaultAncestor = v.children[0];
            TreeLayout.TreeNode previousChild = null;
            for (Object w : v.children) {
                this.firstWalk((TreeLayout.TreeNode)w, previousChild);
                defaultAncestor = this.apportion((TreeLayout.TreeNode)w, (TreeLayout.TreeNode)defaultAncestor, previousChild, v);
                previousChild = (TreeLayout.TreeNode)w;
            }
            this.executeShifts(v);
            float midpoint = (((TreeLayout.TreeNode)v.children[0]).prelim + ((TreeLayout.TreeNode)v.children[v.children.length - 1]).prelim) / 2.0f;
            if (leftSibling != null) {
                v.prelim = leftSibling.prelim + this.getDistance(v, leftSibling);
                v.mode = v.prelim - midpoint;
            } else {
                v.prelim = midpoint;
            }
        }
    }

    private void secondWalk(TreeLayout.TreeNode v, float m, int level, float levelStart) {
        float levelChangeSign = this.getLevelChangeSign();
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        float levelSize = this.getSizeOfLevel(level);
        float x = v.prelim + m;
        float y = this.alignment == TreeAlignment.center ? levelStart + levelChangeSign * (levelSize / 2.0f) : (this.alignment == TreeAlignment.towardsRoot ? levelStart + levelChangeSign * (this.getNodeThickness(v) / 2.0f) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v) / 2.0f));
        if (!levelChangeOnYAxis) {
            float t = x;
            x = y;
            y = t;
        }
        v.x = x;
        v.y = y;
        this.updateBounds(v, x, y);
        if (!v.isLeaf()) {
            float nextLevelStart = levelStart + (levelSize + this.gapBetweenLevels) * levelChangeSign;
            for (Object w : v.children) {
                this.secondWalk((TreeLayout.TreeNode)w, m + v.mode, level + 1, nextLevelStart);
            }
        }
    }

    public static enum TreeLocation {
        top,
        left,
        bottom,
        right;

    }

    public static enum TreeAlignment {
        center,
        towardsRoot,
        awayFromRoot;

    }
}

