/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.layout;

import arc.math.Mathf;
import arc.struct.ObjectSet;
import arc.struct.Queue;
import mindustry.ui.layout.TreeLayout;

public class RadialTreeLayout
implements TreeLayout {
    private static ObjectSet<TreeLayout.TreeNode> visited = new ObjectSet();
    private static Queue<TreeLayout.TreeNode> queue = new Queue();
    public float startRadius;
    public float delta;

    @Override
    public void layout(TreeLayout.TreeNode root) {
        this.startRadius = root.height * 2.4f;
        this.delta = root.height * 20.4f;
        this.bfs(root, true);
        ObjectSet all = new ObjectSet(visited);
        for (TreeLayout.TreeNode node : all) {
            node.leaves = this.bfs(node, false);
        }
        this.radialize(root, this.startRadius, 0.0f, 360.0f);
    }

    void radialize(TreeLayout.TreeNode root, float radius, float from, float to) {
        float angle = from;
        for (Object child : root.children) {
            float nextAngle = angle + (float)((TreeLayout.TreeNode)child).leaves / (float)root.leaves * (to - from);
            float x = radius * Mathf.cos((angle + nextAngle) / 2.0f * ((float)Math.PI / 180));
            float y = radius * Mathf.sin((angle + nextAngle) / 2.0f * ((float)Math.PI / 180));
            ((TreeLayout.TreeNode)child).x = x;
            ((TreeLayout.TreeNode)child).y = y;
            if (((TreeLayout.TreeNode)child).children.length > 0) {
                this.radialize((TreeLayout.TreeNode)child, radius + this.delta, angle, nextAngle);
            }
            angle = nextAngle;
        }
    }

    int bfs(TreeLayout.TreeNode node, boolean assign) {
        visited.clear();
        queue.clear();
        if (assign) {
            node.number = 0;
        }
        int leaves = 0;
        visited.add(node);
        queue.addFirst(node);
        while (!queue.isEmpty()) {
            TreeLayout.TreeNode current = queue.removeFirst();
            if (current.children.length == 0) {
                ++leaves;
            }
            for (Object child : current.children) {
                if (assign) {
                    ((TreeLayout.TreeNode)child).number = current.number + 1;
                }
                if (!visited.add((TreeLayout.TreeNode)child)) continue;
                queue.addLast((TreeLayout.TreeNode)child);
            }
        }
        return leaves;
    }
}

