/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Func;
import arc.func.Intc2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Scl;
import arc.struct.EnumSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.pooling.Pools;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.TargetPriority;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.ContentRegions;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.consumers.Consumers;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockBars;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.values.ItemListValue;

public class Block
extends UnlockableContent {
    public boolean hasItems;
    public boolean hasLiquids;
    public boolean hasPower;
    public boolean outputsLiquid = false;
    public boolean consumesPower = true;
    public boolean outputsPower = false;
    public boolean outputsPayload = false;
    public boolean outputFacing = true;
    public boolean acceptsItems = false;
    public int itemCapacity = 10;
    public float liquidCapacity = 10.0f;
    public float liquidPressure = 1.0f;
    public final BlockBars bars = new BlockBars();
    public final Consumers consumes = new Consumers();
    public boolean displayFlow = true;
    public boolean inEditor = true;
    @Nullable
    public Object lastConfig;
    public boolean saveConfig = false;
    public boolean copyConfig = true;
    public boolean update;
    public boolean destructible;
    public boolean unloadable = true;
    public boolean solid;
    public boolean solidifes;
    public boolean rotate;
    public boolean saveData;
    public boolean breakable;
    public boolean rebuildable = true;
    public boolean requiresWater = false;
    public boolean placeableLiquid = false;
    public boolean placeableOn = true;
    public boolean insulated = false;
    public boolean squareSprite = true;
    public boolean absorbLasers = false;
    public boolean enableDrawStatus = true;
    public boolean drawDisabled = true;
    public boolean autoResetEnabled = true;
    public boolean noUpdateDisabled = false;
    public boolean useColor = true;
    public int health = -1;
    public float baseExplosiveness = 0.0f;
    public boolean floating = false;
    public int size = 1;
    public float offset = 0.0f;
    public boolean expanded = false;
    public int timers = 0;
    public CacheLayer cacheLayer = CacheLayer.normal;
    public boolean fillsTile = true;
    public boolean alwaysReplace = false;
    public boolean replaceable = true;
    public BlockGroup group = BlockGroup.none;
    public EnumSet<BlockFlag> flags = EnumSet.of((Enum[])new BlockFlag[0]);
    public TargetPriority priority = TargetPriority.base;
    public int unitCapModifier = 0;
    public boolean configurable;
    public boolean logicConfigurable = false;
    public boolean consumesTap;
    public boolean drawLiquidLight = true;
    public boolean sync;
    public boolean conveyorPlacement;
    public boolean swapDiagonalPlacement;
    public int schematicPriority = 0;
    public Color mapColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public boolean hasColor = false;
    public boolean targetable = true;
    public boolean canOverdrive = true;
    public Color outlineColor = Color.valueOf("404049");
    public boolean outlineIcon = false;
    public int outlinedIcon = -1;
    public boolean hasShadow = true;
    public Sound breakSound = Sounds.boom;
    public float albedo = 0.0f;
    public Color lightColor = Color.white.cpy();
    public boolean emitLight = false;
    public float lightRadius = 60.0f;
    public Sound loopSound = Sounds.none;
    public float loopSoundVolume = 0.5f;
    public Sound ambientSound = Sounds.none;
    public float ambientSoundVolume = 0.05f;
    public ItemStack[] requirements = new ItemStack[0];
    public Category category = Category.distribution;
    public float buildCost;
    public BuildVisibility buildVisibility = BuildVisibility.hidden;
    public float buildCostMultiplier = 1.0f;
    public float deconstructThreshold = 0.0f;
    public float researchCostMultiplier = 1.0f;
    public boolean instantTransfer = false;
    public boolean quickRotate = true;
    @Nullable
    public Class<?> subclass;
    public Prov<Building> buildType = null;
    public ObjectMap<Class<?>, Cons2> configurations = new ObjectMap();
    protected TextureRegion[] generatedIcons;
    protected TextureRegion[] variantRegions;
    protected TextureRegion[] editorVariantRegions;
    public TextureRegion region;
    public TextureRegion editorIcon;
    public TextureRegion teamRegion;
    public TextureRegion[] teamRegions;
    protected static final Seq<Tile> tempTiles = new Seq();
    protected static final Seq<Building> tempTileEnts = new Seq();
    protected final int timerDump = this.timers++;
    protected final int dumpTime = 5;

    public Block(String name) {
        super(name);
        this.initBuilding();
    }

    public void drawBase(Tile tile) {
        if (tile.build != null) {
            tile.build.draw();
        } else {
            Draw.rect(this.region, tile.drawx(), tile.drawy());
        }
    }

    public float percentSolid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return 0.0f;
        }
        return tile.getLinkedTilesAs(this, tempTiles).sumf(other -> !other.floor().isLiquid ? 1.0f : 0.0f) / (float)this.size / (float)this.size;
    }

    public void drawEnvironmentLight(Tile tile) {
        Drawf.light(tile.worldx(), tile.worldy(), this.lightRadius, this.lightColor, this.lightColor.a);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
    }

    public void drawPotentialLinks(int x, int y) {
        Tile tile;
        if ((this.consumesPower || this.outputsPower) && this.hasPower && (tile = Vars.world.tile(x, y)) != null) {
            PowerNode.getNodeLinks(tile, this, Vars.player.team(), other -> {
                PowerNode node = (PowerNode)other.block;
                Draw.color(node.laserColor1, Renderer.laserOpacity * 0.5f);
                node.drawLaser(tile.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size);
                Drawf.square(other.x, other.y, (float)(other.block.size * 8) / 2.0f + 2.0f, Pal.place);
            });
        }
    }

    public float drawPlaceText(String text, int x, int y, boolean valid) {
        if (Vars.renderer.pixelator.enabled()) {
            return 0.0f;
        }
        Color color = valid ? Pal.accent : Pal.remove;
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        layout.setText(font, text);
        float width = layout.width;
        font.setColor(color);
        float dx = (float)(x * 8) + this.offset;
        float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 3.0f;
        font.draw(text, dx, dy + layout.height + 1.0f, 1);
        Lines.stroke(2.0f, Color.darkGray);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy -= 1.0f, dx + layout.width / 2.0f + 1.5f, dy);
        Lines.stroke(1.0f, color);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy, dx + layout.width / 2.0f + 1.5f, dy);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
        return width;
    }

    public float sumAttribute(@Nullable Attribute attr, int x, int y) {
        if (attr == null) {
            return 0.0f;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return 0.0f;
        }
        return tile.getLinkedTilesAs(this, tempTiles).sumf(other -> !this.floating && other.floor().isDeep() ? 0.0f : other.floor().attributes.get(attr));
    }

    public TextureRegion getDisplayIcon(Tile tile) {
        return tile.build == null ? this.icon(Cicon.medium) : tile.build.getDisplayIcon();
    }

    public String getDisplayName(Tile tile) {
        return tile.build == null ? this.localizedName : tile.build.getDisplayName();
    }

    public int minimapColor(Tile tile) {
        return 0;
    }

    public boolean outputsItems() {
        return this.hasItems;
    }

    public boolean canPlaceOn(Tile tile, Team team) {
        return true;
    }

    public boolean canBreak(Tile tile) {
        return true;
    }

    public boolean rotatedOutput(int x, int y) {
        return this.rotate;
    }

    public boolean synthetic() {
        return this.update || this.destructible;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.size, "@x@", this.size, this.size);
        if (this.synthetic()) {
            this.stats.add(Stat.health, this.health, StatUnit.none);
        }
        if (this.canBeBuilt()) {
            this.stats.add(Stat.buildTime, this.buildCost / 60.0f, StatUnit.seconds);
            this.stats.add(Stat.buildCost, new ItemListValue(false, this.requirements));
        }
        if (this.instantTransfer) {
            this.stats.add(Stat.maxConsecutive, 2.0f, StatUnit.none);
        }
        this.consumes.display(this.stats);
        if (this.hasLiquids) {
            this.stats.add(Stat.liquidCapacity, this.liquidCapacity, StatUnit.liquidUnits);
        }
        if (this.hasItems && this.itemCapacity > 0) {
            this.stats.add(Stat.itemCapacity, this.itemCapacity, StatUnit.items);
        }
    }

    public void setBars() {
        this.bars.add("health", entity -> new Bar("stat.health", Pal.health, entity::healthf).blink(Color.white));
        if (this.hasLiquids) {
            Func<Building, Liquid> current;
            if (this.consumes.has(ConsumeType.liquid) && this.consumes.get(ConsumeType.liquid) instanceof ConsumeLiquid) {
                Liquid liquid = ((ConsumeLiquid)this.consumes.get((ConsumeType)ConsumeType.liquid)).liquid;
                current = entity -> liquid;
            } else {
                current = entity -> entity.liquids == null ? Liquids.water : entity.liquids.current();
            }
            this.bars.add("liquid", entity -> new Bar(() -> entity.liquids.get((Liquid)current.get((Building)entity)) <= 0.001f ? Core.bundle.get("bar.liquid") : ((Liquid)current.get(entity)).localizedName, () -> ((Liquid)current.get((Building)entity)).barColor(), () -> entity == null || entity.liquids == null ? 0.0f : entity.liquids.get((Liquid)current.get((Building)entity)) / this.liquidCapacity));
        }
        if (this.hasPower && this.consumes.hasPower()) {
            ConsumePower cons = this.consumes.getPower();
            boolean buffered = cons.buffered;
            float capacity = cons.capacity;
            this.bars.add("power", entity -> new Bar(() -> buffered ? Core.bundle.format("bar.poweramount", Float.isNaN(entity.power.status * capacity) ? "<ERROR>" : Integer.valueOf((int)(entity.power.status * capacity))) : Core.bundle.get("bar.power"), () -> Pal.powerBar, () -> Mathf.zero(cons.requestedPower((Building)entity)) && entity.power.graph.getPowerProduced() + entity.power.graph.getBatteryStored() > 0.0f ? 1.0f : entity.power.status));
        }
        if (this.hasItems && this.configurable) {
            this.bars.add("items", entity -> new Bar(() -> Core.bundle.format("bar.items", entity.items.total()), () -> Pal.items, () -> (float)entity.items.total() / (float)this.itemCapacity));
        }
        if (this.flags.contains(BlockFlag.unitModifier)) {
            this.stats.add(Stat.maxUnits, (this.unitCapModifier < 0 ? "-" : "+") + Math.abs(this.unitCapModifier), new Object[0]);
        }
    }

    public boolean canReplace(Block other) {
        if (other.alwaysReplace) {
            return true;
        }
        return other.replaceable && (other != this || this.rotate) && this.group != BlockGroup.none && other.group == this.group && (this.size == other.size || this.size >= other.size && (this.subclass != null && this.subclass == other.subclass || this.group.anyReplace));
    }

    public Block getReplacement(BuildPlan req, Seq<BuildPlan> requests) {
        return this;
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
    }

    public void handlePlacementLine(Seq<BuildPlan> plans) {
    }

    public Object nextConfig() {
        if (this.saveConfig && this.lastConfig != null) {
            return this.lastConfig;
        }
        return null;
    }

    public void onNewPlan(BuildPlan plan) {
    }

    public void drawPlan(BuildPlan req, Eachable<BuildPlan> list, boolean valid) {
        this.drawPlan(req, list, valid, 1.0f);
    }

    public void drawPlan(BuildPlan req, Eachable<BuildPlan> list, boolean valid, float alpha) {
        Draw.reset();
        Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
        Draw.alpha(alpha);
        float prevScale = Draw.scl;
        Draw.scl *= req.animScale;
        this.drawRequestRegion(req, list);
        Draw.scl = prevScale;
        Draw.reset();
    }

    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        TextureRegion reg = this.getRequestRegion(req, list);
        Draw.rect(reg, req.drawx(), req.drawy(), !this.rotate ? 0.0f : (float)(req.rotation * 90));
        if (req.worldContext && Vars.player != null && this.teamRegion != null && this.teamRegion.found()) {
            if (this.teamRegions[Vars.player.team().id] == this.teamRegion) {
                Draw.color(Vars.player.team().color);
            }
            Draw.rect(this.teamRegions[Vars.player.team().id], req.drawx(), req.drawy());
            Draw.color();
        }
        this.drawRequestConfig(req, list);
    }

    public TextureRegion getRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        return this.icon(Cicon.full);
    }

    public void drawRequestConfig(BuildPlan req, Eachable<BuildPlan> list) {
    }

    public void drawRequestConfigCenter(BuildPlan req, Object content, String region, boolean cross) {
        Liquid l;
        Color color;
        Item i;
        if (content == null) {
            if (cross) {
                Draw.rect("cross", req.drawx(), req.drawy());
            }
            return;
        }
        Object object = content;
        Color color2 = object instanceof Item && (i = (Item)object) == (Item)object ? i.color : (color = (object = content) instanceof Liquid && (l = (Liquid)object) == (Liquid)object ? l.color : null);
        if (color == null) {
            return;
        }
        Draw.color(color);
        Draw.rect(region, req.drawx(), req.drawy());
        Draw.color();
    }

    public void drawRequestConfigCenter(BuildPlan req, Object content, String region) {
        this.drawRequestConfigCenter(req, content, region, false);
    }

    public void drawRequestConfigTop(BuildPlan req, Eachable<BuildPlan> list) {
    }

    public Object pointConfig(Object config, Cons<Point2> transformer) {
        return config;
    }

    public <E extends Building> void configClear(Cons<E> cons) {
        this.configurations.put(Void.TYPE, (tile, value) -> cons.get((Building)tile));
    }

    public <T, E extends Building> void config(Class<T> type, Cons2<E, T> config) {
        this.configurations.put(type, config);
    }

    public boolean isAccessible() {
        return this.hasItems && this.itemCapacity > 0;
    }

    public void iterateTaken(int x, int y, Intc2 placer) {
        if (this.isMultiblock()) {
            int offsetx = -(this.size - 1) / 2;
            int offsety = -(this.size - 1) / 2;
            for (int dx = 0; dx < this.size; ++dx) {
                for (int dy = 0; dy < this.size; ++dy) {
                    placer.get(dx + offsetx + x, dy + offsety + y);
                }
            }
        } else {
            placer.get(x, y);
        }
    }

    public TextureRegion editorIcon() {
        return this.editorIcon == null ? (this.editorIcon = Core.atlas.find(this.name + "-icon-editor")) : this.editorIcon;
    }

    public TextureRegion[] editorVariantRegions() {
        if (this.editorVariantRegions == null) {
            this.variantRegions();
            this.editorVariantRegions = new TextureRegion[this.variantRegions.length];
            for (int i = 0; i < this.variantRegions.length; ++i) {
                TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)this.variantRegions[i];
                this.editorVariantRegions[i] = Core.atlas.find("editor-" + region.name);
            }
        }
        return this.editorVariantRegions;
    }

    protected TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.teamRegion.found() && this.minfo.mod == null) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[2];
            textureRegionArray2[0] = this.region;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[1] = this.teamRegions[Team.sharded.id];
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[1];
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[0] = this.region;
        }
        return textureRegionArray;
    }

    public TextureRegion[] getGeneratedIcons() {
        TextureRegion[] textureRegionArray;
        if (this.generatedIcons == null) {
            this.generatedIcons = this.icons();
            textureRegionArray = this.generatedIcons;
        } else {
            textureRegionArray = this.generatedIcons;
        }
        return textureRegionArray;
    }

    public TextureRegion[] variantRegions() {
        TextureRegion[] textureRegionArray;
        if (this.variantRegions == null) {
            this.variantRegions = new TextureRegion[]{this.icon(Cicon.full)};
            textureRegionArray = this.variantRegions;
        } else {
            textureRegionArray = this.variantRegions;
        }
        return textureRegionArray;
    }

    public boolean hasBuilding() {
        return this.destructible || this.update;
    }

    public final Building newBuilding() {
        return this.buildType.get();
    }

    public Rect bounds(int x, int y, Rect rect) {
        return rect.setSize(this.size * 8).setCenter((float)(x * 8) + this.offset, (float)(y * 8) + this.offset);
    }

    public boolean isMultiblock() {
        return this.size > 1;
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    public boolean isPlaceable() {
        return this.isVisible() && !Vars.state.rules.bannedBlocks.contains(this);
    }

    public void placeBegan(Tile tile, Block previous) {
    }

    public void beforePlaceBegan(Tile tile, Block previous) {
    }

    public boolean isFloor() {
        return this instanceof Floor;
    }

    public boolean isOverlay() {
        return this instanceof OverlayFloor;
    }

    public Floor asFloor() {
        return (Floor)this;
    }

    public boolean isAir() {
        return this.id == 0;
    }

    public boolean canBeBuilt() {
        return this.buildVisibility != BuildVisibility.hidden && this.buildVisibility != BuildVisibility.debugOnly;
    }

    public boolean isStatic() {
        return this.cacheLayer == CacheLayer.walls;
    }

    public void setupRequirements(Category cat, ItemStack[] stacks) {
        this.requirements(cat, stacks);
    }

    public void setupRequirements(Category cat, BuildVisibility visible, ItemStack[] stacks) {
        this.requirements(cat, visible, stacks);
    }

    public void requirements(Category cat, ItemStack[] stacks, boolean unlocked) {
        this.requirements(cat, BuildVisibility.shown, stacks);
        this.alwaysUnlocked = unlocked;
    }

    public void requirements(Category cat, ItemStack[] stacks) {
        this.requirements(cat, BuildVisibility.shown, stacks);
    }

    public void requirements(Category cat, BuildVisibility visible, ItemStack[] stacks) {
        this.category = cat;
        this.requirements = stacks;
        this.buildVisibility = visible;
        Arrays.sort(this.requirements, Structs.comparingInt(i -> i.item.id));
    }

    protected void initBuilding() {
        try {
            Class<?> current = this.getClass();
            if (current.isAnonymousClass()) {
                current = current.getSuperclass();
            }
            this.subclass = current;
            while (this.buildType == null && Block.class.isAssignableFrom(current)) {
                Class type = Structs.find(current.getDeclaredClasses(), t -> Building.class.isAssignableFrom((Class<?>)t) && !t.isInterface());
                if (type != null) {
                    Constructor cons = type.getDeclaredConstructor(type.getDeclaringClass());
                    this.buildType = () -> {
                        try {
                            return (Building)cons.newInstance(this);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                current = current.getSuperclass();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.buildType == null) {
            this.buildType = Building::create;
        }
    }

    @Override
    public ItemStack[] researchRequirements() {
        ItemStack[] out = new ItemStack[this.requirements.length];
        for (int i = 0; i < out.length; ++i) {
            int quantity = 60 + Mathf.round(Mathf.pow((float)this.requirements[i].amount, 1.1f) * 20.0f * this.researchCostMultiplier, 10);
            out[i] = new ItemStack(this.requirements[i].item, UI.roundAmount(quantity));
        }
        return out;
    }

    @Override
    public void getDependencies(Cons<UnlockableContent> cons) {
        for (ItemStack stack : this.requirements) {
            cons.get(stack.item);
        }
        this.consumes.each(c -> {
            ConsumeItems i;
            if (c.isOptional()) {
                return;
            }
            ItemStack[] i$temp = c;
            if (i$temp instanceof ConsumeItems && (i = (ConsumeItems)i$temp) == (ConsumeItems)i$temp) {
                for (ItemStack stack : i.items) {
                    cons.get(stack.item);
                }
            } else {
                ConsumeLiquid i2;
                i$temp = c;
                if (i$temp instanceof ConsumeLiquid && (i2 = (ConsumeLiquid)i$temp) == (ConsumeLiquid)i$temp) {
                    cons.get(i2.liquid);
                }
            }
        });
    }

    @Override
    public ContentType getContentType() {
        return ContentType.block;
    }

    @Override
    public void init() {
        if (this.health == -1) {
            this.health = this.size * this.size * 40;
        }
        if (this.group == BlockGroup.transportation || this.consumes.has(ConsumeType.item) || this.category == Category.distribution) {
            this.acceptsItems = true;
        }
        this.offset = (float)((this.size + 1) % 2 * 8) / 2.0f;
        this.buildCost = 0.0f;
        for (ItemStack stack : this.requirements) {
            this.buildCost += (float)stack.amount * stack.item.cost;
        }
        this.buildCost *= this.buildCostMultiplier;
        if (this.consumes.has(ConsumeType.power)) {
            this.hasPower = true;
        }
        if (this.consumes.has(ConsumeType.item)) {
            this.hasItems = true;
        }
        if (this.consumes.has(ConsumeType.liquid)) {
            this.hasLiquids = true;
        }
        this.setBars();
        this.stats.useCategories = true;
        this.consumes.init();
        if (!this.logicConfigurable) {
            this.configurations.each((key, val) -> {
                if (UnlockableContent.class.isAssignableFrom((Class<?>)key)) {
                    this.logicConfigurable = true;
                }
            });
        }
        if (!this.outputsPower && this.consumes.hasPower() && this.consumes.getPower().buffered) {
            throw new IllegalArgumentException("Consumer using buffered power: " + this.name);
        }
    }

    @Override
    public void load() {
        this.region = Core.atlas.find(this.name);
        ContentRegions.loadRegions(this);
        this.teamRegions = new TextureRegion[Team.all.length];
        for (Team team : Team.all) {
            this.teamRegions[team.id] = this.teamRegion.found() ? Core.atlas.find(this.name + "-team-" + team.name, this.teamRegion) : this.teamRegion;
        }
    }

    @Override
    public boolean isHidden() {
        return !this.buildVisibility.visible() && !Vars.state.rules.revealedBlocks.contains(this);
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        packer.add(MultiPacker.PageType.editor, this.name + "-icon-editor", Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icon(Cicon.full)));
        if (!this.synthetic()) {
            PixmapRegion image = Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icon(Cicon.full));
            this.mapColor.set(image.getPixel(image.width / 2, image.height / 2));
        }
        this.getGeneratedIcons();
        Pixmap last = null;
        if (this.outlineIcon) {
            int radius = 4;
            PixmapRegion region = Core.atlas.getPixmap(this.getGeneratedIcons()[this.outlinedIcon >= 0 ? this.outlinedIcon : this.getGeneratedIcons().length - 1]);
            Pixmap out = new Pixmap(region.width, region.height);
            Color color = new Color();
            for (int x = 0; x < region.width; ++x) {
                for (int y = 0; y < region.height; ++y) {
                    region.getPixel(x, y, color);
                    out.draw(x, y, color);
                    if (!(color.a < 1.0f)) continue;
                    boolean found = false;
                    block2: for (int rx = -4; rx <= 4; ++rx) {
                        for (int ry = -4; ry <= 4; ++ry) {
                            if (!Structs.inBounds(rx + x, ry + y, region.width, region.height) || !Mathf.within(rx, ry, 4.0f) || !(color.set((int)region.getPixel((int)(rx + x), (int)(ry + y))).a > 0.01f)) continue;
                            found = true;
                            break block2;
                        }
                    }
                    if (!found) continue;
                    out.draw(x, y, this.outlineColor);
                }
            }
            last = out;
            packer.add(MultiPacker.PageType.main, this.name, out);
        }
        if (this.generatedIcons.length > 1) {
            Pixmap base = Core.atlas.getPixmap(this.generatedIcons[0]).crop();
            for (int i = 1; i < this.generatedIcons.length; ++i) {
                if (i == this.generatedIcons.length - 1 && last != null) {
                    base.drawPixmap(last);
                    continue;
                }
                base.draw(Core.atlas.getPixmap(this.generatedIcons[i]));
            }
            packer.add(MultiPacker.PageType.main, "block-" + this.name + "-full", base);
            this.generatedIcons = null;
            Arrays.fill(this.cicons, null);
        }
    }
}

