/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.Core;
import arc.Events;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;

public class Build {
    private static final IntSet tmp = new IntSet();

    public static void beginBreak(@Nullable Unit unit, Team team, int x, int y) {
        if (!Build.validBreak(team, x, y)) {
            return;
        }
        Tile tile = Vars.world.tileBuilding(x, y);
        float prevPercent = 1.0f;
        if (tile.build != null) {
            prevPercent = tile.build.healthf();
        }
        int rotation = tile.build != null ? tile.build.rotation : 0;
        Block previous = tile.block();
        ConstructBlock sub = ConstructBlock.get(previous.size);
        Seq<Building> prevBuild = new Seq<Building>(1);
        if (tile.build != null) {
            prevBuild.add(tile.build);
        }
        tile.setBlock(sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setDeconstruct(previous);
        build.prevBuild = prevBuild;
        tile.build.health = tile.build.maxHealth * prevPercent;
        if (unit != null && unit.getControllerName() != null) {
            tile.build.lastAccessed = unit.getControllerName();
        }
        Core.app.post(() -> Events.fire(new EventType.BlockBuildBeginEvent(tile, team, unit, true)));
    }

    public static void beginPlace(@Nullable Unit unit, Block result, Team team, int x, int y, int rotation) {
        if (!Build.validPlace(result, team, x, y, rotation)) {
            return;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        if (tile.team() == team && tile.block == result && tile.build != null && tile.block.quickRotate) {
            if (unit != null && unit.getControllerName() != null) {
                tile.build.lastAccessed = unit.getControllerName();
            }
            tile.build.rotation = Mathf.mod(rotation, 4);
            tile.build.updateProximity();
            tile.build.noSleep();
            Fx.rotateBlock.at(tile.build.x, tile.build.y, tile.build.block.size);
            return;
        }
        Block previous = tile.block();
        ConstructBlock sub = ConstructBlock.get(result.size);
        Seq prevBuild = new Seq(9);
        result.beforePlaceBegan(tile, previous);
        tmp.clear();
        tile.getLinkedTilesAs(result, t -> {
            if (t.build != null && t.build.team == team && tmp.add(t.build.id)) {
                prevBuild.add(t.build);
            }
        });
        tile.setBlock(sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setConstruct(previous.size == sub.size ? previous : Blocks.air, result);
        build.prevBuild = prevBuild;
        if (unit != null && unit.getControllerName() != null) {
            build.lastAccessed = unit.getControllerName();
        }
        result.placeBegan(tile, previous);
        Core.app.post(() -> Events.fire(new EventType.BlockBuildBeginEvent(tile, team, unit, false)));
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation) {
        return Build.validPlace(type, team, x, y, rotation, true);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation, boolean checkVisible) {
        if (type == null || checkVisible && !type.isPlaceable() && (!Vars.state.rules.waves || team != Vars.state.rules.waveTeam || !type.isVisible())) {
            return false;
        }
        if ((type.solid || type.solidifes) && Units.anyEntities((float)(x * 8) + type.offset - (float)(type.size * 8) / 2.0f, (float)(y * 8) + type.offset - (float)(type.size * 8) / 2.0f, type.size * 8, type.size * 8)) {
            return false;
        }
        if (Vars.state.teams.eachEnemyCore(team, core -> Mathf.dst((float)(x * 8) + type.offset, (float)(y * 8) + type.offset, core.x, core.y) < Vars.state.rules.enemyCoreBuildRadius + (float)(type.size * 8) / 2.0f)) {
            return false;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return false;
        }
        if (Vars.world.getDarkness(x, y) >= 3.0f) {
            return false;
        }
        if (!(type.requiresWater || Build.contactsShallows(tile.x, tile.y, type) || type.placeableLiquid)) {
            return false;
        }
        if (!type.canPlaceOn(tile, team)) {
            return false;
        }
        int offsetx = -(type.size - 1) / 2;
        int offsety = -(type.size - 1) / 2;
        for (int dx = 0; dx < type.size; ++dx) {
            for (int dy = 0; dy < type.size; ++dy) {
                ConstructBlock.ConstructBuild build;
                Building building;
                int wx = dx + offsetx + tile.x;
                int wy = dy + offsety + tile.y;
                Tile check = Vars.world.tile(wx, wy);
                if (!(check == null || check.floor().isDeep() && !type.floating && !type.requiresWater && !type.placeableLiquid || type == check.block() && check.build != null && rotation == check.build.rotation && type.rotate || !check.interactable(team) || !check.floor().placeableOn || !checkVisible && !check.block().alwaysReplace || !type.canReplace(check.block()) && (!((building = check.build) instanceof ConstructBlock.ConstructBuild) || (build = (ConstructBlock.ConstructBuild)building) != (ConstructBlock.ConstructBuild)building || build.cblock != type || check.centerX() != tile.x || check.centerY() != tile.y) || !type.bounds(tile.x, tile.y, Tmp.r1).grow(0.01f).contains(check.block.bounds(check.centerX(), check.centerY(), Tmp.r2))) && (!type.requiresWater || check.floor().liquidDrop == Liquids.water)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean contactsGround(int x, int y, Block block) {
        if (block.isMultiblock()) {
            for (Point2 point : Edges.getEdges(block.size)) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contactsShallows(int x, int y, Block block) {
        if (block.isMultiblock()) {
            Tile tile;
            for (Point2 point : Edges.getInsideEdges(block.size)) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            for (Point2 point : Edges.getEdges(block.size)) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            Tile tile = Vars.world.tile(x, y);
            return tile != null && !tile.floor().isDeep();
        }
        return false;
    }

    public static boolean validBreak(Team team, int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return tile != null && tile.block().canBreak(tile) && tile.breakable() && tile.interactable(team);
    }
}

