/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.util.Pack;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.type.Item;

public class ItemBuffer {
    private long[] buffer;
    private int index;

    public ItemBuffer(int capacity) {
        this.buffer = new long[capacity];
    }

    public boolean accepts() {
        return this.index < this.buffer.length;
    }

    public void accept(Item item, short data) {
        this.buffer[this.index++] = Pack.longInt(Float.floatToIntBits(Time.time), Pack.shortInt(item.id, data));
    }

    public void accept(Item item) {
        this.accept(item, (short)-1);
    }

    public Item poll(float speed) {
        long l;
        float time;
        if (this.index > 0 && (Time.time >= (time = Float.intBitsToFloat(Pack.leftInt(l = this.buffer[0]))) + speed || Time.time < time)) {
            return Vars.content.item(Pack.leftShort(Pack.rightInt(l)));
        }
        return null;
    }

    public void remove() {
        System.arraycopy(this.buffer, 1, this.buffer, 0, this.index - 1);
        --this.index;
    }

    public void write(Writes write) {
        write.b((byte)this.index);
        write.b((byte)this.buffer.length);
        for (long l : this.buffer) {
            write.l(l);
        }
    }

    public void read(Reads read) {
        this.index = read.b();
        int length = read.b();
        for (int i = 0; i < length; ++i) {
            long l = read.l();
            if (i >= this.buffer.length) continue;
            this.buffer[i] = l;
        }
        this.index = Math.min(this.index, length - 1);
    }
}

