/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.func.Cons;
import arc.func.Intc2;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.type.Item;
import mindustry.ui.Displayable;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.blocks.environment.Floor;

public class Tile
implements Position,
QuadTree.QuadTreeObject,
Displayable {
    static final ObjectSet<Building> tileSet = new ObjectSet();
    public byte data;
    @Nullable
    public Building build;
    public short x;
    public short y;
    protected Block block;
    protected Floor floor;
    protected Floor overlay;
    protected boolean changing = false;

    public Tile(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
        this.floor = this.overlay = (Floor)Blocks.air;
        this.block = this.overlay;
    }

    public Tile(int x, int y, Block floor, Block overlay, Block wall) {
        this.x = (short)x;
        this.y = (short)y;
        this.floor = (Floor)floor;
        this.overlay = (Floor)overlay;
        this.block = wall;
        this.changeBuild(Team.derelict, wall::newBuilding, 0);
        this.changed();
    }

    public Tile(int x, int y, int floor, int overlay, int wall) {
        this(x, y, Vars.content.block(floor), Vars.content.block(overlay), Vars.content.block(wall));
    }

    public int pos() {
        return Point2.pack(this.x, this.y);
    }

    public byte relativeTo(Tile tile) {
        return this.relativeTo(tile.x, tile.y);
    }

    public byte relativeTo(int cx, int cy) {
        if (this.x == cx && this.y == cy - 1) {
            return 1;
        }
        if (this.x == cx && this.y == cy + 1) {
            return 3;
        }
        if (this.x == cx - 1 && this.y == cy) {
            return 0;
        }
        if (this.x == cx + 1 && this.y == cy) {
            return 2;
        }
        return -1;
    }

    public static byte relativeTo(int x, int y, int cx, int cy) {
        if (x == cx && y == cy - 1) {
            return 1;
        }
        if (x == cx && y == cy + 1) {
            return 3;
        }
        if (x == cx - 1 && y == cy) {
            return 0;
        }
        if (x == cx + 1 && y == cy) {
            return 2;
        }
        return -1;
    }

    public byte absoluteRelativeTo(int cx, int cy) {
        if (this.block.size % 2 == 1) {
            if (Math.abs(this.x - cx) > Math.abs(this.y - cy)) {
                if (this.x <= cx - 1) {
                    return 0;
                }
                if (this.x >= cx + 1) {
                    return 2;
                }
            } else {
                if (this.y <= cy - 1) {
                    return 1;
                }
                if (this.y >= cy + 1) {
                    return 3;
                }
            }
        } else if (Math.abs((float)(this.x - cx) + 0.5f) > Math.abs((float)(this.y - cy) + 0.5f)) {
            if ((float)this.x + 0.5f <= (float)(cx - 1)) {
                return 0;
            }
            if ((float)this.x + 0.5f >= (float)(cx + 1)) {
                return 2;
            }
        } else {
            if ((float)this.y + 0.5f <= (float)(cy - 1)) {
                return 1;
            }
            if ((float)this.y + 0.5f >= (float)(cy + 1)) {
                return 3;
            }
        }
        return -1;
    }

    public float getFlammability() {
        if (!this.block.hasItems) {
            if (this.floor.liquidDrop != null && !this.block.solid) {
                return this.floor.liquidDrop.flammability;
            }
            return 0.0f;
        }
        if (this.build != null) {
            float result = this.build.items.sum((item, amount) -> item.flammability * (float)amount);
            if (this.block.hasLiquids) {
                result += this.build.liquids.sum((liquid, amount) -> liquid.flammability * amount / 3.0f);
            }
            return result;
        }
        return 0.0f;
    }

    public float worldx() {
        return this.x * 8;
    }

    public float worldy() {
        return this.y * 8;
    }

    public float drawx() {
        return this.block().offset + this.worldx();
    }

    public float drawy() {
        return this.block().offset + this.worldy();
    }

    public boolean isDarkened() {
        return this.block.solid && !this.block.synthetic() && this.block.fillsTile;
    }

    public Floor floor() {
        return this.floor;
    }

    public Block block() {
        return this.block;
    }

    public Floor overlay() {
        return this.overlay;
    }

    public <T extends Block> T cblock() {
        return (T)this.block;
    }

    public Team team() {
        return this.build == null ? Team.derelict : this.build.team;
    }

    public void setTeam(Team team) {
        if (this.build != null) {
            this.build.team(team);
        }
    }

    public boolean isCenter() {
        return this.build == null || this.build.tile() == this;
    }

    public int centerX() {
        return this.build == null ? this.x : this.build.tile.x;
    }

    public int centerY() {
        return this.build == null ? this.y : this.build.tile.y;
    }

    public int getTeamID() {
        return this.team().id;
    }

    public void setBlock(Block type, Team team, int rotation) {
        this.setBlock(type, team, rotation, type::newBuilding);
    }

    public void setBlock(Block type, Team team, int rotation, Prov<Building> entityprov) {
        this.changing = true;
        if (type.isStatic() || this.block.isStatic()) {
            this.recache();
        }
        this.block = type;
        this.preChanged();
        this.changeBuild(team, entityprov, (byte)Mathf.mod(rotation, 4));
        if (this.build != null) {
            this.build.team(team);
        }
        if (this.block.isMultiblock()) {
            int offsetx = -(this.block.size - 1) / 2;
            int offsety = -(this.block.size - 1) / 2;
            Building entity = this.build;
            Block block = this.block;
            for (int pass = 0; pass < 2; ++pass) {
                for (int dx = 0; dx < block.size; ++dx) {
                    for (int dy = 0; dy < block.size; ++dy) {
                        Tile other;
                        int worldx = dx + offsetx + this.x;
                        int worldy = dy + offsety + this.y;
                        if (worldx == this.x && worldy == this.y || (other = Vars.world.tile(worldx, worldy)) == null) continue;
                        if (pass == 0) {
                            other.setBlock(Blocks.air);
                            continue;
                        }
                        other.build = entity;
                        other.block = block;
                    }
                }
            }
            this.build = entity;
            this.block = block;
        }
        this.changed();
        this.changing = false;
    }

    public void setBlock(Block type, Team team) {
        this.setBlock(type, team, 0);
    }

    public void setBlock(Block type) {
        this.setBlock(type, Team.derelict, 0);
    }

    public void setFloor(Floor type) {
        this.floor = type;
        this.overlay = (Floor)Blocks.air;
        this.recache();
        if (this.build != null) {
            this.build.onProximityUpdate();
        }
    }

    public void setFloorUnder(Floor floor) {
        Floor overlay = this.overlay;
        this.setFloor(floor);
        this.setOverlay(overlay);
    }

    public void setAir() {
        this.setBlock(Blocks.air);
    }

    public void circle(int radius, Intc2 cons) {
        Geometry.circle(this.x, this.y, Vars.world.width(), Vars.world.height(), radius, cons);
    }

    public void circle(int radius, Cons<Tile> cons) {
        this.circle(radius, (int x, int y) -> cons.get(Vars.world.rawTile(x, y)));
    }

    public void recache() {
        if (!Vars.headless && !Vars.world.isGenerating()) {
            Vars.renderer.blocks.floor.recacheTile(this);
            Vars.renderer.minimap.update(this);
            for (int i = 0; i < 8; ++i) {
                Tile other = Vars.world.tile(this.x + Geometry.d8[i].x, this.y + Geometry.d8[i].y);
                if (other == null) continue;
                Vars.renderer.blocks.floor.recacheTile(other);
            }
        }
    }

    public void remove() {
        this.setBlock(Blocks.air);
    }

    public void removeNet() {
        Call.removeTile(this);
    }

    public void setNet(Block block) {
        Call.setTile(this, block, Team.derelict, 0);
    }

    public void setNet(Block block, Team team, int rotation) {
        Call.setTile(this, block, team, rotation);
    }

    public void setFloorNet(Block floor, Block overlay) {
        Call.setFloor(this, floor, overlay);
    }

    public void setFloorNet(Block floor) {
        this.setFloorNet(floor, Blocks.air);
    }

    public short overlayID() {
        return this.overlay.id;
    }

    public short blockID() {
        return this.block.id;
    }

    public short floorID() {
        return this.floor.id;
    }

    public void setOverlayID(short ore) {
        this.setOverlay(Vars.content.block(ore));
    }

    public void setOverlay(Block block) {
        this.overlay = (Floor)block;
        this.recache();
    }

    public void setOverlayQuiet(Block block) {
        this.overlay = (Floor)block;
    }

    public void clearOverlay() {
        this.setOverlayID((short)0);
    }

    public boolean passable() {
        return (!this.floor.solid || this.block != Blocks.air && !this.block.solidifes) && (!this.block.solid || this.block.destructible || this.block.update);
    }

    public boolean synthetic() {
        return this.block.update || this.block.destructible;
    }

    public boolean solid() {
        return this.block.solid || this.floor.solid || this.build != null && this.build.checkSolid();
    }

    public boolean breakable() {
        return this.block.destructible || this.block.breakable || this.block.update;
    }

    public boolean dangerous() {
        return !this.block.solid && (this.floor.isDeep() || this.floor.damageTaken > 0.0f);
    }

    public void getLinkedTiles(Cons<Tile> cons) {
        if (this.block.isMultiblock()) {
            int size = this.block.size;
            int offsetx = -(size - 1) / 2;
            int offsety = -(size - 1) / 2;
            for (int dx = 0; dx < size; ++dx) {
                for (int dy = 0; dy < size; ++dy) {
                    Tile other = Vars.world.tile(this.x + dx + offsetx, this.y + dy + offsety);
                    if (other == null) continue;
                    cons.get(other);
                }
            }
        } else {
            cons.get(this);
        }
    }

    public Seq<Tile> getLinkedTiles(Seq<Tile> tmpArray) {
        tmpArray.clear();
        this.getLinkedTiles(tmpArray::add);
        return tmpArray;
    }

    public Seq<Tile> getLinkedTilesAs(Block block, Seq<Tile> tmpArray) {
        tmpArray.clear();
        this.getLinkedTilesAs(block, tmpArray::add);
        return tmpArray;
    }

    public void getLinkedTilesAs(Block block, Cons<Tile> tmpArray) {
        if (block.isMultiblock()) {
            int offsetx = -(block.size - 1) / 2;
            int offsety = -(block.size - 1) / 2;
            for (int dx = 0; dx < block.size; ++dx) {
                for (int dy = 0; dy < block.size; ++dy) {
                    Tile other = Vars.world.tile(this.x + dx + offsetx, this.y + dy + offsety);
                    if (other == null) continue;
                    tmpArray.get(other);
                }
            }
        } else {
            tmpArray.get(this);
        }
    }

    public Rect getHitbox(Rect rect) {
        return rect.setCentered(this.drawx(), this.drawy(), this.block.size * 8, this.block.size * 8);
    }

    public Rect getBounds(Rect rect) {
        return rect.set((float)(this.x * 8) - 4.0f, (float)(this.y * 8) - 4.0f, 8.0f, 8.0f);
    }

    @Override
    public void hitbox(Rect rect) {
        this.getHitbox(rect);
    }

    public Tile nearby(Point2 relative) {
        return Vars.world.tile(this.x + relative.x, this.y + relative.y);
    }

    public Tile nearby(int dx, int dy) {
        return Vars.world.tile(this.x + dx, this.y + dy);
    }

    public Tile nearby(int rotation) {
        if (rotation == 0) {
            return Vars.world.tile(this.x + 1, this.y);
        }
        if (rotation == 1) {
            return Vars.world.tile(this.x, this.y + 1);
        }
        if (rotation == 2) {
            return Vars.world.tile(this.x - 1, this.y);
        }
        if (rotation == 3) {
            return Vars.world.tile(this.x, this.y - 1);
        }
        return null;
    }

    public Building nearbyBuild(int rotation) {
        if (rotation == 0) {
            return Vars.world.build(this.x + 1, this.y);
        }
        if (rotation == 1) {
            return Vars.world.build(this.x, this.y + 1);
        }
        if (rotation == 2) {
            return Vars.world.build(this.x - 1, this.y);
        }
        if (rotation == 3) {
            return Vars.world.build(this.x, this.y - 1);
        }
        return null;
    }

    public boolean interactable(Team team) {
        return Vars.state.teams.canInteract(team, this.team());
    }

    @Nullable
    public Item drop() {
        return this.overlay == Blocks.air || this.overlay.itemDrop == null ? this.floor.itemDrop : this.overlay.itemDrop;
    }

    public int staticDarkness() {
        return this.block.solid && this.block.fillsTile && !this.block.synthetic() ? (int)this.data : 0;
    }

    public boolean adjacentTo(Tile tile) {
        return this.relativeTo(tile) != -1;
    }

    protected void preChanged() {
        if (this.build != null) {
            this.build.onRemoved();
            this.build.removeFromProximity();
            if (this.build.block.isMultiblock()) {
                int cx = this.build.tileX();
                int cy = this.build.tileY();
                int size = this.build.block.size;
                int offsetx = -(size - 1) / 2;
                int offsety = -(size - 1) / 2;
                for (int dx = 0; dx < size; ++dx) {
                    for (int dy = 0; dy < size; ++dy) {
                        Tile other = Vars.world.tile(cx + dx + offsetx, cy + dy + offsety);
                        if (other == null || other == this) continue;
                        other.build = null;
                        other.block = Blocks.air;
                        other.fireChanged();
                    }
                }
            }
        }
        if (this.block.isStatic()) {
            this.recache();
        }
    }

    protected void changeBuild(Team team, Prov<Building> entityprov, int rotation) {
        if (this.build != null) {
            int size = this.build.block.size;
            this.build.remove();
            this.build = null;
            tileSet.clear();
            for (Point2 edge : Edges.getEdges(size)) {
                Building other = Vars.world.build(this.x + edge.x, this.y + edge.y);
                if (other == null) continue;
                tileSet.add(other);
            }
            for (Building t : tileSet) {
                t.updateProximity();
            }
        }
        if (this.block.hasBuilding()) {
            this.build = entityprov.get().init(this, team, this.block.update && !Vars.state.isEditor(), rotation);
        }
    }

    protected void changed() {
        if (!Vars.world.isGenerating()) {
            if (this.build != null) {
                this.build.updateProximity();
            } else {
                for (Point2 p : Geometry.d4) {
                    Building tile = Vars.world.build(this.x + p.x, this.y + p.y);
                    if (tile == null || tile.tile.changing) continue;
                    tile.onProximityUpdate();
                }
            }
        }
        this.fireChanged();
        if (this.block.isStatic()) {
            this.recache();
        }
    }

    protected void fireChanged() {
        Vars.world.notifyChanged(this);
    }

    @Override
    public void display(Table table) {
        Floor toDisplay = this.overlay.itemDrop != null ? this.overlay : this.floor;
        table.table(t -> {
            t.left();
            t.add(new Image(toDisplay.getDisplayIcon(this))).size(32.0f);
            t.labelWrap(toDisplay.getDisplayName(this)).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
    }

    @Override
    public float getX() {
        return this.drawx();
    }

    @Override
    public float getY() {
        return this.drawy();
    }

    public String toString() {
        return this.floor.name + ":" + this.block.name + ":" + this.overlay + "[" + this.x + "," + this.y + "] entity=" + (this.build == null ? "null" : this.build.getClass().getSimpleName()) + ":" + this.team();
    }

    public static void setFloor(Tile tile, Block floor, Block overlay) {
        tile.setFloor(floor.asFloor());
        tile.setOverlay(overlay);
    }

    public static void removeTile(Tile tile) {
        tile.remove();
    }

    public static void setTile(Tile tile, Block block, Team team, int rotation) {
        tile.setBlock(block, team, rotation);
    }

    public static void setTeam(Building build, Team team) {
        if (build != null) {
            build.team = team;
            Vars.indexer.updateIndices(build.tile);
        }
    }

    public static void tileDamage(Building build, float health) {
        if (build == null) {
            return;
        }
        build.health = health;
        if (build.damaged()) {
            Vars.indexer.notifyTileDamaged(build);
        }
    }

    public static void tileDestroyed(Building build) {
        if (build == null) {
            return;
        }
        build.killed();
    }
}

