/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import java.util.Arrays;
import mindustry.world.meta.Attribute;

public class Attributes
implements Json.JsonSerializable {
    private final float[] arr = new float[Attribute.all.length];

    public void clear() {
        Arrays.fill(this.arr, 0.0f);
    }

    public float get(Attribute attr) {
        return this.arr[attr.ordinal()];
    }

    public void set(Attribute attr, float value) {
        this.arr[attr.ordinal()] = value;
    }

    public void add(Attributes other) {
        for (int i = 0; i < this.arr.length; ++i) {
            int n = i;
            this.arr[n] = this.arr[n] + other.arr[i];
        }
    }

    public void add(Attributes other, float scl) {
        for (int i = 0; i < this.arr.length; ++i) {
            int n = i;
            this.arr[n] = this.arr[n] + other.arr[i] * scl;
        }
    }

    @Override
    public void write(Json json) {
        for (Attribute at : Attribute.all) {
            if (this.arr[at.ordinal()] == 0.0f) continue;
            json.writeValue(at.name(), Float.valueOf(this.arr[at.ordinal()]));
        }
    }

    @Override
    public void read(Json json, JsonValue data) {
        for (Attribute at : Attribute.all) {
            this.arr[at.ordinal()] = data.getFloat(at.name(), 0.0f);
        }
    }
}

