/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.func.Cons;
import arc.func.Prov;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Tex;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;

public class ItemSelection {
    private static float scrollPos = 0.0f;

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer) {
        ItemSelection.buildTable(table, items, holder, consumer, true);
    }

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, boolean closeSelect) {
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table();
        cont.defaults().size(40.0f);
        int i = 0;
        for (UnlockableContent item : items) {
            if (!item.unlockedNow()) continue;
            ImageButton button = cont.button(Tex.whiteui, Styles.clearToggleTransi, 24.0f, () -> {
                if (closeSelect) {
                    Vars.control.input.frag.config.hideConfig();
                }
            }).group(group).get();
            button.changed(() -> consumer.get(button.isChecked() ? item : null));
            button.getStyle().imageUp = new TextureRegionDrawable(item.icon(Cicon.small));
            button.update(() -> button.setChecked(holder.get() == item));
            if (i++ % 4 != 3) continue;
            cont.row();
        }
        if (i % 4 != 0) {
            int remaining = 4 - i % 4;
            for (int j = 0; j < remaining; ++j) {
                cont.image(Styles.black6);
            }
        }
        ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
        pane.setScrollingDisabled(true, false);
        pane.setScrollYForce(scrollPos);
        pane.update(() -> {
            scrollPos = pane.getScrollY();
        });
        pane.setOverscroll(false, false);
        table.add(pane).maxHeight(Scl.scl(200.0f));
    }
}

