/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.campaign;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Icon;
import mindustry.gen.LaunchPayload;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class LaunchPad
extends Block {
    public final int timerLaunch;
    public float launchTime;
    public Sound launchSound;
    public TextureRegion lightRegion;
    public TextureRegion podRegion;
    public Color lightColor;

    public LaunchPad(String name) {
        super(name);
        this.timerLaunch = this.timers++;
        this.launchSound = Sounds.none;
        this.lightColor = Color.valueOf("eab678");
        this.hasItems = true;
        this.solid = true;
        this.update = true;
        this.configurable = true;
        this.drawDisabled = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.launchTime, this.launchTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("items", entity -> new Bar(() -> Core.bundle.format("bar.items", entity.items.total()), () -> Pal.items, () -> (float)entity.items.total() / (float)this.itemCapacity));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    static abstract class LaunchPayloadComp
    implements Drawc,
    Timedc,
    Teamc {
        float x;
        float y;
        Seq<ItemStack> stacks = new Seq();
        transient Interval in = new Interval();

        LaunchPayloadComp() {
        }

        @Override
        public void draw() {
            LaunchPad p;
            float alpha = this.fout(Interp.pow5Out);
            float scale = (1.0f - alpha) * 1.3f + 1.0f;
            float cx = this.cx();
            float cy = this.cy();
            float rotation = this.fin() * (130.0f + Mathf.randomSeedRange(this.id(), 50.0f));
            Draw.z(110.001f);
            Draw.color(Pal.engine);
            float rad = 0.2f + this.fslope();
            Fill.light(cx, cy, 10, 25.0f * (rad + scale - 1.0f), Tmp.c2.set(Pal.engine).a(alpha), Tmp.c1.set(Pal.engine).a(0.0f));
            Draw.alpha(alpha);
            for (int i = 0; i < 4; ++i) {
                Drawf.tri(cx, cy, 6.0f, 40.0f * (rad + scale - 1.0f), (float)i * 90.0f + rotation);
            }
            Draw.color();
            Draw.z(129.0f);
            Block block = this.blockOn();
            TextureAtlas.AtlasRegion region = block instanceof LaunchPad && (p = (LaunchPad)block) == (LaunchPad)block ? p.podRegion : Core.atlas.find("launchpod");
            float rw = (float)region.width * Draw.scl * scale;
            float rh = (float)region.height * Draw.scl * scale;
            Draw.alpha(alpha);
            Draw.rect(region, cx, cy, rw, rh, rotation);
            Tmp.v1.trns(225.0f, this.fin(Interp.pow3In) * 250.0f);
            Draw.z(116.0f);
            Draw.color(0.0f, 0.0f, 0.0f, 0.22f * alpha);
            Draw.rect(region, cx + Tmp.v1.x, cy + Tmp.v1.y, rw, rh, rotation);
            Draw.reset();
        }

        float cx() {
            return this.x + this.fin(Interp.pow2In) * (12.0f + Mathf.randomSeedRange(this.id() + 3, 4.0f));
        }

        float cy() {
            return this.y + this.fin(Interp.pow5In) * (100.0f + Mathf.randomSeedRange(this.id() + 2, 30.0f));
        }

        @Override
        public void update() {
            float r = 3.0f;
            if (this.in.get(4.0f - this.fin() * 2.0f)) {
                Fx.rocketSmoke.at(this.cx() + Mathf.range(r), this.cy() + Mathf.range(r), this.fin());
            }
        }

        @Override
        public void remove() {
            if (!Vars.state.isCampaign()) {
                return;
            }
            Sector destsec = Vars.state.rules.sector.info.getRealDestination();
            if (this.team() == Vars.state.rules.defaultTeam && destsec != null && (destsec != Vars.state.rules.sector || Vars.net.client())) {
                ItemSeq dest = new ItemSeq();
                for (ItemStack stack : this.stacks) {
                    dest.add(stack);
                    Vars.state.rules.sector.info.handleItemExport(stack);
                    Events.fire(new EventType.LaunchItemEvent(stack));
                }
                if (!Vars.net.client()) {
                    destsec.addItems(dest);
                }
            }
        }
    }

    public class LaunchPadBuild
    extends Building {
        @Override
        public Graphics.Cursor getCursor() {
            return !Vars.state.isCampaign() || Vars.net.client() ? Graphics.Cursor.SystemCursor.arrow : super.getCursor();
        }

        @Override
        public float efficiency() {
            return this.power != null && this.block.consumes.has(ConsumeType.power) && !this.block.consumes.getPower().buffered ? this.power.status : 1.0f;
        }

        @Override
        public boolean shouldConsume() {
            return true;
        }

        @Override
        public void draw() {
            super.draw();
            if (!Vars.state.isCampaign()) {
                return;
            }
            if (LaunchPad.this.lightRegion.found()) {
                Draw.color(LaunchPad.this.lightColor);
                float progress = Math.min((float)this.items.total() / (float)LaunchPad.this.itemCapacity, this.timer.getTime(LaunchPad.this.timerLaunch) / (LaunchPad.this.launchTime / this.timeScale));
                int steps = 3;
                float step = 1.0f;
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < steps; ++j) {
                        float alpha = Mathf.curve(progress, (float)j / (float)steps, ((float)j + 1.0f) / (float)steps);
                        float offset = -((float)j - 1.0f) * step;
                        Draw.color(Pal.metalGrayDark, LaunchPad.this.lightColor, alpha);
                        Draw.rect(LaunchPad.this.lightRegion, this.x + (float)Geometry.d8edge((int)i).x * offset, this.y + (float)Geometry.d8edge((int)i).y * offset, (float)(i * 90));
                    }
                }
                Draw.reset();
            }
            float cooldown = Mathf.clamp(this.timer.getTime(LaunchPad.this.timerLaunch) / (90.0f / this.timeScale));
            Draw.mixcol(LaunchPad.this.lightColor, 1.0f - cooldown);
            Draw.rect(LaunchPad.this.podRegion, this.x, this.y);
            Draw.reset();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < LaunchPad.this.itemCapacity;
        }

        @Override
        public void updateTile() {
            if (!Vars.state.isCampaign()) {
                return;
            }
            if (this.items.total() >= LaunchPad.this.itemCapacity && this.efficiency() >= 1.0f && this.timer(LaunchPad.this.timerLaunch, LaunchPad.this.launchTime / this.timeScale)) {
                LaunchPad.this.launchSound.at(this.x, this.y);
                LaunchPayload entity = LaunchPayload.create();
                this.items.each((item, amount) -> entity.stacks.add(new ItemStack(item, amount)));
                entity.set(this);
                entity.lifetime(120.0f);
                entity.team(this.team);
                entity.add();
                Fx.launchPod.at(this);
                this.items.clear();
                Effect.shake(3.0f, 3.0f, this);
            }
        }

        @Override
        public void display(Table table) {
            super.display(table);
            if (!Vars.state.isCampaign()) {
                return;
            }
            table.row();
            table.label(() -> {
                Sector dest = Vars.state.rules.sector == null ? null : Vars.state.rules.sector.info.getRealDestination();
                return Core.bundle.format("launch.destination", dest == null ? Core.bundle.get("sectors.nonelaunch") : "[accent]" + dest.name());
            }).pad(4.0f).wrap().width(200.0f).left();
        }

        @Override
        public void buildConfiguration(Table table) {
            if (!Vars.state.isCampaign() || Vars.net.client()) {
                this.deselect();
                return;
            }
            table.button((Drawable)Icon.upOpen, Styles.clearTransi, () -> {
                Vars.ui.planet.showSelect(Vars.state.rules.sector, other -> {
                    if (Vars.state.isCampaign()) {
                        Vars.state.rules.sector.info.destination = other;
                    }
                });
                this.deselect();
            }).size(40.0f);
        }
    }
}

