/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Drawc;
import mindustry.gen.ForceDraw;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ForceProjector
extends Block {
    public final int timerUse;
    public float phaseUseTime;
    public float phaseRadiusBoost;
    public float phaseShieldBoost;
    public float radius;
    public float shieldHealth;
    public float cooldownNormal;
    public float cooldownLiquid;
    public float cooldownBrokenBase;
    public float basePowerDraw;
    public TextureRegion topRegion;
    static ForceBuild paramEntity;
    static final Cons<Bullet> shieldConsumer;

    public ForceProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.phaseUseTime = 350.0f;
        this.phaseRadiusBoost = 80.0f;
        this.phaseShieldBoost = 400.0f;
        this.radius = 101.7f;
        this.shieldHealth = 700.0f;
        this.cooldownNormal = 1.75f;
        this.cooldownLiquid = 1.5f;
        this.cooldownBrokenBase = 0.35f;
        this.basePowerDraw = 0.2f;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasLiquids = true;
        this.hasItems = true;
        this.ambientSound = Sounds.shield;
        this.ambientSoundVolume = 0.08f;
        this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.1f)).boost().update(false);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("shield", entity -> new Bar("stat.shieldhealth", Pal.accent, () -> entity.broken ? 0.0f : 1.0f - entity.buildup / (this.shieldHealth + this.phaseShieldBoost * entity.phaseHeat)).blink(Color.white));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shieldHealth, this.shieldHealth, StatUnit.none);
        this.stats.add(Stat.cooldownTime, (int)(this.shieldHealth / this.cooldownBrokenBase / 60.0f), StatUnit.seconds);
        this.stats.add(Stat.powerUse, this.basePowerDraw * 60.0f, StatUnit.powerSecond);
        this.stats.add(Stat.boostEffect, this.phaseRadiusBoost / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.boostEffect, this.phaseShieldBoost, StatUnit.shieldHealth);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Draw.color(Pal.gray);
        Lines.stroke(3.0f);
        Lines.poly((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, 6, this.radius);
        Draw.color(Vars.player.team().color);
        Lines.stroke(1.0f);
        Lines.poly((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, 6, this.radius);
        Draw.color();
    }

    static {
        shieldConsumer = trait -> {
            if (trait.team != ForceProjector.paramEntity.team && trait.type.absorbable && Intersector.isInsideHexagon(ForceProjector.paramEntity.x, ForceProjector.paramEntity.y, paramEntity.realRadius() * 2.0f, trait.x(), trait.y())) {
                trait.absorb();
                Fx.absorb.at((Position)trait);
                ForceProjector.paramEntity.hit = 1.0f;
                ForceProjector.paramEntity.buildup += trait.damage() * ForceProjector.paramEntity.warmup;
            }
        };
    }

    public class ForceBuild
    extends Building
    implements Ranged {
        public boolean broken = true;
        public float buildup;
        public float radscl;
        public float hit;
        public float warmup;
        public float phaseHeat;
        public ForceDraw drawer;

        @Override
        public float range() {
            return this.realRadius();
        }

        @Override
        public void created() {
            super.created();
            this.drawer = ForceDraw.create();
            this.drawer.build = this;
            this.drawer.set(this.x, this.y);
            this.drawer.add();
        }

        @Override
        public boolean shouldAmbientSound() {
            return !this.broken && this.realRadius() > 1.0f;
        }

        @Override
        public void onRemoved() {
            float radius = this.realRadius();
            if (!this.broken && radius > 1.0f) {
                Fx.forceShrink.at(this.x, this.y, radius, this.team.color);
            }
            super.onRemoved();
            this.drawer.remove();
        }

        @Override
        public void updateTile() {
            float realRadius;
            boolean phaseValid = ((Consume)ForceProjector.this.consumes.get(ConsumeType.item)).valid(this);
            this.phaseHeat = Mathf.lerpDelta(this.phaseHeat, Mathf.num(phaseValid), 0.1f);
            if (phaseValid && !this.broken && this.timer(ForceProjector.this.timerUse, ForceProjector.this.phaseUseTime) && this.efficiency() > 0.0f) {
                this.consume();
            }
            this.radscl = Mathf.lerpDelta(this.radscl, this.broken ? 0.0f : this.warmup, 0.05f);
            if (Mathf.chanceDelta(this.buildup / ForceProjector.this.shieldHealth * 0.1f)) {
                Fx.reactorsmoke.at(this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
            }
            this.warmup = Mathf.lerpDelta(this.warmup, this.efficiency(), 0.1f);
            if (this.buildup > 0.0f) {
                float scale = !this.broken ? ForceProjector.this.cooldownNormal : ForceProjector.this.cooldownBrokenBase;
                ConsumeLiquidFilter cons = (ConsumeLiquidFilter)ForceProjector.this.consumes.get(ConsumeType.liquid);
                if (cons.valid(this)) {
                    cons.update(this);
                    scale *= ForceProjector.this.cooldownLiquid * (1.0f + (this.liquids.current().heatCapacity - 0.4f) * 0.9f);
                }
                this.buildup -= this.delta() * scale;
            }
            if (this.broken && this.buildup <= 0.0f) {
                this.broken = false;
            }
            if (this.buildup >= ForceProjector.this.shieldHealth + ForceProjector.this.phaseShieldBoost * this.phaseHeat && !this.broken) {
                this.broken = true;
                this.buildup = ForceProjector.this.shieldHealth;
                Fx.shieldBreak.at(this.x, this.y, this.realRadius(), this.team.color);
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
            if ((realRadius = this.realRadius()) > 0.0f && !this.broken) {
                paramEntity = this;
                Groups.bullet.intersect(this.x - realRadius, this.y - realRadius, realRadius * 2.0f, realRadius * 2.0f, shieldConsumer);
            }
        }

        public float realRadius() {
            return (ForceProjector.this.radius + this.phaseHeat * ForceProjector.this.phaseRadiusBoost) * this.radscl;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.buildup;
            }
            return super.sense(sensor);
        }

        @Override
        public void draw() {
            super.draw();
            if (this.drawer != null) {
                this.drawer.set(this.x, this.y);
            }
            if (this.buildup > 0.0f) {
                Draw.alpha(this.buildup / ForceProjector.this.shieldHealth * 0.75f);
                Draw.blend(Blending.additive);
                Draw.rect(ForceProjector.this.topRegion, this.x, this.y);
                Draw.blend();
                Draw.reset();
            }
        }

        public void drawShield() {
            if (!this.broken) {
                float radius = this.realRadius();
                Draw.z(125.0f);
                Draw.color(this.team.color, Color.white, Mathf.clamp(this.hit));
                if (Core.settings.getBool("animatedshields")) {
                    Fill.poly(this.x, this.y, 6, radius);
                } else {
                    Lines.stroke(1.5f);
                    Draw.alpha(0.09f + Mathf.clamp(0.08f * this.hit));
                    Fill.poly(this.x, this.y, 6, radius);
                    Draw.alpha(1.0f);
                    Lines.poly(this.x, this.y, 6, radius);
                    Draw.reset();
                }
            }
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.broken);
            write.f(this.buildup);
            write.f(this.radscl);
            write.f(this.warmup);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.broken = read.bool();
            this.buildup = read.f();
            this.radscl = read.f();
            this.warmup = read.f();
            this.phaseHeat = read.f();
        }
    }

    abstract class ForceDrawComp
    implements Drawc {
        transient ForceBuild build;

        ForceDrawComp() {
        }

        @Override
        public void draw() {
            this.build.drawShield();
        }

        @Override
        public float clipSize() {
            return this.build.realRadius() * 3.0f;
        }
    }
}

