/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MendProjector
extends Block {
    public final int timerUse;
    public Color baseColor;
    public Color phaseColor;
    public TextureRegion topRegion;
    public float reload;
    public float range;
    public float healPercent;
    public float phaseBoost;
    public float phaseRangeBoost;
    public float useTime;

    public MendProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.baseColor = Color.valueOf("84f491");
        this.phaseColor = Color.valueOf("ffd59e");
        this.reload = 250.0f;
        this.range = 60.0f;
        this.healPercent = 12.0f;
        this.phaseBoost = 12.0f;
        this.phaseRangeBoost = 50.0f;
        this.useTime = 400.0f;
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.repairTime, (int)(100.0f / this.healPercent * this.reload / 60.0f), StatUnit.seconds);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.boostEffect, this.phaseRangeBoost / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.boostEffect, (this.phaseBoost + this.healPercent) / this.healPercent, StatUnit.timesSpeed);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, this.baseColor);
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, other -> true, other -> Drawf.selected(other, Tmp.c1.set(this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
    }

    public class MendBuild
    extends Building
    implements Ranged {
        float heat;
        float charge;
        float phaseHeat;
        float smoothEfficiency;

        public MendBuild() {
            this.charge = Mathf.random(MendProjector.this.reload);
        }

        @Override
        public float range() {
            return MendProjector.this.range;
        }

        @Override
        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta(this.smoothEfficiency, this.efficiency(), 0.08f);
            this.heat = Mathf.lerpDelta(this.heat, this.consValid() || this.cheating() ? 1.0f : 0.0f, 0.08f);
            this.charge += this.heat * this.delta();
            this.phaseHeat = Mathf.lerpDelta(this.phaseHeat, Mathf.num(this.cons.optionalValid()), 0.1f);
            if (this.cons.optionalValid() && this.timer(MendProjector.this.timerUse, MendProjector.this.useTime) && this.efficiency() > 0.0f) {
                this.consume();
            }
            if (this.charge >= MendProjector.this.reload) {
                float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
                this.charge = 0.0f;
                Vars.indexer.eachBlock(this, realRange, other -> other.damaged(), other -> {
                    other.heal(other.maxHealth() * (MendProjector.this.healPercent + this.phaseHeat * MendProjector.this.phaseBoost) / 100.0f * this.efficiency());
                    Fx.healBlockFull.at(other.x, other.y, (float)other.block.size, Tmp.c1.set(MendProjector.this.baseColor).lerp(MendProjector.this.phaseColor, this.phaseHeat));
                });
            }
        }

        @Override
        public void drawSelect() {
            float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
            Vars.indexer.eachBlock(this, realRange, other -> true, other -> Drawf.selected(other, Tmp.c1.set(MendProjector.this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
            Drawf.dashCircle(this.x, this.y, realRange, MendProjector.this.baseColor);
        }

        @Override
        public void draw() {
            super.draw();
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color(MendProjector.this.baseColor, MendProjector.this.phaseColor, this.phaseHeat);
            Draw.alpha(this.heat * Mathf.absin(Time.time, 10.0f, 1.0f) * 0.5f);
            Draw.rect(MendProjector.this.topRegion, this.x, this.y);
            Draw.alpha(1.0f);
            Lines.stroke((2.0f * f + 0.2f) * this.heat);
            Lines.square(this.x, this.y, Math.min(1.0f + (1.0f - f) * (float)MendProjector.this.size * 8.0f / 2.0f, (float)(MendProjector.this.size * 8) / 2.0f));
            Draw.reset();
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, 50.0f * this.smoothEfficiency, MendProjector.this.baseColor, 0.7f * this.smoothEfficiency);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.phaseHeat = read.f();
        }
    }
}

